/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.saldotitulo;

import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitProvReal;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitTipoRet;
import com.touchcomp.basementor.model.impl.SaldoFinanceiroPessoa;
import com.touchcomp.basementor.model.impl.SaldoFinanceiroTituloPessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.dao.impl.DaoSaldoTitulosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceSaldoTitulos;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSaldoTituloImpl
extends ServiceGenericImpl
implements ServiceSaldoTitulos {
    @Autowired
    private DaoSaldoTitulosImpl daoSaldoTitulo;

    @Override
    public Double getSaldoDevedorPessoa(long idPessoa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        SaldoFinanceiroPessoa saldo = this.daoSaldoTitulo.getSaldoAbertoPessoa(dataConsulta, null, idPessoa, null, null, null, null, null, null, null, pagRec, tipoPessoaGrupo);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    @Override
    public Double getSaldoDevedorGrupoPessoa(long idGrupoPessoa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        SaldoFinanceiroPessoa saldo = this.daoSaldoTitulo.getSaldoAbertoPessoa(dataConsulta, null, idGrupoPessoa, null, null, null, null, null, null, null, pagRec, tipoPessoaGrupo);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    @Override
    public Double getSaldoVencidoPessoa(long idPessoa, int diasTolerancia, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        SaldoFinanceiroPessoa saldo = this.daoSaldoTitulo.getSaldoAbertoVencidoPessoa(dataConsulta, idPessoa, null, null, null, null, null, pagRec, null, null, diasTolerancia, tipoPessoaGrupo);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    @Override
    public Double getSaldoVencidoGrupoPessoa(long idGrupoPessoa, int diasTolerancia, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        SaldoFinanceiroPessoa saldo = this.daoSaldoTitulo.getSaldoAbertoVencidoPessoa(dataConsulta, idGrupoPessoa, null, null, null, null, null, pagRec, null, null, diasTolerancia, tipoPessoaGrupo);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    @Override
    public Double getSaldoVencidoPessoa(long idPessoa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        return this.getSaldoVencidoPessoa(idPessoa, 0, pagRec, tipoPessoaGrupo, dataConsulta);
    }

    @Override
    public Double getSaldoVencidoGrupoPessoa(long idGrupoPessoa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        return this.getSaldoVencidoGrupoPessoa(idGrupoPessoa, 0, pagRec, tipoPessoaGrupo, dataConsulta);
    }

    @Override
    public Double getSaldoTitulosAVencer(Long idPessoa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        SaldoFinanceiroPessoa saldo = this.daoSaldoTitulo.getSaldoAbertoVencidoPessoa(dataConsulta, idPessoa, null, null, null, null, null, pagRec, null, null, 0, tipoPessoaGrupo);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    @Override
    public SaldoFinanceiroPessoa getSaldoAbertoPessoa(Date dataSaldo, Date dataInicioEmissao, Long idPessoa, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        return this.daoSaldoTitulo.getSaldoAbertoPessoa(dataSaldo, dataInicioEmissao, idPessoa, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, tipoPessoaGrupo);
    }

    @Override
    public SaldoFinanceiroPessoa getSaldoAbertoVencidoPessoa(Date dataInicioEmissao, Long idPessoa, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        return this.daoSaldoTitulo.getSaldoAbertoVencidoPessoa(dataInicioEmissao, idPessoa, idCarteiraIn, idCarteiraFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, dataCompIn, dataCompFim, diasTolerancia, tipoPessoaGrupoPessoa);
    }

    @Override
    public List<SaldoFinanceiroPessoa> getSaldoAbertoPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        return this.daoSaldoTitulo.getSaldoAbertoPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, tipoPessoaGrupo);
    }

    @Override
    public List<SaldoFinanceiroTituloPessoa> getSaldoTitulosPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, Date dataCompIn, Date dataCompFim, EnumConstSaldoTitPagRec tipoPagRec, EnumConstSaldoTitProvReal provReal, EnumConstSaldoTitTipoRet tipoSaldoRet, Integer firstRegister, Integer maxResult, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        return this.daoSaldoTitulo.getSaldoTitulosPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataCompIn, dataCompFim, tipoPagRec, provReal, tipoSaldoRet, firstRegister, maxResult, tipoPessoaGrupo);
    }

    @Override
    public List<SaldoFinanceiroPessoa> getSaldoAbertoPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Integer firstReg, Integer maxReg, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        return this.daoSaldoTitulo.getSaldoAbertoPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, firstReg, maxReg, tipoPessoaGrupoPessoa);
    }

    @Override
    public List<SaldoFinanceiroPessoa> getSaldosAbertoVencidoPessoas(Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        return this.daoSaldoTitulo.getSaldosAbertoVencidoPessoas(dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, dataCompIn, dataCompFim, diasTolerancia, tipoPessoaGrupoPessoa);
    }

    @Override
    public List<SaldoFinanceiroPessoa> getSaldosAbertoVencidoPessoas(Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer firstRes, Integer maxResult, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        return this.daoSaldoTitulo.getSaldosAbertoVencidoPessoas(dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, dataCompIn, dataCompFim, firstRes, maxResult, diasTolerancia, tipoPessoaGrupoPessoa);
    }

    @Override
    public List<SaldoFinanceiroPessoa> getSaldosAbertoVencidoPessoasComp(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Date dataEntSaiIn, Date dataEntSaiFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        return this.daoSaldoTitulo.getSaldosAbertoPessoasComp(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, dataCompIn, dataCompFim, dataEntSaiIn, dataEntSaiFim, diasTolerancia, tipoPessoaGrupoPessoa);
    }

    @Override
    public SaldoFinanceiroPessoa getSaldosAbertoPessoasComp(Date dataSaldo, Date dataInicioEmissao, Long idPessoa, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        List<SaldoFinanceiroPessoa> saldos = this.daoSaldoTitulo.getSaldosAbertoPessoasComp(dataSaldo, dataInicioEmissao, idPessoa, idPessoa, idCarteiraIn, idCarteiraFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, pagRec, dataCompIn, dataCompFim, null, null, diasTolerancia, tipoPessoaGrupoPessoa);
        if (saldos == null || saldos.isEmpty()) {
            return new SaldoFinanceiroPessoa();
        }
        return saldos.get(0);
    }

    @Override
    public Double getSaldoTitulo(Titulo titulo, Date dataConsulta) {
        return this.daoSaldoTitulo.getSaldoTitulo(titulo, dataConsulta);
    }

    @Override
    public Double getSaldoTitulo(Titulo titulo) {
        return this.daoSaldoTitulo.getSaldoTitulo(titulo);
    }

    public Double getSaldoVencidoPessoaExcluindoDiasNaoUteis(long idPessoa, int diasTolerancia, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo, Date dataConsulta) {
        Date vencFinal = new Date();
        vencFinal = ToolDate.previousDays((Date)vencFinal, (int)(1 + diasTolerancia));
        List<Titulo> titulos = this.daoSaldoTitulo.getTitulosAbertosPorPessoa(idPessoa, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, tipoPessoaGrupo);
        Double valor = 0.0;
        for (Titulo titulo : titulos) {
            Date dataVenc = titulo.getDataVencimento();
            Date dataVencCalc = ToolDate.previousDays((Date)new Date(), (int)7);
            Date dataAtual = ToolDate.dataSemHora((Date)new Date());
            if (!dataVenc.before(dataAtual)) continue;
            if (dataVenc.after(dataVencCalc)) {
                if (!(dataVenc = ToolDate.dataSemHora((Date)this.getDataExcluindoDiasNaoUteis(dataVenc))).before(dataAtual)) continue;
                valor = valor + titulo.getValorSaldo();
                continue;
            }
            valor = valor + titulo.getValorSaldo();
        }
        return valor;
    }

    private Date getDataExcluindoDiasNaoUteis(Date dataVencimento) {
        Date data = dataVencimento;
        Integer diaSemana = ToolDate.diaDaSemana((Date)dataVencimento);
        if (diaSemana.equals(7)) {
            data = ToolDate.nextDays((Date)data, (int)1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1)) {
            data = ToolDate.nextDays((Date)data, (int)1);
        }
        if (this.existeFeriadoNacional(data).booleanValue()) {
            diaSemana = ToolDate.diaDaSemana((Date)(data = ToolDate.nextDays((Date)data, (int)1)));
            if (diaSemana.equals(7)) {
                data = ToolDate.nextDays((Date)data, (int)1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1)) {
                data = ToolDate.nextDays((Date)data, (int)1);
            }
        }
        return data;
    }

    private Boolean existeFeriadoNacional(Date data) {
        ServiceFeriadoImpl serviceFeriado = (ServiceFeriadoImpl)ConfApplicationContext.getBean(ServiceFeriadoImpl.class);
        return serviceFeriado.isFeriadoNacional(data);
    }

    public List<SaldoFinanceiroTituloPessoa> getSaldoTitulosPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, String carteiras, Date dataIn, Date dataFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, Date dataVencIn, Date dataVencFim, EnumConstSaldoTitPagRec tipoPagRel, EnumConstSaldoTitProvReal tipoProvRel, EnumConstSaldoTitTipoRet tipoSaldoRet, int firstReg, int nrReg, EnumConstSaldoTitPessoaGrupoPessoa tipoSaldoPessoaGrupo) {
        return this.daoSaldoTitulo.getSaldoTitulosPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, carteiras, dataIn, dataFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataVencIn, dataVencFim, tipoPagRel, tipoProvRel, tipoSaldoRet, firstReg, nrReg, tipoSaldoPessoaGrupo);
    }
}

