/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.saneamentodadoscolaborador;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstRegistroESocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemSaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.SaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.rescisao.CompRescisao;
import com.touchcomp.basementorservice.components.saneamentocolaborador.CompSaneamentoColaborador;
import com.touchcomp.basementorservice.dao.impl.DaoSaneamentoDadosColaboradorImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementorservice.service.impl.terminotrabalhadorsemvinculo.ServiceTerminoTrabalhadorSemVinculoImpl;
import com.touchcomp.basementorservice.service.impl.tipoeventoesocial.ServiceTipoEventoEsocialImpl;
import com.touchcomp.touchvomodel.vo.saneamentodadoscolaborador.web.DTOSaneamentoDadosColaborador;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSaneamentoDadosColaboradorImpl
extends ServiceGenericEntityImpl<SaneamentoDadosColaborador, Long, DaoSaneamentoDadosColaboradorImpl> {
    @Autowired
    private ServiceColaboradorImpl serviceColaborador;
    @Autowired
    private ServiceTipoEventoEsocialImpl serviceTipoEventoESocial;
    @Autowired
    private ServiceRecisaoImpl serviceRecisao;
    @Autowired
    private ServiceTerminoTrabalhadorSemVinculoImpl serviceTerminoTrabalhadorSemVinculo;
    @Autowired
    private CompSaneamentoColaborador compSaneamentoESocial;
    @Autowired
    private CompRescisao compRescisao;

    @Autowired
    public ServiceSaneamentoDadosColaboradorImpl(DaoSaneamentoDadosColaboradorImpl dao) {
        super(dao);
    }

    @Override
    public SaneamentoDadosColaborador beforeSave(SaneamentoDadosColaborador vo) {
        if (this.isNotNull(vo.getItemSaneamento()).booleanValue()) {
            vo.getItemSaneamento().forEach(i -> i.setSaneamentoDadosColaborador(vo));
        }
        if (this.isNotNull(vo.getItemSaneamentoLiberados()).booleanValue()) {
            vo.getItemSaneamentoLiberados().forEach(i -> i.setSaneamentoDadosColaborador(vo));
        }
        return vo;
    }

    public void gerarEventosItemSaneamento(SaneamentoDadosColaborador vo, Usuario usuario, Empresa empresa, EmpresaRh empresaRh) throws ExceptionEsocial {
        Integer totalEventosContabilizaods = 0;
        if (ServiceSaneamentoDadosColaboradorImpl.isWithData(vo.getItemSaneamento()) && this.isNotNull(vo.getTipoEvento()).booleanValue()) {
            this.reload(empresa);
            this.reload(usuario);
            this.reload(empresaRh);
            for (ItemSaneamentoDadosColaborador item : vo.getItemSaneamento()) {
                Integer n;
                if (!this.isEquals(vo.getTipoEvento().getIdentificador(), EnumConstRegistroESocial.REGISTRO_2299.getValue()) && !this.isEquals(vo.getTipoEvento().getIdentificador(), EnumConstRegistroESocial.REGISTRO_2399.getValue())) {
                    Colaborador colaborador = item.getColaborador();
                    if (this.is2200(colaborador) && this.isAffimative(item.getLiberado())) {
                        this.compSaneamentoESocial.geracaoEventoS2200(colaborador, usuario, empresa);
                        n = totalEventosContabilizaods;
                        totalEventosContabilizaods = totalEventosContabilizaods + 1;
                        continue;
                    }
                    if (!this.is2300(colaborador) || !this.isAffimative(item.getLiberado())) continue;
                    this.compSaneamentoESocial.geracaoEventoS2300(colaborador, usuario, empresa);
                    n = totalEventosContabilizaods;
                    totalEventosContabilizaods = totalEventosContabilizaods + 1;
                    continue;
                }
                if (this.isEquals(vo.getTipoEvento().getIdentificador(), EnumConstRegistroESocial.REGISTRO_2299.getValue()) && this.isAffimative(item.getLiberado())) {
                    Recisao recisao = item.getRecisao();
                    this.compRescisao.geracaoEventoS2299(recisao, usuario, empresa, empresaRh);
                    n = totalEventosContabilizaods;
                    totalEventosContabilizaods = totalEventosContabilizaods + 1;
                    continue;
                }
                if (!this.isEquals(vo.getTipoEvento().getIdentificador(), EnumConstRegistroESocial.REGISTRO_2399.getValue()) || !this.isAffimative(item.getLiberado())) continue;
                TerminoTrabalhadorSemVinculo t = item.getTermino();
                this.compSaneamentoESocial.geracaoEventoS2299(t, usuario, empresa);
                n = totalEventosContabilizaods;
                totalEventosContabilizaods = totalEventosContabilizaods + 1;
            }
            if (totalEventosContabilizaods <= 0) {
                throw new ExceptionRuntimeBase("E.ERP.1682.006");
            }
        }
    }

    private boolean is2200(Colaborador colaborador) {
        return this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.EMPREGADO.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.MENOR_APRENDIZ.getValue());
    }

    private boolean is2300(Colaborador colaborador) {
        return this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.ESTAGIARIO.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO_FRETE.getValue());
    }

    public List<DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador> buildSaneamentoESocial(Long idTipoEvt, GrupoEmpresa grupo) throws ExceptionObjNotFound {
        TipoEventoEsocial tipoEvento = (TipoEventoEsocial)this.serviceTipoEventoESocial.getOrThrow(idTipoEvt);
        List<Colaborador> colaboradores = this.serviceColaborador.findColaboradoresByTipoColaboradorEsoc(tipoEvento, grupo, null, null);
        List<ItemSaneamentoDadosColaborador> itens = this.compSaneamentoESocial.buildSaneamentoESocial(colaboradores);
        return this.buildToDTOGeneric(itens, DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador.class);
    }

    public List<DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador> buildSaneamentoESocialColaboradores(Long[] identificadores) throws ExceptionObjNotFound, ExceptionInvalidData {
        List colaboradores = this.serviceColaborador.gets(identificadores);
        if (!ServiceSaneamentoDadosColaboradorImpl.isWithData(colaboradores)) {
            throw new ExceptionInvalidData("E.ERP.1682.001", new Object[0]);
        }
        List<ItemSaneamentoDadosColaborador> itens = this.compSaneamentoESocial.buildSaneamentoESocial(colaboradores);
        return this.buildToDTOGeneric(itens, DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador.class);
    }

    public List<DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador> buildSaneamentoESocialRescisoes(Long[] identificadores) throws ExceptionObjNotFound, ExceptionInvalidData {
        List rescisoes = this.serviceRecisao.gets(identificadores);
        if (!ServiceSaneamentoDadosColaboradorImpl.isWithData(rescisoes)) {
            throw new ExceptionInvalidData("E.ERP.1682.002", new Object[0]);
        }
        List<ItemSaneamentoDadosColaborador> itens = this.compSaneamentoESocial.buildSaneamentoESocialRescisao(rescisoes);
        return this.buildToDTOGeneric(itens, DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador.class);
    }

    public List<DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador> buildSaneamentoESocialTerminos(Long[] identificadores) throws ExceptionObjNotFound, ExceptionInvalidData {
        List terminos = this.serviceTerminoTrabalhadorSemVinculo.gets(identificadores);
        if (!ServiceSaneamentoDadosColaboradorImpl.isWithData(terminos)) {
            throw new ExceptionInvalidData("E.ERP.1682.002", new Object[0]);
        }
        List<ItemSaneamentoDadosColaborador> itens = this.compSaneamentoESocial.buildSaneamentoESocialTermino(terminos);
        return this.buildToDTOGeneric(itens, DTOSaneamentoDadosColaborador.DTOItemSaneamentoDadosColaborador.class);
    }
}

