/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.searchentities;

import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.finder.BaseEnumFieldOption;
import com.touchcomp.basementor.constants.enums.searchclass.EnumSearchType;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.SearchClass;
import com.touchcomp.basementor.model.vo.SearchClassUserPref;
import com.touchcomp.basementor.model.vo.TokenQrCode;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidStateRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.finder.model.TempSearchClassParams;
import com.touchcomp.basementorservice.components.finder.model.TempSearchClassResult;
import com.touchcomp.basementorservice.dao.impl.searchentities.DaoServiceEntityFinder;
import com.touchcomp.basementorservice.service.UtilServiceClass;
import com.touchcomp.basementorservice.service.impl.searchclass.ServiceSearchClassImpl;
import com.touchcomp.basementorservice.service.impl.searchentities.ServiceSearchEntityImpl;
import com.touchcomp.basementorservice.service.impl.servicesearclassuserpref.ServiceSearchClassUserPrefImpl;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.web.WebDTOAutoCompleteEntitiesFilter;
import com.touchcomp.touchvomodel.web.WebDTOAutoCompleteEntitiesFilterRes;
import com.touchcomp.touchvomodel.web.WebDTOEntityRes;
import com.touchcomp.touchvomodel.web.WebDTOMultipleEntitiesFilter;
import com.touchcomp.touchvomodel.web.WebDTOSearchClassOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ServiceEntityFinder
extends ServiceSearchEntityImpl {
    @Autowired
    DaoServiceEntityFinder daoServiceEntityFinder;
    @Autowired
    ServiceSearchClassUserPrefImpl serviceSearchClassUserPref;
    @Autowired
    ServiceSearchClassImpl serviceSearchClass;

    public List<WebDTOEntityRes> getAutoCompleteEntitiesRes(WebDTOAutoCompleteEntitiesFilterRes entityFilter, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        return this.getAutoCompleteEntitiesRes(entityFilter, null, defValues, otherValues);
    }

    public List<WebDTOEntityRes> getAutoCompleteEntitiesRes(WebDTOAutoCompleteEntitiesFilterRes entityFilter, Nodo nodo, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        SearchClass search = this.getSearchClazz(entityFilter.getEntityClass());
        List<WebDTOEntityRes> res = this.daoServiceEntityFinder.getAutoCompleteEntitiesRes(entityFilter, search, nodo, defValues, otherValues);
        return res;
    }

    public List<?> getEntities(WebDTOMultipleEntitiesFilter entityFilter, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        try {
            SearchClass search = this.getSearchClazz(entityFilter.getEntityClass());
            Class<?> entityClazz = Class.forName(search.getVoClass());
            Class<?> dtoClazz = Class.forName(UtilServiceClass.getFullPathDTO(entityFilter.getDtoClass()));
            List<?> entities = this.daoServiceEntityFinder.getEntities(search, entityFilter.getIdsEntities(), defValues, otherValues);
            return new ToolDTOBuilder(entityClazz, dtoClazz).toDTO(entities);
        }
        catch (ClassNotFoundException ex) {
            this.getLogger().error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
    }

    public List<?> getEntities(WebDTOMultipleEntitiesFilter entityFilter, Nodo nodo, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        try {
            SearchClass search = this.getSearchClazz(entityFilter.getEntityClass());
            Class<?> entityClazz = Class.forName(search.getVoClass());
            Class<?> dtoClazz = Class.forName(UtilServiceClass.getFullPathDTO(entityFilter.getDtoClass()));
            List<?> entities = this.daoServiceEntityFinder.getEntities(search, entityFilter.getIdsEntities(), nodo, defValues, otherValues);
            return new ToolDTOBuilder(entityClazz, dtoClazz).toDTO(entities);
        }
        catch (ClassNotFoundException ex) {
            this.getLogger().error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
    }

    public List<?> getAutoCompleteEntities(WebDTOAutoCompleteEntitiesFilter entityFilter, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        return this.getAutoCompleteEntities(entityFilter, null, defValues, otherValues);
    }

    public List<?> getAutoCompleteEntities(WebDTOAutoCompleteEntitiesFilter entityFilter, Nodo nodo, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        try {
            SearchClass search = this.getSearchClazz(entityFilter.getEntityClass());
            Class<?> entityClazz = Class.forName(search.getVoClass());
            Class dtoClazz = this.getAndCheckIfExists(UtilServiceClass.getFullPathDTO(entityFilter.getDtoClass()));
            if (dtoClazz == null) {
                dtoClazz = this.getAndCheckIfExists(UtilServiceClass.getFullPathDTORes(entityFilter.getDtoClass()));
            }
            if (dtoClazz == null) {
                dtoClazz = this.getAndCheckIfExists(UtilServiceClass.getFullPathEntityDTO(entityFilter.getDtoClass()));
            }
            if (dtoClazz == null) {
                throw new ExceptionReflection(new ClassNotFoundException(entityFilter.getDtoClass()));
            }
            List<?> entities = this.daoServiceEntityFinder.getAutoCompleteEntities(search, nodo, defValues, entityFilter.getStrTyped(), otherValues);
            return new ToolDTOBuilder(entityClazz, dtoClazz).toDTO(entities);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionReflection(e);
        }
    }

    private Class getAndCheckIfExists(String fullPathDTO) {
        try {
            return Class.forName(fullPathDTO);
        }
        catch (ClassNotFoundException ex) {
            this.getLogger().error((Throwable)ex);
            return null;
        }
    }

    public TempSearchClassResult filter(TempSearchClassParams input, Nodo nodo, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        SearchClass search = this.getSearchClazz(input.getEntityClass());
        if (input.getTipoPesquisa() == null) {
            return this.daoServiceEntityFinder.filter(search, input, nodo, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
        }
        switch (input.getTipoPesquisa()) {
            case PESQUISA_INTELIGENTE: {
                return this.daoServiceEntityFinder.filterSmartSearch(search, input, nodo, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
            }
            case PESQUISA_ULT_REGISTROS: {
                return this.daoServiceEntityFinder.filterLastRecords(search, input, nodo, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
            }
        }
        return this.daoServiceEntityFinder.filter(search, input, nodo, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
    }

    public <R> List<R> filterEntities(Class<R> dtoClass, TempSearchClassParams input, Nodo nodo, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        try {
            SearchClass search = this.getSearchClazz(input.getEntityClass());
            EnumSearchType tipoPesquisa = EnumSearchType.PESQUISA_NORMAL;
            if (input.getTipoPesquisa() != null) {
                tipoPesquisa = input.getTipoPesquisa();
            }
            List ret = switch (tipoPesquisa) {
                case EnumSearchType.PESQUISA_INTELIGENTE -> this.daoServiceEntityFinder.filterSmartSearchEntities(search, input, nodo, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
                case EnumSearchType.PESQUISA_ULT_REGISTROS -> this.daoServiceEntityFinder.filterLastRecordsEntities(search, input, nodo, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
                default -> this.daoServiceEntityFinder.filterEntities(search, input, nodo, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
            };
            ToolDTOBuilder t = new ToolDTOBuilder(Class.forName(search.getVoClass()), dtoClass);
            return t.toDTO(ret);
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public TempSearchClassResult filter(TempSearchClassParams input, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        SearchClass search = this.getSearchClazz(input.getEntityClass());
        if (input.getTipoPesquisa() == null) {
            return this.daoServiceEntityFinder.filter(search, input, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
        }
        switch (input.getTipoPesquisa()) {
            case PESQUISA_INTELIGENTE: {
                return this.daoServiceEntityFinder.filterSmartSearch(search, input, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
            }
            case PESQUISA_ULT_REGISTROS: {
                return this.daoServiceEntityFinder.filterLastRecords(search, input, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
            }
        }
        return this.daoServiceEntityFinder.filter(search, input, defValues, otherValues, this.getSharedData().getOpcoesPesquisaWeb());
    }

    @Cacheable(cacheNames={"SEARCH_PARAMS"}, unless="#result == null", keyGenerator="customKeyGenerator")
    public SearchClass getSearchClazz(String clazz) {
        SearchClass search = this.serviceSearchClass.getByClass(clazz = UtilServiceClass.getFullPathEntity(clazz));
        if (search == null) {
            throw new ExceptionInvalidStateRuntime(new ExcepCodeDetail("E.GEN.000019", new String[]{clazz}));
        }
        if (search.getSearchFieldsRes() == null) {
            throw new ExceptionInvalidStateRuntime(new ExcepCodeDetail("E.GEN.000020", new String[]{clazz}));
        }
        return search;
    }

    public WebDTOSearchClassOption getSearchClazzOptions(String fullPathEntity, CapsUsuario capsUsuario) {
        SearchClass search = this.getSearchClazz(fullPathEntity);
        WebDTOSearchClassOption t = new WebDTOSearchClassOption();
        if (search == null) {
            return t;
        }
        t.setDescricao(search.getDescricao());
        t.setIdentificador(search.getIdentificador());
        search.getSearchFields().forEach(i -> {
            if (i != null && ToolMethods.isAffirmative((Number)i.getAtivo()) && ToolMethods.isEquals((Object)i.getFieldTypeOpt(), (Object)BaseEnumFieldOption.NORMAL_FIELD_OPT.value)) {
                WebDTOSearchClassOption.TempSearchClassField f = new WebDTOSearchClassOption.TempSearchClassField();
                f.setText(i.getDescricao());
                f.setFieldClass(i.getFieldClass());
                f.setId(i.getIdentificador());
                f.setIndice(i.getIndice());
                f.setPercSize(i.getPercSize());
                f.setField(i.getPathField());
                OpFinder op = CompRestrictionsFactory.getRestrictions((String)f.getFieldClass());
                op.getRestrictions().forEach(item -> {
                    if (item != null && item.getRestriction() != null) {
                        f.getRetrictions().add(new WebDTOSearchClassOption.TempRestriction(item.getRestriction().name(), item.getDescription()));
                    }
                });
                f.setValue1((Object)op.getDefaultValueStrNative());
                f.setValue2((Object)op.getDefaultValueStrNative());
                t.getSearchFields().add(f);
            }
        });
        SearchClassUserPref pref = this.serviceSearchClassUserPref.get(capsUsuario, search);
        if (pref != null) {
            pref.getFields().forEach(field -> {
                Optional<WebDTOSearchClassOption.TempSearchClassField> found = t.getSearchFields().stream().filter(i -> ToolMethods.isEquals((Object)field.getSearchClassField(), (Object)i)).findFirst();
                if (found.isPresent()) {
                    found.get().setPercSize(field.getColumnSize());
                    found.get().setIndice(field.getIndice());
                }
            });
        }
        Collections.sort(t.getSearchFields());
        return t;
    }

    public Object findObjectById(String searchClass, Long id) {
        return this.daoServiceEntityFinder.findObjectById(searchClass, id);
    }

    public List<Object> findObjectById(String searchClass, Long[] id) {
        return this.daoServiceEntityFinder.findObjectById(searchClass, id);
    }

    public Object evaluateTokenQrCode(SearchClass search, TokenQrCode token, String value) throws ExceptionReflection {
        return this.daoServiceEntityFinder.evaluateTokenQrCode(search, token, value);
    }
}

