/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.searchentities;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsGrUsuario;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.finder.model.TempSearchClassParams;
import com.touchcomp.basementorservice.components.finder.model.TempSearchClassResult;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.UtilServiceClass;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupousuarios.ServiceGrupoUsuariosImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.searchentities.ServiceEntityFinder;
import com.touchcomp.basementorservice.service.impl.servicesearclassuserpref.ServiceSearchClassUserPrefImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.web.WebDTOAutoCompleteEntitiesFilter;
import com.touchcomp.touchvomodel.web.WebDTOAutoCompleteEntitiesFilterRes;
import com.touchcomp.touchvomodel.web.WebDTOEntityRes;
import com.touchcomp.touchvomodel.web.WebDTOMultipleEntitiesFilter;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import com.touchcomp.touchvomodel.web.WebDTOSearchClassOption;
import java.util.List;
import java.util.Map;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ServiceEntityFinderUserPrefImpl
extends ServiceGenericImpl {
    final ServiceEntityFinder serviceEntityFinder;
    final ServiceSearchClassUserPrefImpl serviceSearchClassUserPref;
    final ServiceUsuarioImpl serviceUsuarioImpl;
    final ServiceEmpresaImpl serviceEmpresaImpl;
    final ServiceGrupoUsuariosImpl serviceGrupoUsuariosImpl;
    final CompBIDefaultParams compBIParams;
    final ServiceNodoImpl serviceNodoImpl;

    public ServiceEntityFinderUserPrefImpl(ServiceEntityFinder serviceEntityFinder, ServiceSearchClassUserPrefImpl serviceSearchClassUserPref, ServiceUsuarioImpl serviceUsuarioImpl, ServiceGrupoUsuariosImpl serviceGrupoUsuariosImpl, CompBIDefaultParams compBIParams, ServiceNodoImpl serviceNodoImpl, ServiceEmpresaImpl serviceEmpresaImpl) {
        this.serviceEntityFinder = serviceEntityFinder;
        this.serviceSearchClassUserPref = serviceSearchClassUserPref;
        this.serviceUsuarioImpl = serviceUsuarioImpl;
        this.serviceGrupoUsuariosImpl = serviceGrupoUsuariosImpl;
        this.compBIParams = compBIParams;
        this.serviceNodoImpl = serviceNodoImpl;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
    }

    public List<?> getAutoCompleteEntitiesRes(WebDTOAutoCompleteEntitiesFilterRes entityFilter, CapsEmpresa idEmp, CapsUsuario idUser, CapsGrUsuario idGroup) throws ExceptionReflection {
        List<WebDTOEntityRes> det = this.serviceEntityFinder.getAutoCompleteEntitiesRes(entityFilter, this.getDefValues(idEmp, idUser, idGroup), entityFilter.getOtherParams());
        return det;
    }

    public List<?> getMultipleEntities(WebDTOMultipleEntitiesFilter entityFilter, CapsEmpresa idEmp, CapsUsuario idUser, CapsGrUsuario idGroup) throws ExceptionReflection {
        List<?> det = this.serviceEntityFinder.getEntities(entityFilter, this.getDefValues(idEmp, idUser, idGroup), entityFilter.getOtherParams());
        return det;
    }

    public List<?> getAutoCompleteEntities(WebDTOAutoCompleteEntitiesFilter entityFilter, CapsEmpresa idEmp, CapsUsuario idUser, CapsGrUsuario idGroup) throws ExceptionReflection {
        List<?> det = this.serviceEntityFinder.getAutoCompleteEntities(entityFilter, this.getDefValues(idEmp, idUser, idGroup), entityFilter.getOtherParams());
        return det;
    }

    public TempSearchClassResult getFilterEntities(TempSearchClassParams params, CapsEmpresa idEmp, CapsUsuario idUser, CapsGrUsuario idGroup) throws ExceptionReflection {
        TempSearchClassResult result = this.serviceEntityFinder.filter(params, this.getDefValues(idEmp, idUser, idGroup), params.getOtherParams());
        return result;
    }

    public TempSearchClassResult getFilterEntities(TempSearchClassParams params, Long idNodo, CapsEmpresa idEmp, CapsUsuario idUser, CapsGrUsuario idGroup) throws ExceptionReflection {
        TempSearchClassResult result = this.serviceEntityFinder.filter(params, (Nodo)this.serviceNodoImpl.getWithCache(idNodo), this.getDefValues(idEmp, idUser, idGroup), params.getOtherParams());
        return result;
    }

    public List getFilterEntities(TempSearchClassParams params, Nodo nodo, String dtoClass, CapsEmpresa idEmp, CapsUsuario user, CapsGrUsuario idGroup) throws ExceptionReflection {
        try {
            Class<?> dtoClazz = Class.forName(dtoClass);
            List<?> result = this.serviceEntityFinder.filterEntities(dtoClazz, params, nodo, this.getDefValues(idEmp, user, idGroup), params.getOtherParams());
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public String getFilterOptions(WebDTOEntityRes entity, String maskUrlSearh) throws ExceptionInvalidData {
        if (entity.getDescricao() == null || entity.getDescricao().isEmpty()) {
            throw new ExceptionInvalidData("E.GEN.000009", new Object[]{entity.getDescricao()});
        }
        if (entity.getIdentificador() == null || entity.getIdentificador() <= 0L) {
            throw new ExceptionInvalidData("E.GEN.000010", new Object[]{entity.getDescricao()});
        }
        Nodo nodo = this.serviceNodoImpl.getNodoByVoClass(entity.getDescricao());
        if (nodo == null) {
            throw new ExceptionInvalidData("E.GEN.000011", new Object[]{entity.getDescricao()});
        }
        if (nodo.getPathWeb() == null || nodo.getPathWeb().isEmpty()) {
            throw new ExceptionInvalidData("E.GEN.000012", new Object[]{entity.getDescricao()});
        }
        return ToolString.formatMessage((String)maskUrlSearh, (Object[])new Object[]{nodo.getPathWeb(), entity.getIdentificador()});
    }

    public WebDTOResult<WebDTOSearchClassOption> getFilterOptions(String entity, CapsUsuario idUser) {
        WebDTOResult ret = new WebDTOResult();
        if (entity == null || entity.equalsIgnoreCase("null")) {
            return ret;
        }
        WebDTOSearchClassOption res = this.serviceEntityFinder.getSearchClazzOptions(UtilServiceClass.getFullPathEntity(UtilServiceClass.getFullPathEntity(entity)), idUser);
        ret.setResult((Object)res);
        return ret;
    }

    private Map<String, Object> getDefValues(CapsEmpresa capsEmp, CapsUsuario capsUser, CapsGrUsuario capsUserGroup) {
        return CompBIDefaultParams.getDefParamsMap((Empresa)this.serviceEmpresaImpl.get(capsEmp.get()), (Usuario)this.serviceUsuarioImpl.get(capsUser.get()), (Grupo)this.serviceGrupoUsuariosImpl.get(capsUserGroup.get()), new Object[0]);
    }
}

