/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.servidorcliente;

import com.touchcomp.basementor.model.vo.ClienteContSistemasCnpj;
import com.touchcomp.basementor.model.vo.InformacoesTecnicasCliente;
import com.touchcomp.basementor.model.vo.ServidorCliente;
import com.touchcomp.basementor.model.vo.ServidorClienteConf;
import com.touchcomp.basementor.model.vo.ServidorClienteContSistCnpj;
import com.touchcomp.basementor.model.vo.TipoBDVersao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoServidorClienteImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.clientecontsistemas.ServiceClienteContSistemasCnpjImpl;
import com.touchcomp.basementorservice.service.impl.informacoestecnicascliente.ServiceInformacoesTecnicasClienteImpl;
import com.touchcomp.basementorservice.service.impl.tipobdversao.ServiceTipoBDVersaoImpl;
import com.touchcomp.touchvomodel.vo.informacoestecnicascliente.atualizador.DTOInfTecServidor;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceServidorClienteImpl
extends ServiceGenericEntityImpl<ServidorCliente, Long, DaoServidorClienteImpl> {
    @Autowired
    ServiceClienteContSistemasCnpjImpl serviceClienteContSistemasCnpjImpl;
    @Autowired
    ServiceInformacoesTecnicasClienteImpl serviceInformacoesTecnicasCliente;
    @Autowired
    ServiceTipoBDVersaoImpl serviceTipoBDVersaoImpl;

    @Autowired
    public ServiceServidorClienteImpl(DaoServidorClienteImpl dao) {
        super(dao);
    }

    public List<ServidorCliente> getByCodigoCliente(String codigoCliente) {
        return ((DaoServidorClienteImpl)this.getDao()).getByCodigoCliente(codigoCliente);
    }

    public List<DTOInfTecServidor> getServidores(String codigoCliente, Class<DTOInfTecServidor> aClass) {
        ClienteContSistemasCnpj cli = this.serviceClienteContSistemasCnpjImpl.getByCodigoCliente(codigoCliente);
        if (cli == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1931.001"));
        }
        List<ServidorCliente> serv = ((DaoServidorClienteImpl)this.getDao()).getByCodigoCliente(codigoCliente);
        return this.buildToDTO(serv, DTOInfTecServidor.class);
    }

    public DTOInfTecServidor registrarServidor(String codigoCliente, DTOInfTecServidor dto) {
        ClienteContSistemasCnpj cli = this.serviceClienteContSistemasCnpjImpl.getByCodigoCliente(codigoCliente);
        if (cli == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1931.001"));
        }
        List<ServidorCliente> servidores = ((DaoServidorClienteImpl)this.getDao()).getByCodigoCliente(codigoCliente);
        InformacoesTecnicasCliente in = this.serviceInformacoesTecnicasCliente.getOrCreate(cli);
        ServidorCliente servidor = null;
        Optional<ServidorCliente> found = servidores.stream().filter(i -> this.isEquals(i.getIdentificador(), dto.getIdentificador())).findFirst();
        if (found.isPresent()) {
            servidor = found.get();
        }
        if (servidor == null && (found = servidores.stream().filter(i -> this.isEquals(i.getIpServidor(), dto.getIpServidor())).findFirst()).isPresent()) {
            servidor = found.get();
        }
        if (servidor == null && (found = servidores.stream().filter(i -> this.isEquals(i.getNomeServidor(), dto.getNomeServidor())).findFirst()).isPresent()) {
            servidor = found.get();
        }
        if (servidor == null) {
            servidor = new ServidorCliente();
            servidor.setInformacoesTecnicaCliente(in);
            ServidorClienteContSistCnpj cnpj = new ServidorClienteContSistCnpj();
            cnpj.setClienteContSistemasCnpj(cli);
            cnpj.setServidorCliente(servidor);
            servidor.getClientesCNPJ().add(cnpj);
        }
        servidor.setDescricao(dto.getDescricao());
        servidor.setNomeServidor(dto.getNomeServidor());
        servidor.setIpServidor(dto.getIpServidor());
        servidor.setPortaServidorExternoHttp(dto.getPortaServidorExternoHttp());
        servidor.setPortaServidorExternoHttps(dto.getPortaServidorExternoHttps());
        servidor.setPortaServidorInternoHttps(dto.getPortaServidorInternoHttps());
        servidor.setPortaServidorInternoHttp(dto.getPortaServidorInternoHttp());
        servidor.setPortaBDServidor(dto.getPortaBDServidor());
        servidor.setSenhaBD(dto.getSenhaBD());
        servidor.setUsuarioBD(dto.getUsuarioBD());
        servidor.setMacAddress(dto.getMacAddress());
        if (dto.getConfiguracoes() != null) {
            for (DTOInfTecServidor.DTOInfTecServidorConf conf : dto.getConfiguracoes()) {
                ServidorClienteConf sc;
                Optional<ServidorClienteConf> f = servidor.getConfiguracoes().stream().filter(i -> this.isEquals(i.getTipoBDVersao().getIdentificador(), conf.getTipoBDVersaoIdentificador())).findFirst();
                if (f.isPresent()) {
                    sc = f.get();
                } else {
                    sc = new ServidorClienteConf();
                    servidor.getConfiguracoes().add(sc);
                }
                sc.setAliases(conf.getAliases());
                sc.setPathBD(conf.getPathBD());
                sc.setServidorCliente(servidor);
                sc.setTipoBDVersao((TipoBDVersao)this.serviceTipoBDVersaoImpl.get(conf.getTipoBDVersaoIdentificador()));
            }
        }
        servidor = this.saveOrUpdate(servidor);
        return this.buildToDTO(servidor, DTOInfTecServidor.class);
    }
}

