/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.sindicato;

import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.ItemEventoSindicato;
import com.touchcomp.basementor.model.vo.ItemFuncaoSindicato;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoSindicatoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSindicatoImpl
extends ServiceGenericEntityImpl<Sindicato, Long, DaoSindicatoImpl> {
    @Autowired
    public ServiceSindicatoImpl(DaoSindicatoImpl dao) {
        super(dao);
    }

    @Override
    public Sindicato beforeSave(Sindicato s) {
        s.getFuncoesSindicato().forEach(i -> i.setSindicato(s));
        s.getEventos().forEach(i -> i.setSindicato(s));
        return s;
    }

    public ItemFuncaoSindicato newItemFuncao(Funcao funcao) {
        ItemFuncaoSindicato c = new ItemFuncaoSindicato();
        c.setFuncao(funcao);
        return c;
    }

    public ItemEventoSindicato newItemTipoCalculoEvento(TipoCalculoEvento tipoCalculoEvento) {
        ItemEventoSindicato c = new ItemEventoSindicato();
        c.setTipoCalculo(tipoCalculoEvento);
        return c;
    }

    public Sindicato findByCnpjOrThrow(String cnpj) throws ExceptionObjNotFound {
        if (!ToolMethods.isStrWithData((String)cnpj)) {
            return null;
        }
        Sindicato sindicato = ((DaoSindicatoImpl)this.getDao()).findByCnpj(cnpj);
        this.throwIfNull(sindicato, (Serializable)((Object)cnpj));
        return sindicato;
    }
}

