/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.situacaopedidos;

import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementorservice.dao.impl.DaoSituacaoPedidosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSituacaoPedidosImpl
extends ServiceGenericEntityImpl<SituacaoPedidos, Long, DaoSituacaoPedidosImpl> {
    @Autowired
    public ServiceSituacaoPedidosImpl(DaoSituacaoPedidosImpl genericDao) {
        super(genericDao);
    }

    @Override
    public SituacaoPedidos beforeSave(SituacaoPedidos vo) {
        if (vo.getGrupoDeSituacoes() != null) {
            vo.getGrupoDeSituacoes().forEach(it -> it.setSituacaoPedidos(vo));
        }
        if (vo.getGrupoUsuarios() != null) {
            vo.getGrupoUsuarios().forEach(it -> it.setSituacaoPedidos(vo));
        }
        return vo;
    }

    public List<SituacaoPedidos> findSituacaoPedidos(Grupo grupoUsuarios) {
        if (grupoUsuarios == null) {
            return new LinkedList<SituacaoPedidos>();
        }
        return this.findSituacaoPedidos(grupoUsuarios.getIdentificador());
    }

    public List<SituacaoPedidos> findSituacaoPedidos(Long idGrupoUsuarios) {
        return ((DaoSituacaoPedidosImpl)this.getDao()).findSitPedidos(idGrupoUsuarios);
    }

    public <E> List<E> findSituacaoPedidos(Long idGrupo, Class<E> aClass) {
        List<SituacaoPedidos> sits = this.findSituacaoPedidos(idGrupo);
        return this.buildToDTO(sits, aClass);
    }
}

