/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.smartcomponentarquivo;

import com.touchcomp.basementor.model.vo.SmartComponent;
import com.touchcomp.basementor.model.vo.SmartComponentArquivo;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.entityxml.CompExpImpEntityXML;
import com.touchcomp.basementorservice.dao.impl.DaoSmartComponentArquivoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSmartComponentArquivoImpl
extends ServiceGenericEntityImpl<SmartComponentArquivo, Long, DaoSmartComponentArquivoImpl> {
    @Autowired
    private CompExpImpEntityXML compExpImpEntityXMl;

    @Autowired
    public ServiceSmartComponentArquivoImpl(DaoSmartComponentArquivoImpl genericDao) {
        super(genericDao);
    }

    public void arquivar(SmartComponent bi, Long versaoSistema) throws ExceptionIO {
        SmartComponentArquivo ba = new SmartComponentArquivo();
        ba.setDataArquivamento(new Date());
        ba.setDescricao(bi.getDescricao());
        ba.setIdSmartComponent(bi.getIdentificador());
        ba.setNumeroVersao(bi.getCodigoVersao());
        ba.setNumeroVersaoRep(bi.getNumeroVersaoRep());
        ba.setObservacao(bi.getObservacao());
        byte[] data = this.compExpImpEntityXMl.entityToByte(bi, versaoSistema);
        ba.setDadosSmartComponent(data);
        this.saveOrUpdate(ba);
    }

    public SmartComponent desarquivar(Long idArquivamento, Long versaoSistema) throws ExceptionIO, ExceptionObjNotFound {
        SmartComponentArquivo arq = (SmartComponentArquivo)this.getOrThrow(idArquivamento);
        SmartComponent bi = (SmartComponent)this.compExpImpEntityXMl.byteToEntity(arq.getDadosSmartComponent(), versaoSistema, true, "com.touchcomp.basementor.model.vo");
        return bi;
    }

    public List<SmartComponentArquivo> findArquivamentos(Long idSmartComponent) {
        return ((DaoSmartComponentArquivoImpl)this.getGenericDao()).findArquivamentos(idSmartComponent);
    }
}

