/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.smartcomponente;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.smartcomponente.EnumConstSmartComponente;
import com.touchcomp.basementor.model.examples.DefaultEntitiesTest;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.json.ExceptionJson;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.bderrors.CompBDErrors;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericEntity;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponente;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.SCResultFile;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOFieldToString;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOIgnoreField;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOOnlyView;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOToString;
import com.touchcomp.basementortools.tools.excel.ToolExcel;
import com.touchcomp.basementortools.tools.excel.model.ExcelCellType;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.excel.model.ExcelType;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.model.ValidContainerItem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Id;
import javax.persistence.Version;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BaseSmartCompImpDados<T extends InterfaceVO, DTO, K extends Serializable>
extends BaseSmartComponente {
    private final String outputFileName = "dados_importacao";
    protected static final String NAME_COLUMN_STATUS_IMPORTACAO = "imp:status_importacao";
    protected static final String NAME_COLUMN_OBS_IMPORTACAO = "imp:observacoes_importacao";
    private ServiceGenericEntity<T, K> serviceGenericEntity;
    private ValidGenericEntitiesImpl<T> validEntity;
    private ImportDataListener<T> importDataListener;
    private DefaultEntitiesTest<T> defaultEntityTest;
    private Class<DTO> dtoClass;
    private ExcelType excelType;
    TLogger logger = TLogger.get(((Object)((Object)this)).getClass());
    private boolean configured = false;

    public void configure(ServiceGenericEntity<T, K> serviceGenericEntity, ValidGenericEntitiesImpl<T> validEntity, DefaultEntitiesTest<T> defaultEntityTest, Class<DTO> dtoClass, ExcelType excelType) {
        this.configure(serviceGenericEntity, validEntity, null, defaultEntityTest, dtoClass, excelType);
    }

    public void configure(ServiceGenericEntity<T, K> serviceGenericEntity, ValidGenericEntitiesImpl<T> validEntity, ImportDataListener<T> importDataListener, DefaultEntitiesTest<T> defaultEntityTest, Class<DTO> dtoClass, ExcelType excelType) {
        this.serviceGenericEntity = serviceGenericEntity;
        this.validEntity = validEntity;
        this.importDataListener = importDataListener;
        this.defaultEntityTest = defaultEntityTest;
        this.dtoClass = dtoClass;
        this.excelType = excelType;
        this.configured = true;
    }

    public BaseSmartComponenteResult<SCResultFile> processData() throws ExceptionBuildBI {
        if (!this.configured) {
            throw new ExceptionBuildBI("E.GEN.000046", new Object[0]);
        }
        try {
            InputStream arquivo = this.getInputStreamFile();
            if (arquivo == null) {
                throw new ExceptionBuildBI("E.GEN.000046", new Object[0]);
            }
            BaseSmartComponenteResult<SCResultFile> result = new BaseSmartComponenteResult<SCResultFile>(EnumConstantsMentorStatus.SUCESSO);
            this.beforeProcessData();
            ExcelSheet dados = this.getExcelSheet(arquivo, this.excelType, this.serviceGenericEntity, this.validEntity, this.importDataListener, this.dtoClass, true, false);
            this.afterProcessData();
            result.setResult(this.toFile(dados));
            return result;
        }
        catch (ExceptionBase ex) {
            this.logger.error((Throwable)ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public BaseSmartComponenteResult<SCResultFile> previewData() throws ExceptionBuildBI {
        if (!this.configured) {
            throw new ExceptionBuildBI("E.GEN.000046", new Object[0]);
        }
        try {
            BaseSmartComponenteResult<SCResultFile> result = new BaseSmartComponenteResult<SCResultFile>(EnumConstantsMentorStatus.SUCESSO);
            T entity = this.getDefaultEntity();
            DTO dto = this.buildToDTO(entity, this.dtoClass);
            this.setValuesInNullFields(dto);
            String json = this.toJson("", dto, entity, null);
            ExcelSheet dados = ToolExcel.convertToExcel((String)json);
            dados.setName("dados_importacao");
            result.setResult(this.toFile(dados));
            return result;
        }
        catch (ExceptionBase ex) {
            this.logger.error((Throwable)ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
    }

    private void importRow(ExcelSheet.Row row, ExcelSheet.Row header, int cellStatusImportacao, int cellObservacoesImportacao, boolean save, boolean saveOnlyWithoutValidate) throws ExceptionJson, ExceptionParseObject, ExceptionIO, ExceptionReflection, ExceptionBase {
        if (row.getCell(cellStatusImportacao) == null || !ToolMethods.isStrWithData((String)row.getCell(cellStatusImportacao).toString()) || !TMethods.isAffirmative((Number)row.getCell(cellStatusImportacao).asDouble())) {
            String json = ToolExcel.convertToJson((ExcelSheet.Row)header, (ExcelSheet.Row)row);
            json = this.beforeBuildDTO(json);
            DTO dto = this.convertDTO(json);
            if (this.isValidToContinue(dto = this.afterBuiltDTO(dto))) {
                T entity = this.getEntity(dto);
                if (entity != null && !this.isValidToContinue((DTO)entity)) {
                    row.newCell(cellStatusImportacao).setNumeric(Short.valueOf((short)0));
                    row.newCell(cellObservacoesImportacao).setString(MessagesBaseMentor.getMsg((String)"M.ERP.1957.001", (Object[])new Object[]{entity}));
                } else {
                    T voEntity = this.buildToEntity(dto, entity);
                    voEntity = this.afterBuildToEntity(dto, voEntity);
                    TempSaveObj<T> ret = this.importEntity(voEntity, dto, save, saveOnlyWithoutValidate);
                    row.newCell(cellStatusImportacao).setNumeric(Short.valueOf(ret.getStatus().getValue()));
                    if (ret.getValidErrors() != null) {
                        row.newCell(cellObservacoesImportacao).setString(ret.getValidErrors().asString());
                    }
                }
            } else {
                row.newCell(cellStatusImportacao).setNumeric(Short.valueOf((short)1));
                row.newCell(cellObservacoesImportacao).setString(MessagesBaseMentor.getMsg((String)"M.ERP.1957.001", (Object[])new Object[]{dto}));
            }
        }
    }

    public DTO convertDTO(String json) throws ExceptionIO {
        Map options = ToolMethods.toMap((ToolMethods.Pair[])new ToolMethods.Pair[]{ToolMethods.pair((Object)DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, (Object)false)});
        Object dtoEquipamento = ToolJson.readJson((String)json, this.dtoClass, (Map)options);
        return (DTO)dtoEquipamento;
    }

    public T buildToEntity(DTO dto, T entity) throws ExceptionBase {
        T ret = this.serviceGenericEntity.buildToEntity(dto, entity);
        return ret;
    }

    public T getEntity(DTO dtoEquipamento) throws ExceptionBase {
        return null;
    }

    @Override
    public SCResultFile toFile(ExcelSheet dados) throws ExceptionIO, ExceptionParseObject, ExceptionReflection {
        try {
            File temp = ToolFile.createTempFile((String)"dados_importacao", (String)".xlsx");
            ToolExcel.write((File)temp, (ExcelType)ExcelType.XLSX, (ExcelSheet)dados);
            temp = this.formatExcelCamposValidacao(temp);
            return new SCResultFile(temp);
        }
        catch (IOException ex) {
            this.logger.error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
        catch (InvalidFormatException ex) {
            this.logger.error((Throwable)ex);
            throw new ExceptionIO((Exception)((Object)ex), new Object[0]);
        }
    }

    public ExcelSheet getExcelSheet(InputStream arquivo, ExcelType excelType, ServiceGenericEntity<T, K> serviceGenericEntity, ValidGenericEntitiesImpl<T> validEntity, ImportDataListener<T> importDataListener, Class<DTO> dtoClass, boolean saveData, boolean saveDatasaveOnlyWithoutValidate) throws ExceptionJson, ExceptionParseObject, ExceptionIO, ExceptionReflection, ExceptionBase {
        ExcelSheet dados = ToolExcel.read((InputStream)arquivo, (ExcelType)excelType);
        ExcelSheet.Row header = dados.getHeader();
        int cellStatusImportacao = this.getIndexCell(header, 0, NAME_COLUMN_STATUS_IMPORTACAO);
        int cellObservacoesImportacao = this.getIndexCell(header, cellStatusImportacao, NAME_COLUMN_OBS_IMPORTACAO);
        header.newCell(cellStatusImportacao).setString(NAME_COLUMN_STATUS_IMPORTACAO);
        header.newCell(cellObservacoesImportacao).setString(NAME_COLUMN_OBS_IMPORTACAO);
        this.importRows(dados, header, cellStatusImportacao, cellObservacoesImportacao, saveData, saveDatasaveOnlyWithoutValidate);
        return dados;
    }

    protected void importRows(ExcelSheet dados, ExcelSheet.Row header, int cellStatusImportacao, int cellObservacoesImportacao, boolean saveData, boolean saveDatasaveOnlyWithoutValidate) throws ExceptionBase {
        for (ExcelSheet.Row row : dados.getRowsExceptHead()) {
            if (row == null) continue;
            this.importRow(row, header, cellStatusImportacao, cellObservacoesImportacao, saveData, saveDatasaveOnlyWithoutValidate);
        }
    }

    public int getIndexCell(ExcelSheet.Row header, Integer baseIndex, String descColumn) {
        Optional<ExcelSheet.Cell> found = header.getCells().stream().filter(i -> TMethods.isEquals((Object)descColumn, (Object)i.asString())).findFirst();
        if (found.isPresent()) {
            return found.get().getIndex();
        }
        int cell = header.getMaxCellIndex() + 1;
        if (baseIndex != null && cell == baseIndex) {
            ++cell;
        }
        return cell;
    }

    public String toJson(String fieldNameBase, Object dto, Object entity, ObjectNode node) throws ExceptionBase {
        ObjectMapper mapper = new ObjectMapper();
        if (node == null) {
            node = mapper.createObjectNode();
        }
        Field[] fields = dto.getClass().getDeclaredFields();
        Arrays.sort(fields, (i1, i2) -> i1.getName().compareTo(i2.getName()));
        for (Field field : fields) {
            Method getEntityField;
            String fieldName = field.getName();
            Object fieldNameExcel = field.getName();
            if (TMethods.isStrWithData((String)fieldNameBase)) {
                fieldNameExcel = fieldNameBase + "." + fieldName;
            }
            Method get = ToolReflections.getMethodGet((Field)field, dto.getClass());
            if (field.getAnnotation(DTOFieldToString.class) != null || get.getAnnotation(DTOFieldToString.class) != null || field.getAnnotation(DTOToString.class) != null || get.getAnnotation(DTOToString.class) != null || field.getAnnotation(DTOIgnoreField.class) != null || get.getAnnotation(DTOIgnoreField.class) != null || field.getAnnotation(DTOOnlyView.class) != null || get.getAnnotation(DTOOnlyView.class) != null || Collection.class.isAssignableFrom(field.getType())) continue;
            Field entityField = null;
            if (entity != null) {
                entityField = ToolReflections.getField(entity.getClass(), (String)fieldName);
            }
            if (entityField != null && (entityField.getAnnotation(Id.class) != null || entityField.getAnnotation(Version.class) != null) || entityField != null && (getEntityField = ToolReflections.getMethodGet((Field)entityField, entity.getClass())) != null && (getEntityField.getAnnotation(Id.class) != null || getEntityField.getAnnotation(Version.class) != null)) continue;
            Object value = ToolReflections.getValueFromMethod((Method)get, (Object)dto);
            ExcelCellType type = ExcelCellType.STRING;
            if (value == null) {
                node.putNull((String)fieldNameExcel);
            } else if (value instanceof Float) {
                node.put((String)fieldNameExcel, (Float)value);
                type = ExcelCellType.NUMERIC;
            } else if (value instanceof Double) {
                node.put((String)fieldNameExcel, (Double)value);
                type = ExcelCellType.NUMERIC;
            } else if (value instanceof Short) {
                node.put((String)fieldNameExcel, (Short)value);
                type = ExcelCellType.NUMERIC;
            } else if (value instanceof Integer) {
                node.put((String)fieldNameExcel, (Integer)value);
                type = ExcelCellType.NUMERIC;
            } else if (value instanceof Long) {
                node.put((String)fieldNameExcel, (Long)value);
                type = ExcelCellType.NUMERIC;
            } else if (value instanceof Date) {
                Long dateTimeMilis = ((Date)value).getTime();
                node.put((String)fieldNameExcel, dateTimeMilis);
                type = ExcelCellType.DATE;
            } else if (value instanceof String) {
                node.put((String)fieldNameExcel, (String)value);
                type = ExcelCellType.STRING;
            } else if (!ToolReflections.isPrimitive((Object)value) && entity != null) {
                Object subValueEn = ToolReflections.getValueFromMethod((Method)ToolReflections.getMethodGet((Field)entityField, entity.getClass()), (Object)entity);
                this.toJson((String)fieldNameExcel, value, subValueEn, node);
            }
            node.put((String)fieldNameExcel + "Class", Integer.valueOf(type.getType()));
        }
        try {
            ArrayNode nodes = mapper.createArrayNode();
            nodes.add((JsonNode)node);
            return mapper.writeValueAsString((Object)nodes);
        }
        catch (JsonProcessingException ex) {
            this.logger.error((Throwable)ex);
            throw new ExceptionReflection((IOException)((Object)ex));
        }
    }

    @Override
    public EnumConstSmartComponente getTipoSmartComponent() {
        return EnumConstSmartComponente.SMART_COMPONENTS_IMPORTACAO_DADOS;
    }

    public InputStream getInputStreamFile() throws ExceptionBuildBI {
        File in = this.getArquivo();
        if (in != null) {
            try {
                return new FileInputStream(in);
            }
            catch (FileNotFoundException ex) {
                this.doLogError(ex);
                throw new ExceptionBuildBI("01-02-00583", (Throwable)ex, new Object[0]);
            }
        }
        InputStream is = this.getParamAsObject("P_INPUT_STREAM", InputStream.class);
        if (is != null) {
            return is;
        }
        String str = this.getParamAsObject("P_INPUT_FILE_DATA", String.class);
        if (is != null) {
            try {
                this.excelType = ExcelType.CSV;
                return new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException ex) {
                this.doLogError(ex);
                throw new ExceptionBuildBI("01-02-00583", new Object[0]);
            }
        }
        return null;
    }

    public File getArquivo() throws ExceptionBuildBI {
        DTOUploadDownloadFileConfig.DTOItem item = this.getParamAsObject("P_INPUT_FILE", DTOUploadDownloadFileConfig.DTOItem.class);
        if (item != null) {
            this.excelType = ExcelType.getByExtension((String)item.getFileExtension());
            if (this.excelType == null) {
                throw new ExceptionBuildBI("E.GEN.000047", new Object[]{item.getFileExtension()});
            }
            return new File(item.getFilePath());
        }
        File inp = this.getParamAsObject("P_INPUT_FILE", File.class);
        if (inp != null && inp.exists()) {
            this.excelType = ExcelType.getByExtension((String)ToolFile.getExtFileWithoutDot((File)inp));
            if (this.excelType == null) {
                throw new ExceptionBuildBI("E.GEN.000047", new Object[]{inp.getAbsolutePath()});
            }
            return inp;
        }
        throw new ExceptionBuildBI("E.GEN.000066", new Object[0]);
    }

    public File getArquivoWhithoutValidation() throws ExceptionBuildBI {
        DTOUploadDownloadFileConfig.DTOItem item = this.getParamAsObject("P_INPUT_FILE", DTOUploadDownloadFileConfig.DTOItem.class);
        File file = new File(item.getFilePath());
        file = ToolFile.renameFileName((File)file, (String)(file.getName() + "." + item.getFileExtension()), (boolean)false);
        return file;
    }

    public File formatExcelCamposValidacao(File file) throws ExceptionReflection, IOException, InvalidFormatException {
        List itens = this.validEntity.getValidationCodes();
        if (file.getName().toLowerCase().endsWith(".xls")) {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
            HSSFFont boldFont = workbook.createFont();
            boldFont.setBold(true);
            HSSFCellStyle campoStatusDesc = workbook.createCellStyle();
            campoStatusDesc.setWrapText(true);
            HSSFCellStyle boldStyle = workbook.createCellStyle();
            boldStyle.setFont((Font)boldFont);
            HSSFSheet sheet = workbook.getSheetAt(0);
            HSSFRow header = sheet.getRow(0);
            Iterator it = header.cellIterator();
            int descImpColumn = -1;
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                Optional<ValidContainerItem> found = itens.stream().filter(i -> {
                    String cellText = cell.getStringCellValue();
                    String fieldName = i.getCodigo().getFieldName();
                    if (TMethods.isEqualsIgnoreCase((String)fieldName, (String)cellText)) {
                        return true;
                    }
                    return cellText != null && cellText.startsWith(fieldName);
                }).findFirst();
                if (found.isPresent()) {
                    cell.setCellStyle((CellStyle)boldStyle);
                }
                if (!TMethods.isEquals((Object)cell.getStringCellValue(), (Object)NAME_COLUMN_OBS_IMPORTACAO)) continue;
                descImpColumn = cell.getColumnIndex();
            }
            if (descImpColumn > 0) {
                sheet.getColumnStyle(descImpColumn).setWrapText(true);
                sheet.setColumnWidth(descImpColumn, 150);
            }
            file = this.getFileNameInternal(file);
            workbook.write((OutputStream)new FileOutputStream(file));
        } else if (file.getName().toLowerCase().endsWith(".xlsx")) {
            XSSFWorkbook workbook = new XSSFWorkbook(file);
            XSSFFont boldFont = workbook.createFont();
            boldFont.setBold(true);
            XSSFCellStyle boldStyle = workbook.createCellStyle();
            boldStyle.setFont((Font)boldFont);
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFRow header = sheet.getRow(0);
            Iterator it = header.cellIterator();
            int descImpColumn = -1;
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                Optional<ValidContainerItem> found = itens.stream().filter(i -> {
                    String cellText = cell.getStringCellValue();
                    String fieldName = i.getCodigo().getFieldName();
                    if (TMethods.isEqualsIgnoreCase((String)fieldName, (String)cellText)) {
                        return true;
                    }
                    return cellText != null && fieldName != null && cellText.startsWith(fieldName);
                }).findFirst();
                if (found.isPresent()) {
                    cell.setCellStyle((CellStyle)boldStyle);
                }
                if (!TMethods.isEquals((Object)cell.getStringCellValue(), (Object)NAME_COLUMN_OBS_IMPORTACAO)) continue;
                descImpColumn = cell.getColumnIndex();
            }
            if (descImpColumn > 0) {
                sheet.getColumnStyle(descImpColumn).setWrapText(true);
                sheet.setColumnWidth(descImpColumn, 150);
            }
            file = this.getFileNameInternal(file);
            workbook.write((OutputStream)new FileOutputStream(file));
        }
        return file;
    }

    private File getFileNameInternal(File file) {
        Object name = ToolMethods.isStrWithData((String)this.getFileName(file)) ? this.getFileName(file) : "importacao_dados_" + new Date().getTime() + ToolFile.getExtFileWithDot((File)file);
        return ToolFile.createTempFile((String)name);
    }

    public String getFileName(File file) {
        return null;
    }

    public TempSaveObj<T> saveOrUpdateValidateFlush(T vo, ValidGenericEntitiesImpl<T> validEntity) throws ExceptionBase {
        return this.serviceGenericEntity.saveOrUpdateValidateFlush(vo, (ValidGeneric<T>)validEntity);
    }

    public TempSaveObj<T> saveOrUpdateFlush(T vo, ValidGenericEntitiesImpl<T> validEntity) throws ExceptionBase {
        this.validate(vo, validEntity);
        T ret = this.serviceGenericEntity.saveOrUpdateFlush(vo);
        TempSaveObj<T> temp = new TempSaveObj<T>();
        temp.setStatus(EnumConstantsMentorStatus.SUCESSO);
        temp.setResult(ret);
        temp.setValidator((ValidGeneric<T>)validEntity);
        return temp;
    }

    public void validate(T vo, ValidGenericEntitiesImpl<T> validEntity) throws ExceptionBase {
        validEntity.clearContainer();
        validEntity.isValidData(vo);
    }

    public TempSaveObj<T> importEntity(T voEntity, DTO dto, boolean saveData, boolean saveIfNotValidate) throws ExceptionBase {
        return this.importEntity(voEntity, saveData, saveIfNotValidate);
    }

    public TempSaveObj<T> importEntity(T voEntity, boolean saveData, boolean saveIfNotValidate) throws ExceptionBase {
        if (this.importDataListener != null) {
            ToolReflections.setEmptyListIfNull(voEntity, (boolean)false);
            voEntity = this.importDataListener.beforeSave(voEntity);
        }
        TempSaveObj<Object> ret = new TempSaveObj();
        if (saveData) {
            if (saveIfNotValidate) {
                ret = this.saveOrUpdateFlush(voEntity, this.validEntity);
                this.afterSave(ret, this.validEntity);
            } else {
                try {
                    ret = this.saveOrUpdateValidateFlush(voEntity, this.validEntity);
                    this.afterSave(ret, this.validEntity);
                }
                catch (Exception ex) {
                    this.doLogError(ex);
                    ret.setStatus(EnumConstantsMentorStatus.ERRO);
                    ret.getValidErrors().add("E.GEN.000049", new Object[]{CompBDErrors.getProcessedMessage(ex)});
                }
            }
        } else {
            ret = this.serviceGenericEntity.validate(voEntity, (ValidGeneric<T>)this.validEntity);
        }
        return ret;
    }

    public void afterProcessData() throws ExceptionBase {
    }

    public void beforeProcessData() throws ExceptionBase {
    }

    protected void setValuesInNullFields(Object dto) throws ExceptionReflection {
        List getMeths = ToolReflections.getGetMethods(dto.getClass());
        Method setMethod = null;
        for (Method getMeth : getMeths) {
            String fieldName = ToolReflections.getFieldName((Method)getMeth);
            Object found = ToolReflections.getValueFromMethod((Method)getMeth, (Object)dto);
            Class<?> retType = ToolReflections.getReturnClass((Method)getMeth);
            if (found == null) {
                found = ToolReflections.getDefValue((Class)retType);
                setMethod = ToolReflections.getMethodSet((Field)ToolReflections.getField(dto.getClass(), (String)fieldName), dto.getClass());
                if (setMethod != null) {
                    try {
                        ToolReflections.setIt((Method)setMethod, (Object)dto, (Object[])new Object[]{found});
                    }
                    catch (Exception ex) {
                        this.doLogError(ex);
                    }
                }
            }
            if (found == null) continue;
            if (ToolReflections.isCollection(found.getClass())) {
                for (Object object : (Collection)found) {
                    retType = object.getClass();
                    if (ToolReflections.isPrimitive(retType)) continue;
                    this.setValuesInNullFields(object);
                }
                continue;
            }
            if (ToolReflections.isPrimitive(found.getClass())) continue;
            this.setValuesInNullFields(found);
        }
    }

    protected String beforeBuildDTO(String json) {
        return json;
    }

    protected DTO afterBuiltDTO(DTO dto) {
        return dto;
    }

    protected boolean isValidToContinue(T entity) {
        return true;
    }

    protected T getDefaultEntity() {
        return (T)((InterfaceVO)this.defaultEntityTest.getDefault());
    }

    protected DTO buildToDTO(T entity, Class<DTO> dtoClass) {
        return this.serviceGenericEntity.buildToDTO(entity, dtoClass);
    }

    protected boolean isValidToContinue(DTO dto) {
        return true;
    }

    protected void afterSave(TempSaveObj<T> ret, ValidGenericEntitiesImpl<T> validEntity) {
    }

    protected T afterBuildToEntity(DTO dto, T entity) {
        return entity;
    }

    public String removeFormatacaoNumericaExcel(String dados) {
        if (dados == null) {
            return dados;
        }
        if (dados.contains(",0")) {
            return dados.substring(0, dados.indexOf(",0"));
        }
        if (dados.contains(".0")) {
            return dados.substring(0, dados.indexOf(".0"));
        }
        return dados;
    }

    public static interface ImportDataListener<T extends InterfaceVO> {
        public T beforeSave(T var1) throws ExceptionIO;
    }
}

