/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.smartcomponente;

import com.touchcomp.basementor.model.vo.SmartComponent;
import com.touchcomp.basementor.model.vo.SmartComponentParams;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.businessintelligence.CompDynamicParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.helpers.impl.usuario.HelperUsuario;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponentParams;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponente;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.InterfaceSCResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.SCResultFile;
import com.touchcomp.basementorservice.service.impl.smartcomponentpref.ServiceSmartComponentPrefImpl;
import com.touchcomp.basementorservice.tasks.TaskCreator;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.java.ToolJava;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceBuildSmartComponentImpl<T extends InterfaceSCResult> {
    @Autowired
    CompDynamicParams compDynamicParams;
    @Autowired
    HelperUsuario helperUsuario;
    @Autowired
    ServiceSmartComponentImpl serviceSmartComponentImpl;
    @Autowired
    ServiceSmartComponentPrefImpl serviceSmartComponentPrefImpl;

    public BaseSmartComponenteResult<InterfaceSCResult> buildSC(SmartComponentPref smart, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI {
        DefaultBIParamsMap<String, Object> params = this.convertPreferenciasParametros(smart, null);
        return this.buildSC(smart.getSmartComponente(), params, taskProgress);
    }

    public BaseSmartComponenteResult<InterfaceSCResult> buildSC(SmartComponentPref smart, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI {
        params = this.convertPreferenciasParametros(smart, params);
        return this.buildSC(smart.getSmartComponente(), params, taskProgress);
    }

    private BaseSmartComponente getSC(SmartComponent baseComponente, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI {
        SessionFactory sessionFactory = (SessionFactory)Context.get(SessionFactory.class);
        try {
            Class c;
            this.convertDefaultParams(baseComponente, params);
            try {
                byte[] content = ToolBase64.decodeBase64((String)baseComponente.getClassBytecode());
                c = ToolJava.loadClass((String)baseComponente.getPacoteClasse(), (byte[])content);
            }
            catch (Throwable ex) {
                try {
                    byte[] content = ToolHexString.decodeToByte((String)baseComponente.getClassBytecode());
                    c = ToolJava.loadClass((String)baseComponente.getPacoteClasse(), (byte[])content);
                }
                catch (ExceptionBase e) {
                    throw new ExceptionBuildBI("E.ERP.1947.003", ex, new Object[0]);
                }
            }
            Object test = c.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (test instanceof BaseSmartComponente) {
                BaseSmartComponente b = (BaseSmartComponente)((Object)test);
                b.setTaskProgress(taskProgress);
                b.setSession(sessionFactory.getCurrentSession());
                b.setParams(new BaseSmartComponentParams(params));
                b.initBeans();
                b.init();
                b.isValidData(b.getParams());
                if (!b.getContainer().getItens().isEmpty()) {
                    throw new ExceptionBuildBI("E.ERP.1947.004", new Object[]{b.getContainer().asString()});
                }
                return b;
            }
            throw new ExceptionBuildBI("Classe implementada invalida para BI " + baseComponente.getIdentificador(), new Object[0]);
        }
        catch (ExceptionBuildBI ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public BaseSmartComponenteResult<InterfaceSCResult> buildSC(SmartComponent smartComponent, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI {
        BaseSmartComponente base = this.getSC(smartComponent, params, taskProgress);
        BaseSmartComponenteResult<InterfaceSCResult> d = base.processData();
        d.setSmartComponente(smartComponent);
        return d;
    }

    public BaseSmartComponenteResult<SCResultFile> previewDataSC(SmartComponent smartComponent, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI {
        BaseSmartComponente base = this.getSC(smartComponent, params, taskProgress);
        BaseSmartComponenteResult<SCResultFile> d = base.previewData();
        d.setSmartComponente(smartComponent);
        return d;
    }

    public BaseSmartComponenteResult<SCResultFile> getPreviewDataSmartComponent(SmartComponent smartComponent, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI {
        BaseSmartComponenteResult<SCResultFile> res = this.previewDataSC(smartComponent, params, taskProgress);
        return res;
    }

    public BaseSmartComponenteResult executeSmartComponent(Long idSmartComponente, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI, ExceptionObjNotFound, ExceptionObjNotFound {
        SmartComponent smartComponent = (SmartComponent)this.serviceSmartComponentImpl.getOrThrow(idSmartComponente);
        BaseSmartComponenteResult<InterfaceSCResult> res = this.buildSC(smartComponent, params, taskProgress);
        return res;
    }

    public BaseSmartComponenteResult executeSmartComponentPref(Long idSmartComponentPref, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBuildBI, ExceptionObjNotFound {
        SmartComponentPref smartComponent = (SmartComponentPref)this.serviceSmartComponentPrefImpl.getOrThrow(idSmartComponentPref);
        params = this.convertPreferenciasParametros(smartComponent, params);
        BaseSmartComponenteResult<InterfaceSCResult> res = this.buildSC(smartComponent, params, taskProgress);
        return res;
    }

    private void convertDefaultParams(SmartComponent baseComponente, DefaultBIParamsMap<String, Object> params) throws ExceptionReflection {
        for (String key : params.keySet()) {
            SmartComponentParams param = this.getParam(baseComponente.getParametros(), key);
            Object value = params.get(key);
            if (param == null || value == null || TMethods.isEquals((Object)param.getClasseParametro(), (Object)value.getClass().getCanonicalName())) continue;
            if (ToolMethods.isAffirmative((Number)param.getUsarCondicaoIn())) {
                String aux = String.valueOf(value);
                if (ToolReflections.isPrimitiveNumber((String)param.getClasseParametro())) {
                    aux = ToolString.trim((String)aux);
                }
                String[] data = ToolString.splitString((String)aux, (char[])new char[]{'.'});
                LinkedList col = new LinkedList();
                for (String str : data) {
                    this.addValues(param, col, str);
                }
                params.put(key, col);
                continue;
            }
            OpFinder finder = CompRestrictionsFactory.getRestrictions((String)param.getClasseParametro());
            value = finder.convertStrNativeValue(String.valueOf(value));
            params.put(key, value);
        }
    }

    private SmartComponentParams getParam(List<SmartComponentParams> parametros, String key) {
        SmartComponentParams temp = null;
        for (SmartComponentParams parametro : parametros) {
            if (TMethods.isEquals((Object)parametro.getChaveParametro(), (Object)key)) {
                temp = parametro;
                break;
            }
            temp = this.getParam(parametro.getSmartComponentsParamsFilhos(), key);
            if (temp == null) continue;
            break;
        }
        return temp;
    }

    private DefaultBIParamsMap<String, Object> convertPreferenciasParametros(SmartComponentPref smart, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        if (params == null) {
            params = new DefaultBIParamsMap();
        }
        if (TMethods.isNotNull((Object)smart).booleanValue() && TMethods.isStrWithData((String)smart.getParametros())) {
            try {
                HashMap pref = ToolJson.readJsonAsMap((String)smart.getParametros());
                if (pref == null) {
                    pref = new HashMap();
                }
                for (SmartComponentParams param : smart.getSmartComponente().getParametros()) {
                    String valorParam = param.getValorParametro();
                    Object paramInf = pref.get(param.getChaveParametro());
                    if (paramInf != null) {
                        valorParam = paramInf.toString();
                    }
                    params.put(param.getChaveParametro(), valorParam);
                }
            }
            catch (ExceptionIO ex) {
                throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
            }
        }
        return params;
    }

    private void addValues(SmartComponentParams param, List col, String str) throws ExceptionReflection {
        OpFinder finder = CompRestrictionsFactory.getRestrictions((String)param.getClasseParametro());
        int index = str.indexOf("-");
        if (index >= 0 && ToolReflections.isPrimitiveIntNumber((String)param.getClasseParametro())) {
            String part1 = str.substring(0, index);
            String part2 = str.substring(index + 1);
            long partN1 = Long.parseLong(part1);
            long partN2 = Long.parseLong(part2);
            for (long i = partN1; i < partN2; ++i) {
                col.add(finder.convertStrNativeValue(String.valueOf(i)));
            }
        } else {
            col.add(finder.convertStrNativeValue(String.valueOf(str)));
        }
    }
}

