/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.smartcomponente;

import com.touchcomp.basementor.constants.enums.smartcomponente.EnumConstSmartComponente;
import com.touchcomp.basementor.model.vo.SmartComponent;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.ServiceFileUploadImpl;
import com.touchcomp.basementorservice.service.impl.searchentities.ServiceEntityFinder;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceBuildSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.SCResultFile;
import com.touchcomp.basementorservice.service.impl.smartcomponentpref.ServiceSmartComponentPrefImpl;
import com.touchcomp.basementorservice.tasks.TaskCreator;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.smartcomponent.web.DTOSmartComponent;
import com.touchcomp.touchvomodel.vo.smartcomponent.web.DTOSmartComponentPrefResID;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceBuildSmartComponentWebImpl<T>
extends ServiceGenericImpl {
    @Autowired
    ServiceFileUploadImpl serviceFileUploadImpl;
    @Autowired
    ServiceSmartComponentImpl serviceSmartComp;
    @Autowired
    ServiceSmartComponentPrefImpl serviceSmartCompPref;
    @Autowired
    CompBIDefaultParams compBIDefaultParams;
    @Autowired
    ServiceBuildSmartComponentImpl serviceBuildSmartComp;

    public TaskCreator.TaskAsync getPreviewDataSmartComponentAsync(Long iddSmartComponente, DTOSmartComponentPrefResID dataPerfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBase {
        SmartComponent sc = (SmartComponent)this.serviceSmartComp.getOrThrow(iddSmartComponente);
        TaskCreator.TaskProgress taskProgress = new TaskCreator.TaskProgress();
        TaskCreator.TaskAsync<File> ret = TaskCreator.supplyAsync(sc.getDescricao(), () -> {
            try {
                EnumConstSmartComponente tipo = EnumConstSmartComponente.get((Object)sc.getTipoComponente());
                if (!tipo.isExecSmartComponent()) {
                    throw new ExceptionInvalidData("E.ERP.1947.002", new Object[]{sc});
                }
                this.savePrefs(sc, dataPerfil, params);
                BaseSmartComponenteResult<SCResultFile> res = this.serviceBuildSmartComp.previewDataSC(sc, params, taskProgress);
                if (!res.getStatus().isOk()) {
                    throw new ExceptionRuntimeBase(res.getMensagem());
                }
                return res.getResult().getResultFile();
            }
            catch (ExceptionBase ex) {
                TLogger.get(ServiceBuildSmartComponentWebImpl.class).error((Throwable)ex);
                throw new ExceptionRuntimeBase(ex);
            }
        });
        ret.setTaskProgress(taskProgress);
        return ret;
    }

    public TaskCreator.TaskAsync<BaseSmartComponenteResult> executeSmartComponentAsync(Long idSmartComponente, DTOSmartComponentPrefResID dataPerfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBase {
        SmartComponent sc = (SmartComponent)this.serviceSmartComp.getOrThrow(idSmartComponente);
        TaskCreator.TaskProgress taskProgress = new TaskCreator.TaskProgress();
        TaskCreator.TaskAsync<BaseSmartComponenteResult> ret = TaskCreator.supplyAsync(sc.getDescricao(), () -> {
            try {
                if (!TMethods.isEquals((Object)sc.getTipoComponente(), (Object)EnumConstSmartComponente.SMART_COMPONENTS_EXECUCAO.getEnumId())) {
                    throw new ExceptionInvalidData("E.ERP.1947.002", new Object[]{sc});
                }
                this.savePrefs(sc, dataPerfil, params);
                BaseSmartComponenteResult res = !TMethods.isWithData((Number)dataPerfil.getIdentificador()) ? this.serviceBuildSmartComp.executeSmartComponent(idSmartComponente, params, taskProgress) : this.serviceBuildSmartComp.executeSmartComponentPref(dataPerfil.getIdentificador(), params, taskProgress);
                if (res.getStatus() == null || !res.getStatus().isOk()) {
                    throw new ExceptionRuntimeBase(res.getMensagem());
                }
                return res;
            }
            catch (ExceptionBase ex) {
                TLogger.get(ServiceBuildSmartComponentWebImpl.class).error((Throwable)ex);
                throw new ExceptionRuntimeBase(ex);
            }
        });
        ret.setTaskProgress(taskProgress);
        return ret;
    }

    public TaskCreator.TaskAsync importDataFileAsync(Long idSmartComponent, DTOSmartComponentPrefResID dataPerfil, String fileUploadKey, DefaultBIParamsMap<String, Object> params) throws ExceptionBase {
        SmartComponent sc = (SmartComponent)this.serviceSmartComp.getOrThrow(idSmartComponent);
        TaskCreator.TaskProgress taskProgress = new TaskCreator.TaskProgress();
        TaskCreator.TaskAsync<File> ret = TaskCreator.supplyAsync(sc.getDescricao(), () -> {
            try {
                if (!TMethods.isEquals((Object)sc.getTipoComponente(), (Object)EnumConstSmartComponente.SMART_COMPONENTS_IMPORTACAO_DADOS.getValue())) {
                    throw new ExceptionInvalidData("E.ERP.1947.002", new Object[]{sc});
                }
                DTOUploadDownloadFileConfig.DTOItem fileUpload = this.serviceFileUploadImpl.getFileData(fileUploadKey);
                BaseSmartComponenteResult<SCResultFile> temp = this.importData(sc, dataPerfil, fileUpload, params, taskProgress);
                if (temp.getStatus().isErro()) {
                    throw new ExceptionRuntimeBase(ToolString.asString(temp.getMensagensErro(), (String)";"));
                }
                return temp.getResult().getResultFile();
            }
            catch (ExceptionBase ex) {
                TLogger.get(ServiceBuildSmartComponentWebImpl.class).error((Throwable)ex);
                throw new ExceptionRuntimeBase(ex);
            }
        });
        ret.setTaskProgress(taskProgress);
        return ret;
    }

    public BaseSmartComponenteResult importDataByCodSmartComp(String codSmartComponente, DTOSmartComponentPrefResID dataPerfil, String input, DefaultBIParamsMap<String, Object> params) throws ExceptionBase {
        SmartComponent sc = this.serviceSmartComp.getByCodigo(codSmartComponente);
        if (!TMethods.isEquals((Object)sc.getTipoComponente(), (Object)EnumConstSmartComponente.SMART_COMPONENTS_IMPORTACAO_DADOS.getValue())) {
            throw new ExceptionInvalidData("E.ERP.1947.002", new Object[]{sc});
        }
        return this.importData(sc, dataPerfil, input, params, new TaskCreator.TaskProgress());
    }

    public BaseSmartComponenteResult importDataByIdSmartComp(Long idSmartComponente, DTOSmartComponentPrefResID dataPerfil, String input, DefaultBIParamsMap<String, Object> params) throws ExceptionBase {
        SmartComponent sc = (SmartComponent)this.serviceSmartComp.getOrThrow(idSmartComponente);
        if (!TMethods.isEquals((Object)sc.getTipoComponente(), (Object)EnumConstSmartComponente.SMART_COMPONENTS_IMPORTACAO_DADOS.getValue())) {
            throw new ExceptionInvalidData("E.ERP.1947.002", new Object[]{sc});
        }
        return this.importData(sc, dataPerfil, input, params, new TaskCreator.TaskProgress());
    }

    private BaseSmartComponenteResult importData(SmartComponent sc, DTOSmartComponentPrefResID dataPerfil, String input, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBase {
        if (params == null) {
            params = new DefaultBIParamsMap();
        }
        input = ToolBase64.decodeBase64String((String)input);
        params.put("P_INPUT_FILE_DATA", input);
        return this.importData(sc, dataPerfil, params, taskProgress);
    }

    public List<DTOSmartComponent.DTOSmartComponentParams> getParams(Long idSsmart, Long idPerfil, DefaultBIParamsMap<String, Object> defParams) throws ExceptionBase {
        SmartComponent sc = (SmartComponent)this.serviceSmartComp.getOrThrow(idSsmart);
        SmartComponentPref pref = null;
        if (idPerfil != null) {
            pref = (SmartComponentPref)this.serviceSmartCompPref.get(idPerfil);
        }
        List<DTOSmartComponent.DTOSmartComponentParams> ret = this.serviceSmartComp.buildToDTOGeneric(sc.getParametros(), DTOSmartComponent.DTOSmartComponentParams.class);
        if (pref != null && TMethods.isStrWithData((String)pref.getParametros())) {
            Map data = ToolJson.readJsonAsMap((String)pref.getParametros());
            Set<String> keys = data.keySet();
            this.setParamsPerfil(data, keys, ret);
        }
        this.setParamsInternal(ret, defParams);
        return ret;
    }

    private void setParamsPerfil(Map<String, Object> data, Set<String> keys, List<DTOSmartComponent.DTOSmartComponentParams> ret) {
        if (ret == null) {
            return;
        }
        for (DTOSmartComponent.DTOSmartComponentParams param : ret) {
            Optional<String> found = keys.stream().filter(i -> TMethods.isEquals((Object)param.getChaveParametro(), (Object)i)).findFirst();
            if (found.isPresent() && data.get(found.get()) != null) {
                Object toSet = data.get(found.get());
                param.setValorParametro(null);
                if (toSet != null) {
                    param.setValorParametro(String.valueOf(toSet));
                }
            }
            this.setParamsPerfil(data, keys, param.getSmartComponentsParamsFilhos());
        }
    }

    private void setParamsInternal(List<DTOSmartComponent.DTOSmartComponentParams> ret, DefaultBIParamsMap<String, Object> defParams) throws ExceptionBase {
        if (ret == null) {
            return;
        }
        for (DTOSmartComponent.DTOSmartComponentParams dto : ret) {
            dto.setValorParametro(this.compBIDefaultParams.buildValorParametro(dto.getTipoInfValor(), dto.getValorParametro(), dto.getValorExpressao(), dto.getChaveParametro(), dto.getClasseParametro(), dto.getClassePesquisa(), dto.getMetodoPesquisa(), defParams));
            if (this.isStrWithData(dto.getClassePesquisa())) {
                ServiceEntityFinder service = this.getBean(ServiceEntityFinder.class);
                if (!ToolMethods.isAffirmative((Number)dto.getPermiteInfMultiplosObjetos())) {
                    if (ToolString.isALongNumber((String)dto.getValorParametro())) {
                        Object result = service.findObjectById(dto.getClassePesquisa(), Long.valueOf(dto.getValorParametro()));
                        if (this.isNotNull(result).booleanValue()) {
                            dto.setDescricaoValor(result.toString());
                        }
                    } else {
                        dto.setDescricaoValor("");
                        dto.setValorParametro("");
                    }
                } else {
                    List<Object> result;
                    Long[] ids = ToolString.getIdsInString((String)dto.getValorParametro());
                    if (this.isNotNull(ids).booleanValue() && ids.length > 0 && ToolMethods.isWithData(result = service.findObjectById(dto.getClassePesquisa(), ids))) {
                        StringBuilder sb = new StringBuilder();
                        result.forEach(i -> sb.append(String.valueOf(i)).append(";"));
                        dto.setDescricaoValor(sb.toString());
                    }
                }
            }
            this.setParamsInternal(dto.getSmartComponentsParamsFilhos(), defParams);
        }
    }

    private void savePrefs(SmartComponent sc, DTOSmartComponentPrefResID dataPerfil, DefaultBIParamsMap params) throws ExceptionBase {
        if (params == null) {
            return;
        }
        if (!TMethods.isWithData((Number)dataPerfil.getIdentificador())) {
            if (!TMethods.isStrWithData((String)dataPerfil.getDescricao())) {
                return;
            }
            SmartComponentPref perfil = this.serviceSmartCompPref.get(dataPerfil.getDescricao(), sc.getIdentificador());
            if (this.isNull(perfil).booleanValue()) {
                perfil = new SmartComponentPref();
                perfil.setDescricao(dataPerfil.getDescricao());
                perfil.setSmartComponente(sc);
            }
            perfil.setParametros(ToolJson.toJson(params.getBIParams()));
            this.serviceSmartCompPref.saveOrUpdate(perfil);
            return;
        }
        SmartComponentPref pref = (SmartComponentPref)this.serviceSmartCompPref.get(dataPerfil.getIdentificador());
        if (pref == null) {
            return;
        }
        String json = ToolJson.toJson(params.getBIParams());
        pref.setParametros(json);
        this.serviceSmartCompPref.saveOrUpdate(pref);
    }

    private BaseSmartComponenteResult<SCResultFile> importData(SmartComponent sc, DTOSmartComponentPrefResID dataPerfil, DTOUploadDownloadFileConfig.DTOItem input, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBase {
        if (params == null) {
            params = new DefaultBIParamsMap();
        }
        params.put("P_INPUT_FILE", input);
        return this.importData(sc, dataPerfil, params, taskProgress);
    }

    private BaseSmartComponenteResult<SCResultFile> importData(SmartComponent sc, DTOSmartComponentPrefResID dataPerfil, DefaultBIParamsMap<String, Object> params, TaskCreator.TaskProgress taskProgress) throws ExceptionBase {
        this.savePrefs(sc, dataPerfil, params);
        BaseSmartComponenteResult res = this.serviceBuildSmartComp.executeSmartComponent(sc.getIdentificador(), params, taskProgress);
        if (!res.getStatus().isOk()) {
            if (res.getMensagem() == null) {
                throw new ExceptionInvalidData(res.getMensagem(), new Object[0]);
            }
            throw new ExceptionInvalidData(TMethods.toString(res.getMensagensErro()), new Object[0]);
        }
        return res;
    }
}

