/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.smartcomponente;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.bi.EnumConstAlteracaoBI;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.smartcomponente.EnumConstSmartComponente;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.SmartCompParamsValorFixo;
import com.touchcomp.basementor.model.vo.SmartComponent;
import com.touchcomp.basementor.model.vo.SmartComponentGrUsu;
import com.touchcomp.basementor.model.vo.SmartComponentNodo;
import com.touchcomp.basementor.model.vo.SmartComponentParams;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorproperties.local.NetworkPropertiesLocal;
import com.touchcomp.basementorservice.components.businessintelligence.repositorio.CompEnvioRepositorioBI;
import com.touchcomp.basementorservice.components.entityxml.CompExpImpEntityXML;
import com.touchcomp.basementorservice.dao.impl.DaoSmartComponentImpl;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligence.DadosBILocais;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.ServiceFileUploadImpl;
import com.touchcomp.basementorservice.service.impl.grupousuarios.ServiceGrupoUsuariosImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponentarquivo.ServiceSmartComponentArquivoImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponentpref.ServiceSmartComponentPrefImpl;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.java.ToolJava;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.impl.smartcomponent.ValidSmartComponent;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIImportacaoRes;
import com.touchcomp.touchvomodel.vo.smartcomponent.web.DTOSmartComponent;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceSmartComponentImpl
extends ServiceGenericEntityImpl<SmartComponent, Long, DaoSmartComponentImpl> {
    final CompExpImpEntityXML compExp;
    final ValidSmartComponent validSmartComponent;
    final ServiceFileUploadImpl serviceFileUploadImpl;
    final ServiceSmartComponentPrefImpl serviceSmartComponentPrefImpl;
    final ServiceSmartComponentArquivoImpl serviceSmartComponentArq;
    final ServiceVersaoVersoesImpl serviceVersao;
    final ValidSmartComponent validImportacao;
    private ServiceNodoImpl serviceNodo;
    private ServiceGrupoUsuariosImpl serviceGrupo;

    @Autowired
    public ServiceSmartComponentImpl(DaoSmartComponentImpl dao, CompExpImpEntityXML compExp, ValidSmartComponent validSmartComponent, ServiceFileUploadImpl serviceFileUploadImpl, ServiceSmartComponentPrefImpl serviceSmartComponentPrefImpl, ServiceSmartComponentArquivoImpl serviceSmartComponentArq, ServiceVersaoVersoesImpl serviceVersao, ValidSmartComponent validImportacao, ServiceNodoImpl serviceNodo, ServiceGrupoUsuariosImpl serviceGrupo) {
        super(dao);
        this.compExp = compExp;
        this.validSmartComponent = validSmartComponent;
        this.serviceFileUploadImpl = serviceFileUploadImpl;
        this.serviceSmartComponentPrefImpl = serviceSmartComponentPrefImpl;
        this.serviceSmartComponentArq = serviceSmartComponentArq;
        this.serviceVersao = serviceVersao;
        this.validImportacao = validImportacao;
        this.serviceGrupo = serviceGrupo;
        this.serviceNodo = serviceNodo;
    }

    public File getArquivoSmartComponent(Long id) throws ExceptionObjNotFound, ExceptionIO {
        SmartComponent sc = (SmartComponent)this.getOrThrow(id);
        File f = ToolFile.createTempFile((String)("smart_component_" + id));
        f = this.compExp.entityToFile(f, sc, EnumConstTipoRepositorioBI.SMART_COMPONENT.getFileExtension(), 0L);
        return f;
    }

    public <E> E importArquivoSmartComponent(String fileUpload, Class<E> dto) throws ExceptionObjNotFound, ExceptionIO, ExceptionInvalidData, ExceptionInvalidState {
        File uploadFile = this.serviceFileUploadImpl.getFile(fileUpload);
        SmartComponent b = (SmartComponent)this.compExp.fileBase64ToEntity(uploadFile, 0L, false, "com.touchcomp.basementor.model.vo");
        this.validSmartComponent.clear();
        this.validSmartComponent.isValidData((InterfaceVO)b);
        if (this.validSmartComponent.hasErrors()) {
            throw new ExceptionInvalidData("E.ERP.000.000", new Object[]{this.validSmartComponent.toString()});
        }
        b = this.saveOrUpdate(b);
        return this.buildToDTO(b, dto);
    }

    @Override
    public SmartComponent beforeSave(SmartComponent aux) {
        aux.setPacoteClasse(TString.trim((String)aux.getPacoteClasse()));
        for (SmartComponentParams parametro : aux.getParametros()) {
            parametro.setSmartComponente(aux);
            for (SmartCompParamsValorFixo vlrFixo : parametro.getValorFixo()) {
                vlrFixo.setSmartComponentParams(parametro);
            }
        }
        for (SmartComponentGrUsu g : aux.getGruposUsuarios()) {
            g.setSmartComponente(aux);
        }
        for (SmartComponentNodo nodo : aux.getNodos()) {
            nodo.setSmartComponente(aux);
        }
        if (ToolMethods.isStrWithData((String)aux.getTipoComponente())) {
            EnumConstSmartComponente tipo = EnumConstSmartComponente.get((Object)aux.getTipoComponente());
            aux.setTipoExecComponente(Short.valueOf(tipo.getTipoExecComponente().getValue()));
        }
        return aux;
    }

    public String compileSmartComponentCode(String nomeClasse, String sourceCode) throws ExceptionInvalidState {
        try {
            try {
                sourceCode = ToolHexString.decodeToStr((String)sourceCode);
            }
            catch (ExceptionDecodeHexString ex) {
                sourceCode = ToolBase64.decodeBase64String((String)sourceCode);
            }
            byte[] data = ToolJava.compileCode((String)TString.trim((String)nomeClasse), (String)sourceCode);
            return ToolBase64.encodeBase64((byte[])data);
        }
        catch (ExceptionDecodeHexString64 ex) {
            this.logError(ex);
            throw new ExceptionInvalidState(ex.getErrorCode(), new Object[]{ex.getFormattedMessage(), ex});
        }
    }

    public DTOSmartComponent compileSmartComponentCode(DTOSmartComponent input, Class<DTOSmartComponent> aClass) throws ExceptionInvalidState {
        input.setClassBytecode(this.compileSmartComponentCode(input.getPacoteClasse(), input.getSourceCode()));
        return input;
    }

    public File exportArquivoSmartComponent(String idSmartComponent) throws ExceptionIO, ExceptionObjNotFound {
        idSmartComponent = ToolString.onlyNumbers((String)idSmartComponent);
        SmartComponent sc = (SmartComponent)this.getOrThrow(Long.valueOf(idSmartComponent));
        String res = this.compExp.entityToBase64(sc, 0L);
        String nome = sc.getCodigoSmartComponent();
        if (!TMethods.isStrWithData((String)nome)) {
            nome = ToolFile.getValidFileName((String)sc.getDescricao());
        }
        File f = ToolFile.createTempFile((String)(nome + EnumConstTipoRepositorioBI.SMART_COMPONENT.getFileExtension()));
        ToolFile.writeStringInFile((File)f, (String)res);
        return f;
    }

    @Override
    public SmartComponent beforeSaveEntity(SmartComponent entity) {
        for (SmartComponentParams param : entity.getParametros()) {
            param.setSmartComponente(entity);
            this.setParams(entity.getParametros());
        }
        return entity;
    }

    private void setParams(List<SmartComponentParams> params) {
        for (SmartComponentParams param : params) {
            for (SmartCompParamsValorFixo vlrFixo : param.getValorFixo()) {
                vlrFixo.setSmartComponentParams(param);
            }
            if (param.getSmartComponentsParamsFilhos() == null) {
                param.setSmartComponentsParamsFilhos(new LinkedList());
            }
            this.setParams(param.getSmartComponentsParamsFilhos());
        }
    }

    public SmartComponent getByCodigo(String codigoSmartComponent) throws ExceptionObjNotFound {
        SmartComponent sc = ((DaoSmartComponentImpl)this.getDao()).getByCodigo(codigoSmartComponent);
        this.throwIfNull(sc, (Serializable)((Object)codigoSmartComponent));
        return sc;
    }

    public List<GenericMapValues<DadosBILocais>> getSmartCompLocais() {
        return ((DaoSmartComponentImpl)this.getGenericDao()).getSmartCompLocais();
    }

    public SmartComponent getSmartComponent(String numeroBI, Long versaoRep, Long versao) {
        return ((DaoSmartComponentImpl)this.getGenericDao()).getSmartComponent(numeroBI, versaoRep, versao);
    }

    @Transactional
    public SmartComponent resave(SmartComponent newBI, SmartComponent old) {
        ((DaoSmartComponentImpl)this.getDao()).flushData();
        ((DaoSmartComponentImpl)this.getDao()).evict(old);
        ((DaoSmartComponentImpl)this.getDao()).getSession().clear();
        return this.saveOrUpdate(newBI);
    }

    @Override
    public SmartComponent beforeDeleteEntity(SmartComponent entity) {
        this.serviceSmartComponentPrefImpl.deleteAll(entity);
        return super.beforeDeleteEntity(entity);
    }

    public <T> T getNovoPerfil(Long idSmartComponente, String nomePerfil, Class<T> aClass) throws ExceptionObjNotFound {
        SmartComponentPref perf = new SmartComponentPref();
        perf.setDescricao(nomePerfil);
        perf.setSmartComponente((SmartComponent)this.getOrThrow(idSmartComponente));
        perf = this.serviceSmartComponentPrefImpl.saveOrUpdate(perf);
        return this.serviceSmartComponentPrefImpl.buildToDTO(perf, aClass);
    }

    public <T> T getNovoPerfil(Long idSmartComponente, Class<T> aClass) throws ExceptionObjNotFound {
        String nomePerfil = MessagesBaseMentor.getTextDetailsMsg((String)"M.ERP.0747.001", (Object[])new Object[0]);
        return this.getNovoPerfil(idSmartComponente, nomePerfil, aClass);
    }

    public void arquivar(Long idBI, Long versaoSistema) throws ExceptionIO, ExceptionObjNotFound {
        SmartComponent bi = (SmartComponent)this.getOrThrow(idBI);
        this.serviceSmartComponentArq.arquivar(bi, versaoSistema);
    }

    public SmartComponent desarquivar(Long idArquivamento, Long versaoSistema) throws ExceptionIO, ExceptionObjNotFound {
        SmartComponent bi = this.serviceSmartComponentArq.desarquivar(idArquivamento, versaoSistema);
        return this.saveOrUpdate(bi);
    }

    public void enviarRepositorioBI(String idSmartComponent, CapsEmpresa capsEmpresa, CapsUsuario capsUsuario) throws ExceptionObjNotFound, ExceptionInvalidState, ExceptionBase {
        SmartComponent smart = (SmartComponent)this.getOrThrow(idSmartComponent);
        this.validImportacao.isValidData((InterfaceVO)smart);
        if (this.validImportacao.hasErrors()) {
            throw new ExceptionInvalidData("E.GEN.000028", new Object[]{this.validImportacao.getContainer().asString()});
        }
        DTOImportacaoBIImportacaoRes imp = new DTOImportacaoBIImportacaoRes();
        imp.setIdentificador(smart.getIdentificador());
        imp.setNumeroControle(smart.getNumeroControle());
        imp.setDescricaoBIAlteracoes(smart.getDescricao());
        imp.setNodos(new LinkedList());
        smart.getNodos().forEach(i -> imp.getNodos().add(i.getIdentificador()));
        CompEnvioRepositorioBI comp = new CompEnvioRepositorioBI();
        EnumConstAlteracaoBI tipoAlteracoes = !ToolMethods.isStrWithData((String)smart.getCodigoSmartComponent()) ? EnumConstAlteracaoBI.TIPO_CRIACAO_NOVO_BI : EnumConstAlteracaoBI.TIPO_ALTERACOES_SIMPLES;
        String servidor = NetworkPropertiesLocal.getInstance().getEnderecoServidorAtendimentos(null);
        DTOInfoVersao info = this.serviceVersao.getVersaoSistema(EnumConstTipoSistemasTouch.MENTOR_BD);
        String codigoVersaoSistema = "0l";
        if (info != null) {
            codigoVersaoSistema = String.valueOf(info.getCodigo());
        }
        String alteracoes = "";
        if (imp != null) {
            alteracoes = imp.getDescricaoBIAlteracoes();
        }
        smart = comp.enviarSmartRepositorio(smart, this.getSharedData().getUsuario(capsUsuario.get()), this.getSharedData().getEmpresa(capsEmpresa.get()), alteracoes, servidor, codigoVersaoSistema, tipoAlteracoes);
        this.saveOrUpdate(smart);
    }

    public List<DTOSmartComponent.DTOSmartComponentNodo> getNodo(Long[] idNodo) {
        List nodos = this.serviceNodo.gets(idNodo);
        LinkedList<DTOSmartComponent.DTOSmartComponentNodo> ret = new LinkedList<DTOSmartComponent.DTOSmartComponentNodo>();
        for (Nodo n : nodos) {
            SmartComponentNodo sn = new SmartComponentNodo();
            sn.setNodo(n);
            ret.add(this.buildToDTOGeneric(sn, DTOSmartComponent.DTOSmartComponentNodo.class));
        }
        return ret;
    }

    public List<DTOSmartComponent.DTOSmartComponentGrUsu> getGrupo(Long[] idGrupo) {
        List grupos = this.serviceGrupo.gets(idGrupo);
        LinkedList<DTOSmartComponent.DTOSmartComponentGrUsu> ret = new LinkedList<DTOSmartComponent.DTOSmartComponentGrUsu>();
        for (Grupo n : grupos) {
            SmartComponentGrUsu sn = new SmartComponentGrUsu();
            sn.setGrupoUsuarios(n);
            ret.add(this.buildToDTOGeneric(sn, DTOSmartComponent.DTOSmartComponentGrUsu.class));
        }
        return ret;
    }

    public String getDescricao(Long idSmartComponent) {
        return ((DaoSmartComponentImpl)this.getDao()).getDescricao(idSmartComponent);
    }
}

