/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.smartlink;

import com.touchcomp.basementor.constants.enums.nodo.EnumConstNodos;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.EnvioMensagens;
import com.touchcomp.basementor.model.vo.ModeloEnvioMensagens;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementor.model.vo.SmartLink;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoSmartLinkImpl;
import com.touchcomp.basementorservice.helpers.impl.smartlink.HelperSmartLink;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.enviomensagens.ServiceBuildMensagensImpl;
import com.touchcomp.basementorservice.service.impl.enviomensagens.ServiceEnviarMensagensImpl;
import com.touchcomp.basementorservice.service.impl.enviomensagens.ServiceEnvioMensagensImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceBuildSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.InterfaceSCResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.SCResultEntityList;
import com.touchcomp.basementorservice.tasks.TaskCreator;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSmartLinkImpl
extends ServiceGenericEntityImpl<SmartLink, Long, DaoSmartLinkImpl> {
    @Autowired
    private ServiceBuildSmartComponentImpl serviceBuildSC;
    @Autowired
    private ServiceBuildMensagensImpl serviceBuildMensagensImpl;
    @Autowired
    private ServiceNodoImpl serviceNodo;
    @Autowired
    private ServiceEnvioMensagensImpl serviceEnvioMensagensImpl;
    @Autowired
    private ServiceEnviarMensagensImpl serviceEnviarMensagensImpl;
    @Autowired
    private HelperSmartLink helperSmartLink;

    @Autowired
    public ServiceSmartLinkImpl(DaoSmartLinkImpl genericDao) {
        super(genericDao);
    }

    public List<Pessoa> getDestinatariosSmartLink(SmartComponentPref smartComp) throws ExceptionBuildBI {
        BaseSmartComponenteResult<InterfaceSCResult> result = this.serviceBuildSC.buildSC(smartComp, new TaskCreator.TaskProgress());
        SCResultEntityList pessoas = (SCResultEntityList)result.getResult();
        if (pessoas.getResultList() == null || pessoas.getResultList().isEmpty()) {
            throw new ExceptionRuntimeBase("E.ERP.1969.001");
        }
        if (!(pessoas.getResultList().get(0) instanceof Pessoa)) {
            throw new ExceptionRuntimeBase("E.ERP.1969.002");
        }
        return pessoas.getResultList();
    }

    public SmartLink buildSmartLink(SmartComponentPref smartComp, EnumConstStatusObjeto status, Nodo nodo, Pessoa pessoa, ModeloEnvioMensagens modelo, Long registro, Date dataValidade, OpcoesSistema opcoes) throws UnknownHostException, ExceptionValidacaoDados, ExceptionBuildBI, ExceptionIO, ExceptionReflection, ExceptionInvalidData, ExceptionInvalidData, ExceptionInvalidState {
        Nodo smartLink = (Nodo)this.serviceNodo.get(EnumConstNodos.SMART_LINK.getValue());
        if (smartLink != null && TMethods.isStrWithData((String)smartLink.getPathWeb())) {
            SmartLink vo = this.helperSmartLink.buildSmartLink(smartComp, status, nodo, smartLink, pessoa, modelo, registro, dataValidade, opcoes);
            this.saveOrUpdate(vo);
            this.envioLink(vo);
            return vo;
        }
        throw new ExceptionValidacaoDados("E.ERP.1969.004", new Object[0]);
    }

    private void envioLink(SmartLink smartLink) throws ExceptionBuildBI, ExceptionIO, ExceptionReflection, ExceptionInvalidData, ExceptionInvalidState {
        EnvioMensagens envio = this.serviceBuildMensagensImpl.buildEnvioMensagens(smartLink.getModeloEnvioMensagens());
        envio = this.serviceEnvioMensagensImpl.saveOrUpdateFlush(envio);
        this.serviceEnviarMensagensImpl.enviarMensagens(envio);
    }

    public String urlToRedirect(Long idNodo, Long idRecurso, OpcoesSistema opcoes, String token) throws ExceptionObjNotFound, UnknownHostException {
        Nodo nodo = (Nodo)this.serviceNodo.getOrThrow(idNodo);
        SmartLink smartLink = this.getSmartLinkByNodo(idNodo, idRecurso);
        return this.helperSmartLink.urlToRedirect(nodo, idRecurso, opcoes, smartLink, token);
    }

    public SmartLink getSmartLinkByNodo(Long idNodo, Long idRegistro) {
        return ((DaoSmartLinkImpl)this.getGenericDao()).getSmartLinkByNodo(idNodo, idRegistro);
    }
}

