/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.spedecf;

import com.touchcomp.basementor.constants.enums.opcoesimpostos.EnumOpcoesImpostosTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.LancamentosRegistrosEcf;
import com.touchcomp.basementor.model.vo.LancamentosRegistrosEcfPlanoConta;
import com.touchcomp.basementor.model.vo.ParametrizacaoEcf;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SecfContabilParteALacs;
import com.touchcomp.basementor.model.vo.SecfLancParteALacs;
import com.touchcomp.basementor.model.vo.SpedEcf;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.saldoconta.ServiceSaldoContaImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SCompSpedEcfM350
extends ServiceGenericImpl {
    ServiceSaldoContaImpl serviceSaldoConta = (ServiceSaldoContaImpl)Context.get(ServiceSaldoContaImpl.class);

    public List<SecfLancParteALacs> buscarDadosM350(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        ArrayList<SecfLancParteALacs> listSecfLancParteALacs = new ArrayList<SecfLancParteALacs>();
        if (this.isEquals(spedEcf.getTipoApuracao(), (short)0) ? this.isNull(spedEcf.getDataInicial()) != false || this.isNull(spedEcf.getDataFinal()) != false : this.isNull(spedEcf.getDataInicial1()) != false || this.isNull(spedEcf.getDataFinal1()) != false || this.isNull(spedEcf.getDataInicial2()) != false || this.isNull(spedEcf.getDataFinal2()) != false || this.isNull(spedEcf.getDataInicial3()) != false || this.isNull(spedEcf.getDataFinal3()) != false || this.isNull(spedEcf.getDataInicial4()) != false || this.isNull(spedEcf.getDataFinal4()) != false) {
            throw new ExceptionInvalidData("E.ERP.1325.001", new Object[0]);
        }
        if (!this.isEquals(spedEcf.getFormaTributacaoPeriodo().getCodigo(), "R") && !this.isEquals(spedEcf.getFormaTributacaoPeriodo().getCodigo(), "E")) {
            throw new ExceptionInvalidData("E.ERP.1325.002", new Object[0]);
        }
        if (!(this.isEquals(spedEcf.getFormaTributacaoLucro().getCodigo(), "1") || this.isEquals(spedEcf.getFormaTributacaoLucro().getCodigo(), "2") || this.isEquals(spedEcf.getFormaTributacaoLucro().getCodigo(), "3") || this.isEquals(spedEcf.getFormaTributacaoLucro().getCodigo(), "4"))) {
            throw new ExceptionInvalidData("E.ERP.1325.003", new Object[0]);
        }
        if (!this.isEquals(spedEcf.getQualificaoPessoaJuridica().getCodigo(), "01")) {
            throw new ExceptionInvalidData("E.ERP.1325.004", new Object[0]);
        }
        if (this.isEquals(spedEcf.getTipoApuracao(), (short)0)) {
            this.gerarLan\u00e7amentosAnual(spedEcf, listParametrizacaoEcf, listSecfLancParteALacs);
        } else {
            this.gerarLan\u00e7amentosTrimestral(spedEcf, listParametrizacaoEcf, listSecfLancParteALacs);
        }
        return listSecfLancParteALacs;
    }

    private void gerarLan\u00e7amentosAnual(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf, List<SecfLancParteALacs> listSecfLancParteALacs) {
        ParametrizacaoEcf parametrizacaoEcf = this.pesquisarParametrizacaoEcf(spedEcf.getDataInicial(), spedEcf.getDataFinal(), listParametrizacaoEcf);
        if (parametrizacaoEcf == null) {
            return;
        }
        for (LancamentosRegistrosEcf lancamentosRegistrosEcf : parametrizacaoEcf.getLancamentosRegistroEcfM350()) {
            this.gerarLancamentos(spedEcf.getDataInicial(), spedEcf.getDataFinal(), spedEcf, lancamentosRegistrosEcf, listSecfLancParteALacs, (short)0);
            Date data = ToolDate.getDateLastMonthDay((Date)spedEcf.getDataInicial());
            for (int i = 1; i <= 12; ++i) {
                this.gerarLancamentos(data, data, spedEcf, lancamentosRegistrosEcf, listSecfLancParteALacs, (short)1);
                data = ToolDate.getDateLastMonthDay((Date)ToolDate.nextMonth((Date)data, (int)1));
            }
        }
    }

    private void gerarLan\u00e7amentosTrimestral(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf, List<SecfLancParteALacs> listSecfLancParteALacs) {
        ParametrizacaoEcf parametrizacaoEcf1 = this.pesquisarParametrizacaoEcf(spedEcf.getDataInicial1(), spedEcf.getDataFinal1(), listParametrizacaoEcf);
        ParametrizacaoEcf parametrizacaoEcf2 = this.pesquisarParametrizacaoEcf(spedEcf.getDataInicial2(), spedEcf.getDataFinal2(), listParametrizacaoEcf);
        ParametrizacaoEcf parametrizacaoEcf3 = this.pesquisarParametrizacaoEcf(spedEcf.getDataInicial3(), spedEcf.getDataFinal3(), listParametrizacaoEcf);
        ParametrizacaoEcf parametrizacaoEcf4 = this.pesquisarParametrizacaoEcf(spedEcf.getDataInicial4(), spedEcf.getDataFinal4(), listParametrizacaoEcf);
        if (parametrizacaoEcf1 == null && parametrizacaoEcf2 == null && parametrizacaoEcf3 == null && parametrizacaoEcf4 == null) {
            return;
        }
        if (parametrizacaoEcf1 != null) {
            for (LancamentosRegistrosEcf lancamentosRegistrosEcf : parametrizacaoEcf1.getLancamentosRegistroEcfM350()) {
                this.gerarLancamentos(spedEcf.getDataInicial1(), spedEcf.getDataFinal1(), spedEcf, lancamentosRegistrosEcf, listSecfLancParteALacs, (short)2);
            }
        }
        if (parametrizacaoEcf2 != null) {
            for (LancamentosRegistrosEcf lancamentosRegistrosEcf : parametrizacaoEcf2.getLancamentosRegistroEcfM350()) {
                this.gerarLancamentos(spedEcf.getDataInicial2(), spedEcf.getDataFinal2(), spedEcf, lancamentosRegistrosEcf, listSecfLancParteALacs, (short)2);
            }
        }
        if (parametrizacaoEcf3 != null) {
            for (LancamentosRegistrosEcf lancamentosRegistrosEcf : parametrizacaoEcf3.getLancamentosRegistroEcfM350()) {
                this.gerarLancamentos(spedEcf.getDataInicial3(), spedEcf.getDataFinal3(), spedEcf, lancamentosRegistrosEcf, listSecfLancParteALacs, (short)2);
            }
        }
        if (parametrizacaoEcf4 != null) {
            for (LancamentosRegistrosEcf lancamentosRegistrosEcf : parametrizacaoEcf4.getLancamentosRegistroEcfM350()) {
                this.gerarLancamentos(spedEcf.getDataInicial4(), spedEcf.getDataFinal4(), spedEcf, lancamentosRegistrosEcf, listSecfLancParteALacs, (short)2);
            }
        }
    }

    private ParametrizacaoEcf pesquisarParametrizacaoEcf(Date dataInicial, Date dataFinal, List<ParametrizacaoEcf> listParametrizacaoEcf) {
        return listParametrizacaoEcf.stream().filter(ecf -> !(!ecf.getDataInicial().before(dataInicial) && ToolDate.compareDate((Date)ecf.getDataInicial(), (Date)dataInicial) == false || !ecf.getDataFinal().after(dataFinal) && ToolDate.compareDate((Date)ecf.getDataFinal(), (Date)dataFinal) == false)).findFirst().orElse(null);
    }

    private void gerarLancamentos(Date dataInicial, Date dataFinal, SpedEcf spedEcf, LancamentosRegistrosEcf lancamentosRegistrosEcf, List<SecfLancParteALacs> listSecfLancParteALacs, Short tipo) {
        SecfLancParteALacs secfLancParteALacs = new SecfLancParteALacs();
        secfLancParteALacs.setPeriodo(dataFinal);
        secfLancParteALacs.setSpedEcf(spedEcf);
        secfLancParteALacs.setTabelaDinamica(lancamentosRegistrosEcf.getItemTabelaDinamica());
        secfLancParteALacs.setTipo(tipo);
        secfLancParteALacs.setIndicadorRelacao(this.verificarIndicadorRelacao(lancamentosRegistrosEcf));
        secfLancParteALacs.setTipoLancamento(this.verificarTipoLancamento(lancamentosRegistrosEcf));
        secfLancParteALacs.setValor(this.calcularValorSaldoPlanoConta(dataInicial, dataFinal, spedEcf, lancamentosRegistrosEcf.getPlanoConta(), secfLancParteALacs));
        listSecfLancParteALacs.add(secfLancParteALacs);
    }

    private Double calcularValorSaldoPlanoConta(Date dataInicial, Date dataFinal, SpedEcf spedEcf, List<LancamentosRegistrosEcfPlanoConta> listLancamentosRegistrosEcfPlanoConta, SecfLancParteALacs secfLancParteALacs) {
        Double valor = 0.0;
        for (LancamentosRegistrosEcfPlanoConta lancamentosRegistrosEcfPlanoConta : listLancamentosRegistrosEcfPlanoConta) {
            if (this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_SALDO_INICIAL.getEnumId())) {
                dataInicial = ToolDate.getDateFirstMonthDay((Date)dataInicial);
                dataFinal = ToolDate.getDateFirstMonthDay((Date)dataInicial);
            } else if (this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_SALDO_FINAL.getEnumId())) {
                dataInicial = ToolDate.getDateLastMonthDay((Date)dataFinal);
                dataFinal = ToolDate.getDateLastMonthDay((Date)dataFinal);
            } else if (this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_TOTAL_CREDITOS.getEnumId()) || this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_TOTAL_DEBITOS.getEnumId())) {
                dataInicial = ToolDate.getDateFirstMonthDay((Date)dataInicial);
                dataFinal = ToolDate.getDateLastMonthDay((Date)dataFinal);
            }
            List<SaldoContaContabil> saldos = this.serviceSaldoConta.findSaldosConta(null, null, lancamentosRegistrosEcfPlanoConta.getPlanoConta().getCodigo(), lancamentosRegistrosEcfPlanoConta.getPlanoConta().getCodigo(), dataInicial, dataFinal, this.isNotNull(spedEcf.getGrupoEmpresa()) != false ? spedEcf.getGrupoEmpresa().getIdentificador() : spedEcf.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador(), EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, EnumConstantsOrdenacao.ORDEM_NUMERICA, null);
            if (this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_SALDO_INICIAL.getEnumId())) {
                valor = valor + saldos.get(0).getSaldoAnterior();
                secfLancParteALacs.getRegistrosM360().add(this.criarRegistrosM360(secfLancParteALacs, lancamentosRegistrosEcfPlanoConta.getPlanoConta(), saldos.get(0).getSaldoAnterior()));
                continue;
            }
            if (this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_SALDO_FINAL.getEnumId())) {
                valor = valor + saldos.get(0).getSaldoAtual();
                secfLancParteALacs.getRegistrosM360().add(this.criarRegistrosM360(secfLancParteALacs, lancamentosRegistrosEcfPlanoConta.getPlanoConta(), saldos.get(0).getSaldoAtual()));
                continue;
            }
            if (this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_TOTAL_CREDITOS.getEnumId())) {
                valor = valor + saldos.get(0).getValorCredito();
                secfLancParteALacs.getRegistrosM360().add(this.criarRegistrosM360(secfLancParteALacs, lancamentosRegistrosEcfPlanoConta.getPlanoConta(), saldos.get(0).getValorCredito()));
                continue;
            }
            if (!this.isEquals(lancamentosRegistrosEcfPlanoConta.getTipoSaldo(), EnumOpcoesImpostosTipoSaldo.TIPO_SALDO_TOTAL_DEBITOS.getEnumId())) continue;
            valor = valor + saldos.get(0).getValorDebito();
            secfLancParteALacs.getRegistrosM360().add(this.criarRegistrosM360(secfLancParteALacs, lancamentosRegistrosEcfPlanoConta.getPlanoConta(), saldos.get(0).getValorDebito()));
        }
        return valor;
    }

    private Short verificarIndicadorRelacao(LancamentosRegistrosEcf lancamentosRegistrosEcf) {
        if (SCompSpedEcfM350.isWithData(lancamentosRegistrosEcf.getItemParteB()) && !SCompSpedEcfM350.isWithData(lancamentosRegistrosEcf.getPlanoConta())) {
            return (short)1;
        }
        if (!SCompSpedEcfM350.isWithData(lancamentosRegistrosEcf.getItemParteB()) && SCompSpedEcfM350.isWithData(lancamentosRegistrosEcf.getPlanoConta())) {
            return (short)2;
        }
        if (SCompSpedEcfM350.isWithData(lancamentosRegistrosEcf.getItemParteB()) && SCompSpedEcfM350.isWithData(lancamentosRegistrosEcf.getPlanoConta())) {
            return (short)3;
        }
        return (short)4;
    }

    private Short verificarTipoLancamento(LancamentosRegistrosEcf lancamentosRegistrosEcf) {
        if (this.isEquals(lancamentosRegistrosEcf.getItemTabelaDinamica().getTipoLancamento(), "A")) {
            return (short)1;
        }
        if (this.isEquals(lancamentosRegistrosEcf.getItemTabelaDinamica().getTipoLancamento(), "E")) {
            return (short)2;
        }
        if (this.isEquals(lancamentosRegistrosEcf.getItemTabelaDinamica().getTipoLancamento(), "P")) {
            return (short)3;
        }
        return (short)4;
    }

    private SecfContabilParteALacs criarRegistrosM360(SecfLancParteALacs secfLancParteALacs, PlanoConta planoConta, Double valor) {
        SecfContabilParteALacs secfContabilParteALacs = new SecfContabilParteALacs();
        secfContabilParteALacs.setIndicadorDebitoCredito(Short.valueOf((short)0));
        secfContabilParteALacs.setPlanoConta(planoConta);
        secfContabilParteALacs.setSecfLancParteALacs(secfLancParteALacs);
        secfContabilParteALacs.setValor(valor);
        return secfContabilParteALacs;
    }
}

