/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.spedecf;

import com.touchcomp.basementor.model.vo.ParametrizacaoEcf;
import com.touchcomp.basementor.model.vo.SecfBaseCalculoCsllLucroReal;
import com.touchcomp.basementor.model.vo.SecfBaseCalculoIrpjLucroReal;
import com.touchcomp.basementor.model.vo.SecfCalculoCsllLucroReal;
import com.touchcomp.basementor.model.vo.SecfCalculoIrpjLucroReal;
import com.touchcomp.basementor.model.vo.SecfInfComposicaoCustosLucroReal;
import com.touchcomp.basementor.model.vo.SecfLancParteALacs;
import com.touchcomp.basementor.model.vo.SecfLancParteALalur;
import com.touchcomp.basementor.model.vo.SecfLivroCaixa;
import com.touchcomp.basementor.model.vo.SpedEcf;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoSpedEcfImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.spedecf.SCompSpedEcf;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSpedEcfImpl
extends ServiceGenericEntityImpl<SpedEcf, Long, DaoSpedEcfImpl> {
    private Set<String> cabecalho = new HashSet<String>();
    @Autowired
    private SCompSpedEcf compSpedEcf;

    public ServiceSpedEcfImpl(DaoSpedEcfImpl genericDao) {
        super(genericDao);
    }

    @Override
    public DaoSpedEcfImpl getDao() {
        return (DaoSpedEcfImpl)super.getDao();
    }

    public File gerarArquivoPlanilha(List<SecfLivroCaixa> livroCaixa) throws Exception {
        List<Map> dadosResumidos = this.livroCaixaToMap(livroCaixa);
        File file = File.createTempFile("Bloco Q (Lucro Resumido)", ".csv");
        file.deleteOnExit();
        FileWriter out = new FileWriter(file);
        try {
            this.criarCabecalho(dadosResumidos);
            this.escreverCabecalho(out);
            this.escreverConteudo(dadosResumidos, out);
        }
        catch (IOException ex) {
            throw new Exception("Erro ao exportar os dados!");
        }
        finally {
            out.flush();
            out.close();
        }
        return file;
    }

    private List<Map> livroCaixaToMap(List<SecfLivroCaixa> livroCaixa) {
        ArrayList<Map> dadosResumidos = new ArrayList<Map>();
        for (SecfLivroCaixa item : livroCaixa) {
            LinkedHashMap<String, Object> itemMap = new LinkedHashMap<String, Object>();
            itemMap.put("Data", item.getData());
            itemMap.put("Nr Doc.", item.getNrDoc());
            itemMap.put("Hist\u00f3rico", item.getHistorico());
            itemMap.put("Vr. Entrada", item.getValorEntrada());
            itemMap.put("Vr. Sa\u00edda", item.getValorSaida());
            itemMap.put("Saldo Final", item.getSaldoFinal());
            dadosResumidos.add(itemMap);
        }
        return dadosResumidos;
    }

    private void criarCabecalho(List<Map> dados) {
        if (dados.isEmpty()) {
            return;
        }
        this.cabecalho = dados.get(0).keySet();
    }

    private void escreverConteudo(List<Map> dados, FileWriter out) throws IOException {
        for (Map item : dados) {
            for (String key : this.cabecalho) {
                Object ob = item.get(key);
                if (ob != null) {
                    out.write(String.valueOf(ob));
                }
                out.write(";");
            }
            out.write("\r\n");
        }
    }

    private void escreverCabecalho(FileWriter out) throws IOException {
        for (String item : this.cabecalho) {
            out.write(item);
            out.write(";");
        }
        out.write("\r\n");
    }

    public List<SecfInfComposicaoCustosLucroReal> buscarDadosL210(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        return this.compSpedEcf.buscarDadosL210(spedEcf, listParametrizacaoEcf);
    }

    public List<SecfLancParteALalur> buscarDadosM300(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        return this.compSpedEcf.buscarDadosM300(spedEcf, listParametrizacaoEcf);
    }

    public List<SecfLancParteALacs> buscarDadosM350(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        return this.compSpedEcf.buscarDadosM350(spedEcf, listParametrizacaoEcf);
    }

    public List<SecfBaseCalculoIrpjLucroReal> buscarDadosN500(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        return this.compSpedEcf.buscarDadosN500(spedEcf, listParametrizacaoEcf);
    }

    public List<SecfCalculoIrpjLucroReal> buscarDadosN630(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        return this.compSpedEcf.buscarDadosN630(spedEcf, listParametrizacaoEcf);
    }

    public List<SecfBaseCalculoCsllLucroReal> buscarDadosN650(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        return this.compSpedEcf.buscarDadosN650(spedEcf, listParametrizacaoEcf);
    }

    public List<SecfCalculoCsllLucroReal> buscarDadosN670(SpedEcf spedEcf, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionInvalidData {
        return this.compSpedEcf.buscarDadosN670(spedEcf, listParametrizacaoEcf);
    }
}

