/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelainss;

import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoTabelaINSSImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTabelaINSSImpl
extends ServiceGenericEntityImpl<TabelaINSS, Long, DaoTabelaINSSImpl> {
    @Autowired
    public ServiceTabelaINSSImpl(DaoTabelaINSSImpl dao) {
        super(dao);
    }

    public Boolean verificarPeriodo(Date dataInicial, Date dataFinal, Long idINSS) {
        Boolean ret;
        if (idINSS == null) {
            idINSS = 0L;
        }
        if ((ret = ((DaoTabelaINSSImpl)this.getDao()).verificarPeriodo(dataInicial, dataFinal, idINSS)) == null) {
            ret = false;
        }
        return ret;
    }

    @Override
    public TabelaINSS beforeSave(TabelaINSS vo) {
        Boolean existeTabEntreDatas;
        if (vo.getItensTabelaINSS() != null) {
            vo.getItensTabelaINSS().forEach(it -> it.setTabelaINSS(vo));
        }
        if (vo.getDataInicial() != null && vo.getDataFinal() != null && (existeTabEntreDatas = this.verificarPeriodo(vo.getDataInicial(), vo.getDataFinal(), vo.getIdentificador())).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0184.001"));
        }
        return vo;
    }

    public TabelaINSS getTabelaInssPorPeriodoFolha(Date periodoFolha) {
        return ((DaoTabelaINSSImpl)this.getGenericDao()).getTabelaInssPorPeriodoFolha(periodoFolha);
    }

    public TabelaINSS getTabelaInssPorDataInicialFinal(Date dataInicial, Date dataFinal) {
        return ((DaoTabelaINSSImpl)this.getGenericDao()).getTabelaInssPorDataInicialFinal(dataInicial, dataFinal);
    }
}

