/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelairrf;

import com.touchcomp.basementor.model.vo.TabelaIRRF;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoTabelaIRRFImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTabelaIRRFImpl
extends ServiceGenericEntityImpl<TabelaIRRF, Long, DaoTabelaIRRFImpl> {
    @Autowired
    public ServiceTabelaIRRFImpl(DaoTabelaIRRFImpl dao) {
        super(dao);
    }

    @Override
    public TabelaIRRF beforeSave(TabelaIRRF vo) {
        Boolean existeTabEntreDatas;
        if (vo.getItensTabela() != null) {
            vo.getItensTabela().forEach(it -> it.setTabelaIRRF(vo));
        }
        if (vo.getDataInicial() != null && vo.getDataFinal() != null && (existeTabEntreDatas = this.verificarPeriodo(vo.getDataInicial(), vo.getDataFinal(), vo.getIdentificador())).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0185.001"));
        }
        return vo;
    }

    public Boolean verificarPeriodo(Date dataInicial, Date dataFinal, Long idIRRF) {
        Boolean ret;
        if (idIRRF == null) {
            idIRRF = 0L;
        }
        return (ret = ((DaoTabelaIRRFImpl)this.getDao()).verificarPeriodo(dataInicial, dataFinal, idIRRF)) != null ? ret : false;
    }

    public TabelaIRRF getTabelaIrrfPorDataPagamento(Date dataPagamento) {
        return ((DaoTabelaIRRFImpl)this.getGenericDao()).getTabelaIrrfPorDataPagamento(dataPagamento);
    }
}

