/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto;

import com.touchcomp.basementor.model.impl.ProdutoPrecos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBase;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseTabBaseVinc;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.impl.DaoTabelaPrecoBaseImpl;
import com.touchcomp.basementorservice.helpers.impl.pretabelaprecos.HelperPreTabelaPrecos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.pretabelaprecobase.ServicePreTabelaPrecoBaseImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseProdutoImpl;
import com.touchcomp.touchvomodel.vo.tabelaprecobaseproduto.DTOTabelaPrecoBaseProdutoRes;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class ServiceTabelaPrecoBaseImpl
extends ServiceGenericEntityImpl<TabelaPrecoBase, Long, DaoTabelaPrecoBaseImpl> {
    @Autowired
    ServiceTabelaPrecoBaseProdutoImpl serviceTabPrecoProd;
    @Autowired
    ServicePreTabelaPrecoBaseImpl servicePreTab;

    public ServiceTabelaPrecoBaseImpl(DaoTabelaPrecoBaseImpl repository) {
        super(repository);
    }

    public HashMap findDataUltimaGeracaoArquivoXML() {
        return ((DaoTabelaPrecoBaseImpl)this.getGenericDao()).findDataUltimaGeracaoArquivoXML();
    }

    public void insertDataUltimaGeracaoArquivoXML(String idNatureza, String idCentroEstoque, String idTabelaBase) {
        ((DaoTabelaPrecoBaseImpl)this.getGenericDao()).insertDataUltimaGeracaoArquivoXML(idNatureza, idCentroEstoque, idTabelaBase);
    }

    public List<ProdutoPrecos> getProdutosPrecosCodBarras(TabelaPrecoBase tabPrecoBase) {
        return ((DaoTabelaPrecoBaseImpl)this.getGenericDao()).getProdutosPrecosTabCodBarras(tabPrecoBase);
    }

    public List<ProdutoPrecos> getProdutosVendaFracionados(TabelaPrecoBase tabPrecoBase) {
        return ((DaoTabelaPrecoBaseImpl)this.getGenericDao()).getProdutosVendaFracionada(tabPrecoBase);
    }

    public List<TabelaPrecoBase> getAllTabelasAtivas() {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getAllTabelasAtivas();
    }

    public List<Produto> getProdByDescCodAux(String text, Empresa emp) {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getProdByDescCodAux(text, emp);
    }

    public Double getValorCustoTabPrincipal(Produto prod, Empresa emp) {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getValorCustoTabPrincipal(prod, emp);
    }

    public Double getValorVendaTabPrincipal(Produto prod, Empresa emp) {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getValorVendaTabPrincipal(prod, emp);
    }

    public Double getPercComissaoMultiplasComissoesTabelaBase(Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Double valorUnitario) {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getPercComissaoMultiplasComissoesTabelaBase(produto, dataEmissao, uf, moeda, valorUnitario);
    }

    public void vincularPreTabPreco(PreTabelaPrecoBase preTab, TabelaPrecoBase tabelaPrecoBase) {
        TabelaPrecoBaseProduto tabPrecoBaseProd;
        ArrayList<TempTabPrecoBaseProd> temp = new ArrayList<TempTabPrecoBaseProd>();
        for (PreTabelaPrecoBaseProduto pr : preTab.getProdutos()) {
            tabPrecoBaseProd = this.serviceTabPrecoProd.getTabelaPrecoBaseProd(tabelaPrecoBase, pr.getProduto());
            if (tabPrecoBaseProd == null) {
                tabPrecoBaseProd = new TabelaPrecoBaseProduto();
                tabPrecoBaseProd.setAtivo(Short.valueOf((short)1));
                tabPrecoBaseProd.setProduto(pr.getProduto());
                tabPrecoBaseProd.setTabelaPrecoBase(tabelaPrecoBase);
                tabPrecoBaseProd.setValorCusto(pr.getValorCusto());
                tabPrecoBaseProd.setValorVenda(pr.getValorVenda());
                tabPrecoBaseProd.setMargemLucro(pr.getMargemLucro());
                tabPrecoBaseProd.setPercComissaoPadrao(pr.getPercComissaoPadrao());
                tabPrecoBaseProd.setPercMaximo(pr.getPercMaximo());
                tabPrecoBaseProd.setPercMinimo(pr.getPercMinimo());
                tabPrecoBaseProd.setValorMinimo(pr.getVlrMinimo());
                tabPrecoBaseProd.setValorMaximo(pr.getVlrMaximo());
                tabPrecoBaseProd.setPercentualDescTrib(pr.getPercentualDescTrib());
                this.serviceTabPrecoProd.saveOrUpdateFlush(tabPrecoBaseProd);
                continue;
            }
            TempTabPrecoBaseProd t = new TempTabPrecoBaseProd(this, tabPrecoBaseProd, pr);
            temp.add(t);
        }
        for (TempTabPrecoBaseProd t : temp) {
            tabPrecoBaseProd = t.tabelaPrecoBaseProduto;
            PreTabelaPrecoBaseProduto pr = t.preTabelaPrecoBaseProduto;
            tabPrecoBaseProd.setValorCusto(pr.getValorCusto());
            tabPrecoBaseProd.setValorVenda(pr.getValorVenda());
            tabPrecoBaseProd.setMargemLucro(pr.getMargemLucro());
            tabPrecoBaseProd.setPercComissaoPadrao(pr.getPercComissaoPadrao());
            tabPrecoBaseProd.setPercMaximo(pr.getPercMaximo());
            tabPrecoBaseProd.setPercMinimo(pr.getPercMinimo());
            tabPrecoBaseProd.setValorMinimo(pr.getVlrMinimo());
            tabPrecoBaseProd.setValorMaximo(pr.getVlrMaximo());
            tabPrecoBaseProd.setPercentualDescTrib(pr.getPercentualDescTrib());
        }
        PreTabelaPrecoBaseTabBaseVinc pre = new HelperPreTabelaPrecos(null).getTabPrecoRefProd(preTab.getTabelasVinculadas());
        if (pre == null) {
            pre = new PreTabelaPrecoBaseTabBaseVinc();
            pre.setPreTabelaPrecoBase(preTab);
            pre.setTabelaVinculada(tabelaPrecoBase);
            preTab.getTabelasVinculadas().add(pre);
        }
        pre.setDataHoraVinculacao(new Date());
        this.servicePreTab.saveOrUpdate(preTab);
        this.afterSaveEntity(tabelaPrecoBase);
    }

    public TabelaPrecoBase getTabelaPrecoBasePrincipal(Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Empresa empresa) {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getTabelaPrecoBasePrincipal(dataEmissao, uf, moeda, empresa);
    }

    @Override
    public TabelaPrecoBase afterSaveEntity(final TabelaPrecoBase entity) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                ServiceTabelaPrecoBaseImpl.this.serviceTabPrecoProd.forcarDtAtualizacaoProdAlterados(entity);
            }
        });
        return (TabelaPrecoBase)this.get(entity.getIdentificador());
    }

    DTOTabelaPrecoBaseProdutoRes getValorVendaTabPrincipal(String barcode, Empresa emp) {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getValorVendaTabPrincipal(barcode, emp);
    }

    public List<TabelaPrecoBase> getTabelasPrecoAtivas(Produto produto) {
        return ((DaoTabelaPrecoBaseImpl)this.getDao()).getTabelasPrecoAtivas(produto);
    }

    private class TempTabPrecoBaseProd {
        private TabelaPrecoBaseProduto tabelaPrecoBaseProduto;
        private PreTabelaPrecoBaseProduto preTabelaPrecoBaseProduto;

        public TempTabPrecoBaseProd(ServiceTabelaPrecoBaseImpl serviceTabelaPrecoBaseImpl, TabelaPrecoBaseProduto tabelaPrecoBaseProduto, PreTabelaPrecoBaseProduto preTabelaPrecoBaseProduto) {
            this.tabelaPrecoBaseProduto = tabelaPrecoBaseProduto;
            this.preTabelaPrecoBaseProduto = preTabelaPrecoBaseProduto;
        }

        public TabelaPrecoBaseProduto getTabelaPrecoBaseProduto() {
            return this.tabelaPrecoBaseProduto;
        }

        public void setTabelaPrecoBaseProduto(TabelaPrecoBaseProduto tabelaPrecoBaseProduto) {
            this.tabelaPrecoBaseProduto = tabelaPrecoBaseProduto;
        }

        public PreTabelaPrecoBaseProduto getPreTabelaPrecoBaseProduto() {
            return this.preTabelaPrecoBaseProduto;
        }

        public void setPreTabelaPrecoBaseProduto(PreTabelaPrecoBaseProduto preTabelaPrecoBaseProduto) {
            this.preTabelaPrecoBaseProduto = preTabelaPrecoBaseProduto;
        }
    }
}

