/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.impl.DaoTabelaPrecoBaseProdutoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceTabelaPrecoBaseProduto;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceTabelaPrecoBaseProdutoImpl
extends ServiceGenericEntityImpl<TabelaPrecoBaseProduto, Long, DaoTabelaPrecoBaseProdutoImpl>
implements ServiceTabelaPrecoBaseProduto {
    @Autowired
    public ServiceTabelaPrecoBaseProdutoImpl(DaoTabelaPrecoBaseProdutoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public Map<String, Object> getDadosPrecoProdEngProd(Long idProduto, Date dataConsulta) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getGenericDao()).getDadosPrecoProdEngProd(idProduto, dataConsulta);
    }

    @Override
    public TabelaPrecoBaseProduto getTabelaPrecoBaseProdAtivo(TabelaPrecoBase tabBase, Produto produto) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getGenericDao()).getTabelaPrecoBaseProdAtivo(tabBase, produto);
    }

    @Override
    public List<TabelaPrecoBaseProduto> getProdutosTabelaPreco(String text, TabelaPrecoBase tabela, Empresa empresa, EnumConstantsMentorSimNao usarIdentificador) {
        if (text.length() > 115) {
            return new LinkedList<TabelaPrecoBaseProduto>();
        }
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getGenericDao()).getProdutosTabelaPreco(text, tabela, empresa, usarIdentificador);
    }

    public TabelaPrecoBaseProduto getTabelaPrecoBaseProd(TabelaPrecoBase tabBase, Produto produto) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getGenericDao()).getTabelaPrecoBaseProd(tabBase, produto);
    }

    public TabelaPrecoBaseProduto getTabelaPrecoBaseProdTabVinc(TabelaPrecoBase tabBase, Produto produto) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getGenericDao()).getTabelaPrecoBaseProdTabVinc(tabBase, produto);
    }

    public List<Produto> getProdutosCriadosAltVincTab(Date lastSinc, Long idTabPrecos) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).getProdutosCriadosAltVincTab(lastSinc, idTabPrecos);
    }

    public void salvarAtualizarProd(List<TabelaPrecoBaseProduto> produtos) {
        LinkedList<TabelaPrecoBaseProduto> temp = new LinkedList<TabelaPrecoBaseProduto>();
        for (TabelaPrecoBaseProduto t : produtos) {
            temp.add(this.saveOrUpdateFlush(t));
        }
        for (TabelaPrecoBaseProduto tab : temp) {
            List<TabelaPrecoBaseProduto> aux = this.getTabPrecoProdSimPrecosIguais(tab.getProduto(), tab.getTabelaPrecoBase());
            for (TabelaPrecoBaseProduto si : aux) {
                if (temp.contains(si) || produtos.contains(si)) continue;
                si.setMargemLucro(tab.getMargemLucro());
                si.setPercComissaoPadrao(tab.getPercComissaoPadrao());
                si.setPercMaximo(tab.getPercMaximo());
                si.setPercMaximoComissao(tab.getPercMaximoComissao());
                si.setPercMinimo(tab.getPercMinimo());
                si.setPercMinimoComissao(tab.getPercMinimoComissao());
                si.setValorCusto(tab.getValorCusto());
                si.setValorMaximo(tab.getValorMaximo());
                si.setValorMinimo(tab.getValorMinimo());
                si.setValorVenda(tab.getValorVenda());
                si.setPercentualDescTrib(tab.getPercentualDescTrib());
                this.saveOrUpdateFlush(si);
            }
        }
    }

    public List<TabelaPrecoBaseProduto> getTabPrecoProdSimPrecosIguais(Produto produto, TabelaPrecoBase tabelaPrecoBase) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).getTabPrecoProdSimPrecosIguais(produto, tabelaPrecoBase);
    }

    public List<TabelaPrecoBaseProduto> getTabPrecoBaseProdsAtivos(Produto produto) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).getTabPrecoBaseProdsAtivos(produto);
    }

    public List<TabelaPrecoBaseProduto> getProdutosCriadosAltVincTab(Date lastSinc, TabelaPrecoBase tabBase, int firstRes, Integer maxRegs) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).getProdutosCriadosAltVincTab(lastSinc, tabBase, firstRes, maxRegs);
    }

    public List<TabelaPrecoBaseProduto> getItensCriadosAltVincTab(Date lastSinc, TabelaPrecoBase tab, Integer firstRes, Integer maxRes) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).getItensCriadosAltVincTab(lastSinc, tab, firstRes, maxRes);
    }

    public boolean forcarDataAtualizacaoProdutos(TabelaPrecoBase tabela) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).forcarDataAtualizacaoProdutos(tabela);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean forcarDtAtualizacaoProdAlterados(TabelaPrecoBase tabela) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).forcarDtAtualizacaoProdAlterados(tabela);
    }

    public TabelaPrecoBaseProduto getPrecosBasePrincipal(TabelaPrecoBase tabelaBase, Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Empresa empresa) {
        if (tabelaBase == null) {
            return null;
        }
        TabelaPrecoBaseProduto tabelaPrecoBaseProduto = ((DaoTabelaPrecoBaseProdutoImpl)this.getDao()).getTabelaPrecoBaseProdTabVinc(tabelaBase, produto);
        return tabelaPrecoBaseProduto;
    }

    public List<Produto> findProdutosByCategoria(String search, Long categoria, Pageable page) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getGenericDao()).findProdutosByCategoria(search, categoria, page);
    }

    public TabelaPrecoBaseProduto getTabBaseUsoInterno(Produto produto, Date data, Moeda moeda, Empresa empresa) {
        return ((DaoTabelaPrecoBaseProdutoImpl)this.getGenericDao()).getTabBaseUsoInterno(produto, data, moeda, empresa);
    }
}

