/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsTerminalConsPrecosGertecHTTP;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.tabelaprecobaseproduto.DTOTabelaPrecoBaseProdutoRes;
import java.util.HashMap;
import org.jdom2.Content;
import org.jdom2.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTerminalConsPrecoGertecImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceTabelaPrecoBaseImpl serviceTabelaPreco;
    @Autowired
    ServiceConfigServicosImpl serviceConfigServicosImpl;
    @Autowired
    HelperConfigServicos helperConfigServicos;
    public static final String CNPJ_CONSULTA = "cnpjEmpresa";
    public static final String IP_PORTA = "ipPorta";
    public static final String PRICE_CHECKER_FILE = "price_checker.xml";
    public static final String MEDIA_MANAGER_FILE = "media_manager.xml";

    public String getPriceChecker(String idEmpresa, String baseURL) {
        ConfigServicos config = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.TERMINAL_CONSULTA_PRECOS_GERTEC_HTTP, ConstantsTerminalConsPrecosGertecHTTP.ID_EMPRESA.getChave(), idEmpresa);
        this.checkAndThrownNotExists((Object)config, EnumConstConfigServicos.TERMINAL_CONSULTA_PRECOS_GERTEC_HTTP.getChave());
        String auxUrl = this.helperConfigServicos.build(config).getValue(ConstantsTerminalConsPrecosGertecHTTP.URLS_CONSULTA.getChave());
        Element root = new Element("price_checker");
        root.setAttribute("version", "0.1.0");
        Element urls = new Element("urls");
        root.addContent((Content)urls);
        String[] data = TString.splitString((String)auxUrl, (char[])new char[]{'.', ':'});
        int seq = 1;
        for (String ipPorta : data) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put(CNPJ_CONSULTA, idEmpresa);
            m.put(IP_PORTA, ipPorta);
            String urlAux = ToolString.build((String)baseURL, m);
            Element url = new Element("url");
            url.setAttribute("id", String.valueOf(seq));
            url.setAttribute("value", urlAux);
            urls.addContent((Content)url);
        }
        return ToolJdom.toXml((Element)root);
    }

    public String getMediaManager(String idEmpresa) {
        ConfigServicos config = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.TERMINAL_CONSULTA_PRECOS_GERTEC_HTTP, ConstantsTerminalConsPrecosGertecHTTP.ID_EMPRESA.getChave(), idEmpresa);
        this.checkAndThrownNotExists((Object)config, EnumConstConfigServicos.TERMINAL_CONSULTA_PRECOS_GERTEC_HTTP.getChave());
        String mediaManager = this.helperConfigServicos.build(config).getValue(ConstantsTerminalConsPrecosGertecHTTP.MEDIA_MANAGER.getChave());
        if (!TMethods.isStrWithData((String)mediaManager)) {
            Element root = new Element("media_manager");
            root.setAttribute("media-version", "0.1.0");
            return ToolJdom.toXml((Element)root);
        }
        return mediaManager;
    }

    public String getPreco(String idEmpresa, String barcode) {
        ConfigServicos config = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.TERMINAL_CONSULTA_PRECOS_GERTEC_HTTP, ConstantsTerminalConsPrecosGertecHTTP.ID_EMPRESA.getChave(), idEmpresa);
        this.checkAndThrownNotExists((Object)config, EnumConstConfigServicos.TERMINAL_CONSULTA_PRECOS_GERTEC_HTTP.getChave());
        String html = this.helperConfigServicos.build(config).getValue(ConstantsTerminalConsPrecosGertecHTTP.HTML_CONSULTA_RETORNO.getChave());
        String htmlNaoEncontrado = this.helperConfigServicos.build(config).getValue(ConstantsTerminalConsPrecosGertecHTTP.HTML_CONSULTA_RETORNO_PROD_NAO_ENCONTRADO.getChave());
        Empresa emp = this.getSharedData().getEmpresa(Long.valueOf(idEmpresa));
        DTOTabelaPrecoBaseProdutoRes res = this.serviceTabelaPreco.getValorVendaTabPrincipal(barcode, emp);
        HashMap<String, Object> h = new HashMap<String, Object>();
        String format = html;
        h.put("codigo", barcode);
        h.put("valorVenda", ToolFormatter.formataNumero((Number)res.getValorVenda(), (int)2));
        if (res.getProduto() != null) {
            h.put("idProduto", res.getProduto().getIdentificador());
            h.put("codigoAuxiliar", res.getProduto().getCodigoAuxiliar());
            h.put("nome", res.getProduto().getNome());
            h.put("unidadeMedida", res.getProduto().getUnidadeMedidaSigla());
        } else {
            format = htmlNaoEncontrado;
        }
        return ToolString.build((String)format, h);
    }
}

