/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoes;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesEmp;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProdQtd;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoTabelaPrecoPromocoesImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ServiceTabelaPrecoPromocoesImpl
extends ServiceGenericEntityImpl<TabelaPrecoPromocoes, Long, DaoTabelaPrecoPromocoesImpl> {
    ServiceProdutoImpl serviceProdutoImpl;
    ServiceEmpresaImpl serviceEmpresaImpl;

    public ServiceTabelaPrecoPromocoesImpl(DaoTabelaPrecoPromocoesImpl dao, ServiceProdutoImpl serviceProdutoImpl, ServiceEmpresaImpl serviceEmpresaImpl) {
        super(dao);
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
    }

    public <T> List<T> getItemTabelaPreco(Class<T> aClass, Long[] idProdutos) throws ExceptionObjNotFound {
        List produtos = this.serviceProdutoImpl.gets(idProdutos);
        LinkedList<TabelaPrecoPromocoesProd> ret = new LinkedList<TabelaPrecoPromocoesProd>();
        for (Produto produto : produtos) {
            TabelaPrecoPromocoesProd p = new TabelaPrecoPromocoesProd();
            p.setProduto(produto);
            ret.add(p);
        }
        return this.buildToDTOGeneric(ret, aClass);
    }

    public <T> T getItemTabelaPrecoQtd(Class<T> aClass) {
        return this.buildToDTOGeneric(new TabelaPrecoPromocoesProdQtd(), aClass);
    }

    public <T> List<T> getEmpresaTabelaPreco(Class<T> aClass, Long[] idEmpresa) throws ExceptionObjNotFound {
        List empresas = this.serviceEmpresaImpl.gets(idEmpresa);
        LinkedList<TabelaPrecoPromocoesEmp> ret = new LinkedList<TabelaPrecoPromocoesEmp>();
        for (Empresa empresa : empresas) {
            TabelaPrecoPromocoesEmp p = new TabelaPrecoPromocoesEmp();
            p.setEmpresa(empresa);
            ret.add(p);
        }
        return this.buildToDTOGeneric(ret, aClass);
    }

    public TabelaPrecoPromocoesProd getTabelaPrecosPromo(Produto produto, Date dataEmissao, Empresa empresa) {
        return ((DaoTabelaPrecoPromocoesImpl)this.getDao()).getTabelaPrecosPromo(produto, dataEmissao, empresa);
    }

    public TabelaPrecoPromocoesProd getTabelaPrecosPromoBase(Produto produto, Date dataEmissao, Empresa empresa, TabelaPrecoBase tabela) {
        return ((DaoTabelaPrecoPromocoesImpl)this.getDao()).getTabelaPrecosPromoTabBase(produto, dataEmissao, empresa, tabela);
    }

    public TabelaPrecoPromocoesProdQtd getTabelaPrecosPromo(Produto produto, Empresa empresa, Date dataEmissao, Double quantidade) {
        return ((DaoTabelaPrecoPromocoesImpl)this.getDao()).getTabelaPrecosPromo(produto, empresa, dataEmissao, quantidade);
    }

    public List<Produto> getProdutosDestaquePromocao(Date dataEmissao, Empresa empresa, Pageable pageable) {
        return ((DaoTabelaPrecoPromocoesImpl)this.getDao()).getTabelaPrecosPromo(empresa, dataEmissao, pageable);
    }

    @Override
    public TabelaPrecoPromocoes beforeSave(TabelaPrecoPromocoes aux) {
        for (TabelaPrecoPromocoesEmp emp : aux.getEmpresas()) {
            emp.setTabelaPrecoPromocoes(aux);
        }
        for (TabelaPrecoPromocoesProd prod : aux.getProdutos()) {
            prod.setTabelaPrecoPromocoes(aux);
            if (prod.getTabelaPrecoPromocoesProdQtd() == null) continue;
            prod.getTabelaPrecoPromocoesProdQtd().forEach(i -> i.setTabelaPrecoPromocoesProd(prod));
        }
        return aux;
    }
}

