/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecos;

import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFaturamentoOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.ComissaoItemPedido;
import com.touchcomp.basementor.model.impl.ValoresPrecoItemPedido;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TabelaPrecosDinamicaCond;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.avaliadorexpressoes.CompAvaliadorExpressoes;
import com.touchcomp.basementorservice.helpers.impl.calculos.HelperCalcPrecosProduto;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfaturamento.HelperOpcoesFaturamento;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseProdutoImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes.ServiceTabelaPrecoPromocoesImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecosdinamica.ServiceTabelaPrecosDinamicalImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOResultCalcExpressoes;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCalcTabPrecoDinamicaImpl
extends ServiceGenericImpl {
    @Autowired
    HelperCalcPrecosProduto helperCalcPrecosProduto;
    @Autowired
    ServiceTabelaPrecoPromocoesImpl serviceTabelaPrecoPromocoesImpl;
    @Autowired
    private ServiceTabelaPrecosDinamicalImpl serviceTabelaPrecosDinamica;
    @Autowired
    private ServiceTabelaPrecoBaseProdutoImpl serviceTabelaPrecoBaseProduto;

    public ValoresPrecoItemPedido calcularValores(OpcoesFaturamento op, UnidadeFatCliente unid, Representante rep, Produto produto, Moeda moeda, CondicoesPagamento condicoesPagamento, TipoFrete tipoFrete, Empresa empresa, int nrDiasMedios, NaturezaOperacao natOP, Usuario usuario) throws ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes {
        TabelaPrecosDinamicaCond aval = this.serviceTabelaPrecosDinamica.getTabela(unid, empresa, rep, produto, op.getFormatoPesquisaTabDinamica(), true);
        if (aval == null) {
            throw new ExceptionCalcPrecosProduto("E.ERP.1511.006", new Object[]{unid.getCliente().getPessoa().getNome(), empresa.getPessoa().getNomeFantasia(), rep.getPessoa().getNome(), produto.getNome()});
        }
        ValoresPrecoItemPedido val = new ValoresPrecoItemPedido(op.getTipoTabelaPreco());
        TabelaPrecoBaseProduto tbp = this.getTabelaPrecoBaseProd(aval, produto);
        HelperOpcoesFaturamento helper = (HelperOpcoesFaturamento)Context.get(HelperOpcoesFaturamento.class);
        TabelaPrecoPromocoesProd tabelaPromo = null;
        tabelaPromo = CompOpcoes.isAffirmative(helper.build(op).getItens(), (EnumOpDinamicasInterface)EnumConstOpFaturamentoOp.UTILIZAR_TABELA_PROMO_TABELA_BASE) ? this.serviceTabelaPrecoPromocoesImpl.getTabelaPrecosPromoBase(produto, new Date(), empresa, tbp.getTabelaPrecoBase()) : this.serviceTabelaPrecoPromocoesImpl.getTabelaPrecosPromo(produto, new Date(), empresa);
        Map values = this.helperCalcPrecosProduto.buildParameters(op, unid, rep, produto, moeda, condicoesPagamento, tbp, tipoFrete, empresa, natOP, usuario);
        this.calculaVlrMaximo(val, values, aval, tbp, tabelaPromo, nrDiasMedios);
        this.calculaVlrMinimo(val, values, aval, tbp, tabelaPromo, nrDiasMedios);
        this.calculaVlrSugerido(val, values, aval, tbp, tabelaPromo, nrDiasMedios);
        ComissaoItemPedido resultPercComissao = this.avaliaComissao(val.getValorSugerido(), val.getValorMinimo(), val.getValorMaximo(), 0.0, nrDiasMedios, aval, tbp, tabelaPromo, values);
        val.setComissao(resultPercComissao);
        val.setValorCusto(tbp.getValorCusto());
        val.setPercDescTributario(tbp.getPercentualDescTrib());
        return val;
    }

    private TabelaPrecoBaseProduto getTabelaPrecoBaseProd(TabelaPrecosDinamicaCond aval, Produto produto) throws ExceptionCalcPrecosProduto {
        TabelaPrecoBaseProduto t = this.serviceTabelaPrecoBaseProduto.getTabelaPrecoBaseProdTabVinc(aval.getTabelaPrecoBase(), produto);
        if (t == null) {
            throw new ExceptionCalcPrecosProduto("E.ERP.1511.004", new Object[]{aval.getTabelaPrecoBase().getDescricao(), produto.getNome()});
        }
        if (t.getTabelaPrecoBase() != null && t.getTabelaPrecoBase().getDataFinal() != null && t.getTabelaPrecoBase().getDataFinal().before(new Date())) {
            throw new ExceptionCalcPrecosProduto("E.ERP.1511.005", new Object[]{aval.getTabelaPrecoBase().getDescricao(), produto.getNome()});
        }
        return t;
    }

    private void calculaVlrMaximo(ValoresPrecoItemPedido val, Map values, TabelaPrecosDinamicaCond aval, TabelaPrecoBaseProduto tabPrecoBase, TabelaPrecoPromocoesProd tabelaPromo, Integer nrDiasMedios) throws ExceptionAvaliadorExpressoes {
        Double valorMinimo = 0.0;
        Double valorMaximo = 0.0;
        if (tabelaPromo != null) {
            valorMaximo = tabelaPromo.getValorMaximo();
            valorMinimo = tabelaPromo.getValorMinimo();
        }
        if (tabelaPromo == null || !TMethods.isWithData((Number)valorMinimo)) {
            valorMinimo = tabPrecoBase.getValorMinimo();
        }
        if (tabelaPromo == null || !TMethods.isWithData((Number)valorMaximo)) {
            valorMaximo = tabPrecoBase.getValorMaximo();
        }
        values.put("pre_valor_minimo_calc_ped", valorMinimo);
        values.put("pre_valor_maximo_calc_ped", valorMaximo);
        values.put("pre_nr_dias_medios_cond_pag", nrDiasMedios);
        values.put("pre_perc_desconto_inf", 0.0);
        values.put("pre_valor_unitario_inf", 0.0);
        values.put(tabPrecoBase.getClass().getCanonicalName(), tabPrecoBase);
        values.put("valorVenda", valorMaximo);
        DTOResultCalcExpressoes resultVlrMaximo = CompAvaliadorExpressoes.processAndValidateValue(aval.getAvaliadorExpressoes(), values);
        if (resultVlrMaximo != null) {
            val.setValorMaximo(resultVlrMaximo.getResultado());
        } else {
            val.setValorMaximo(Double.valueOf(0.0));
        }
    }

    private void calculaVlrMinimo(ValoresPrecoItemPedido val, Map values, TabelaPrecosDinamicaCond aval, TabelaPrecoBaseProduto tabPrecoBase, TabelaPrecoPromocoesProd tabelaPromo, Integer nrDiasMedios) throws ExceptionAvaliadorExpressoes {
        Double valorMinimo = 0.0;
        if (tabelaPromo != null) {
            valorMinimo = tabelaPromo.getValorMinimo();
        }
        if (tabelaPromo == null || !TMethods.isWithData((Number)valorMinimo)) {
            valorMinimo = tabPrecoBase.getValorMinimo();
        }
        values.put("valorVenda", valorMinimo);
        DTOResultCalcExpressoes resultVlrMinimo = CompAvaliadorExpressoes.processAndValidateValue(aval.getAvaliadorExpressoes(), values);
        if (resultVlrMinimo != null) {
            val.setValorMinimo(resultVlrMinimo.getResultado());
        } else {
            val.setValorMinimo(Double.valueOf(0.0));
        }
    }

    private void calculaVlrSugerido(ValoresPrecoItemPedido val, Map values, TabelaPrecosDinamicaCond aval, TabelaPrecoBaseProduto tbp, TabelaPrecoPromocoesProd tabelaPromo, Integer nrDiasMedios) throws ExceptionAvaliadorExpressoes {
        if (tabelaPromo != null && tbp.getValorVenda() - tabelaPromo.getValorVenda() >= 0.0) {
            val.setValorDescontoTabelaPromo(Double.valueOf(tbp.getValorVenda() - tabelaPromo.getValorVenda()));
            val.setTabelaDescontoPromoProd(tabelaPromo);
        }
        values.put("valorVenda", tbp.getValorVenda());
        DTOResultCalcExpressoes resultVlrSugerido = CompAvaliadorExpressoes.processAndValidateValue(aval.getAvaliadorExpressoes(), values);
        Double valorSug = 0.0;
        if (resultVlrSugerido != null) {
            valorSug = resultVlrSugerido.getResultado();
        }
        val.setValorSugerido(valorSug);
        val.setVlrDescTributario(Double.valueOf(valorSug - valorSug * val.getPercDescTributario() / 100.0));
        if (resultVlrSugerido != null) {
            val.setAvaliadorExpFormulasCalPreco(CompAvaliadorExpressoes.getExp(aval.getAvaliadorExpressoes(), resultVlrSugerido));
        }
    }

    public ComissaoItemPedido avaliaComissao(OpcoesFaturamento op, UnidadeFatCliente unid, Representante rep, Produto produto, Date dataEmissao, Moeda moeda, CondicoesPagamento condicoesPagamento, String parcelas, TipoFrete tipoFrete, Empresa empresa, Double valorUnitario, Double valorMin, Double valorMax, Double percComissao, Double percDesconto, int nrDiasMedios, NaturezaOperacao natOP, Usuario usuario) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto {
        TabelaPrecosDinamicaCond aval = this.serviceTabelaPrecosDinamica.getTabela(unid, empresa, rep, produto, op.getFormatoPesquisaTabDinamica(), true);
        if (aval == null) {
            throw new ExceptionCalcPrecosProduto("E.ERP.1511.006", new Object[]{unid.getCliente().getPessoa().getNome(), empresa.getPessoa().getNomeFantasia(), rep.getPessoa().getNome(), produto.getNome()});
        }
        TabelaPrecoBaseProduto tbp = this.getTabelaPrecoBaseProd(aval, produto);
        TabelaPrecoPromocoesProd tabelaPromo = this.serviceTabelaPrecoPromocoesImpl.getTabelaPrecosPromo(produto, new Date(), empresa);
        Map values = this.helperCalcPrecosProduto.buildParameters(op, unid, rep, produto, moeda, condicoesPagamento, tbp, tipoFrete, empresa, natOP, usuario);
        return this.avaliaComissao(valorUnitario, valorMin, valorMax, percDesconto, nrDiasMedios, aval, tbp, tabelaPromo, values);
    }

    private ComissaoItemPedido avaliaComissao(Double valorUnitario, Double valorMin, Double valorMax, Double percDesconto, int nrDiasMedios, TabelaPrecosDinamicaCond aval, TabelaPrecoBaseProduto tbp, TabelaPrecoPromocoesProd tabelaPromo, Map values) throws ExceptionAvaliadorExpressoes {
        if (aval.getAvaliadorExpressoesComissao() == null) {
            return new ComissaoItemPedido();
        }
        Double percMaximoComissao = 0.0;
        Double percMinimoComissao = 0.0;
        Double percComissao = 0.0;
        if (tabelaPromo != null) {
            percMaximoComissao = tabelaPromo.getPercMaximoComissao();
            percMinimoComissao = tabelaPromo.getPercMinimoComissao();
            percComissao = tabelaPromo.getPercComissao();
        }
        if (tabelaPromo == null || !TMethods.isWithData((Number)percComissao)) {
            percMaximoComissao = tbp.getPercMaximoComissao();
            percMinimoComissao = tbp.getPercMinimoComissao();
            percComissao = tbp.getPercComissaoPadrao();
        }
        this.helperCalcPrecosProduto.buildParametersAvaliacaoComissao(valorUnitario, valorMin, valorMax, percDesconto, percComissao, nrDiasMedios, tbp, values);
        DTOResultCalcExpressoes res = CompAvaliadorExpressoes.processAndValidateValue(aval.getAvaliadorExpressoesComissao(), values);
        if (res == null) {
            return new ComissaoItemPedido();
        }
        ComissaoItemPedido c = new ComissaoItemPedido();
        c.setAvaliadorExpFormulasCalComissao(CompAvaliadorExpressoes.getExp(aval.getAvaliadorExpressoesComissao(), res));
        c.setPercComissao(res.getResultado());
        c.setPercComissaoMax(percMaximoComissao);
        c.setPercComissaoMin(percMinimoComissao);
        return c;
    }
}

