/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecos;

import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFaturamentoOp;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstTipoTabelaPreco;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.ComissaoItemPedido;
import com.touchcomp.basementor.model.impl.ValoresPrecoItemPedido;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseGrupoProdutos;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.impl.calculos.HelperCalcPrecosProduto;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfaturamento.HelperOpcoesFaturamento;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobasegrupoprodutos.ServiceTabelaPrecoBaseGrupoProdutosImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseProdutoImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseprodutocomissao.ServiceTabelaPrecoBaseProdutoComissaoImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes.ServiceTabelaPrecoPromocoesImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCalcTabelaBaseImpl
extends ServiceGenericImpl {
    @Autowired
    HelperCalcPrecosProduto helperCalcPrecosProduto;
    @Autowired
    ServiceTabelaPrecoBaseImpl serviceTabelaBase;
    @Autowired
    ServiceTabelaPrecoPromocoesImpl serviceTabelaPrecoPromocoesImpl;
    @Autowired
    private ServiceTabelaPrecoBaseProdutoImpl serviceTabelaPrecoBaseProduto;
    @Autowired
    private ServiceTabelaPrecoBaseGrupoProdutosImpl serviceTabelaPrecoBaseGrupoProdutos;
    @Autowired
    private ServiceTabelaPrecoBaseProdutoComissaoImpl serviceTabelaPrecoBaseProdutoComissao;
    @Autowired
    private HelperCondicoesPagamento helperCondicoesPagamento;

    public ValoresPrecoItemPedido findPrecoProduto(OpcoesFaturamento op, UnidadeFatCliente unid, Representante rep, Produto produto, Date dataEmissao, Moeda moeda, CondicoesPagamento cp, String parcelas, TipoFrete tipoFrete, Empresa empresa) throws ExceptionCalcPrecosProduto {
        Double percComissao;
        ValoresPrecoItemPedido val = this.findValoresVendaProduto(op, unid, rep, produto, dataEmissao, moeda, empresa);
        this.calculaComissaoItemPed(val, cp, parcelas);
        this.helperCalcPrecosProduto.calcularValoresMajorados(val, cp, parcelas, op);
        this.helperCalcPrecosProduto.calculaValoresFrete(tipoFrete, val);
        if (this.isEquals(EnumConstTipoTabelaPreco.TABELA_BASE.getValue(), op.getTipoTabelaPreco()) && this.isAffimative(op.getPermitirMultiplasComissoes()) && (percComissao = this.calculaComissaoMultiplasBases(produto, dataEmissao, unid.getPessoa().getEndereco().getCidade().getUf(), moeda, op, val.getValorSugerido())) != null) {
            val.getComissao().setPercComissao(percComissao);
        }
        return val;
    }

    private void calculaComissaoItemPed(ValoresPrecoItemPedido val, CondicoesPagamento cp, String parcelas) {
        Double percComissao = this.helperCondicoesPagamento.calcularValorComissaoMinorado(cp, val.getComissao().getPercComissao(), parcelas);
        val.getComissao().setPercComissao(percComissao);
    }

    private Double calculaComissaoMultiplasBases(Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, OpcoesFaturamento op, Double valorUnitario) {
        return this.serviceTabelaPrecoBaseProdutoComissao.getPercComissaoMultiplasComissoesTabelaBase(produto, dataEmissao, uf, moeda, valorUnitario);
    }

    private ValoresPrecoItemPedido findValoresVendaProduto(OpcoesFaturamento op, UnidadeFatCliente unid, Representante rep, Produto produto, Date dataEmissao, Moeda moeda, Empresa empresa) throws ExceptionCalcPrecosProduto {
        EnumConstTipoTabelaPreco tipoTabelaPreco = EnumConstTipoTabelaPreco.get((Object)op.getTipoTabelaPreco());
        switch (tipoTabelaPreco) {
            case TABELA_BASE: {
                return this.findPrecoProdutoTabelaBase(op, unid, produto, dataEmissao, moeda);
            }
            case TABELA_BASE_GRUPO_PROD: {
                return this.findPrecoProdutoTabelaBaseGrupoProdutos(op, unid, produto, dataEmissao, moeda);
            }
            case SEM_TABELA_PRECO: {
                return new ValoresPrecoItemPedido(op.getTipoTabelaPreco());
            }
        }
        throw new ExceptionCalcPrecosProduto("01-02-00737", new Object[0]);
    }

    private ValoresPrecoItemPedido findPrecoProdutoTabelaBaseGrupoProdutos(OpcoesFaturamento op, UnidadeFatCliente unid, Produto produto, Date dataEmissao, Moeda moeda) throws ExceptionCalcPrecosProduto {
        UnidadeFederativa uf = this.getUf(unid);
        return this.findPrecosBaseGrupoProdutos(op, produto, dataEmissao, uf, moeda, op.getEmpresa());
    }

    private ValoresPrecoItemPedido findPrecosBaseGrupoProdutos(OpcoesFaturamento op, Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Empresa empresa) throws ExceptionCalcPrecosProduto {
        TabelaPrecoBase tabelaPrecoBase = this.serviceTabelaBase.getTabelaPrecoBasePrincipal(dataEmissao, uf, moeda, empresa);
        TabelaPrecoBaseProduto dadosPrecoProduto = this.serviceTabelaPrecoBaseProduto.getPrecosBasePrincipal(tabelaPrecoBase, produto, dataEmissao, uf, moeda, empresa);
        TabelaPrecoPromocoesProd tabelaPromo = this.serviceTabelaPrecoPromocoesImpl.getTabelaPrecosPromo(produto, dataEmissao, empresa);
        TabelaPrecoBaseGrupoProdutos dadosPrecoGrupoProd = null;
        if (dadosPrecoProduto == null && produto.getGrupoProdutos() != null) {
            dadosPrecoGrupoProd = this.serviceTabelaPrecoBaseGrupoProdutos.getPrecosBasePrincipal(produto, dataEmissao, uf, moeda, empresa);
        }
        if (dadosPrecoProduto == null && dadosPrecoGrupoProd == null) {
            throw new ExceptionCalcPrecosProduto("E.ERP.0177.002", new Object[]{produto});
        }
        Double valorMinimo = 0.0;
        Double valorMaximo = 0.0;
        Double valorVenda = 0.0;
        Double percComissao = 0.0;
        Double valorCusto = 0.0;
        Double valorDescontoPromo = 0.0;
        if (tabelaPromo != null) {
            valorMinimo = tabelaPromo.getValorMinimo();
            valorMaximo = tabelaPromo.getValorMaximo();
            percComissao = tabelaPromo.getPercComissao();
            valorCusto = tabelaPromo.getValorCusto();
            if (dadosPrecoProduto != null) {
                valorVenda = dadosPrecoProduto.getValorVenda();
                if (dadosPrecoProduto.getValorVenda() - valorVenda >= 0.0) {
                    valorDescontoPromo = dadosPrecoProduto.getValorVenda() - valorVenda;
                }
            } else if (dadosPrecoGrupoProd != null) {
                valorVenda = dadosPrecoGrupoProd.getValorVenda();
                if (dadosPrecoGrupoProd.getValorVenda() - valorVenda >= 0.0) {
                    valorDescontoPromo = dadosPrecoGrupoProd.getValorVenda() - valorVenda;
                }
            }
        } else if (dadosPrecoProduto != null) {
            valorMinimo = dadosPrecoProduto.getValorMinimo();
            valorMaximo = dadosPrecoProduto.getValorMaximo();
            valorVenda = dadosPrecoProduto.getValorVenda();
            percComissao = dadosPrecoProduto.getPercComissaoPadrao();
            valorCusto = dadosPrecoProduto.getValorCusto();
        } else if (dadosPrecoGrupoProd != null) {
            valorMinimo = dadosPrecoGrupoProd.getValorVenda() - dadosPrecoGrupoProd.getValorVenda() * dadosPrecoGrupoProd.getPercMinimo() / 100.0;
            valorMaximo = dadosPrecoGrupoProd.getValorVenda() + dadosPrecoGrupoProd.getValorVenda() * dadosPrecoGrupoProd.getPercMaximo() / 100.0;
            valorVenda = dadosPrecoGrupoProd.getValorVenda();
            percComissao = dadosPrecoGrupoProd.getPercComissaoPadrao();
            valorCusto = dadosPrecoGrupoProd.getValorCusto();
        }
        ValoresPrecoItemPedido val = new ValoresPrecoItemPedido(op.getTipoTabelaPreco());
        val.setValorSugerido(valorVenda);
        val.setValorMinimo(valorMinimo);
        val.setValorMaximo(valorMaximo);
        val.setValorCusto(valorCusto);
        val.setValorDescontoTabelaPromo(valorDescontoPromo);
        ComissaoItemPedido comissaoItemPedido = new ComissaoItemPedido();
        comissaoItemPedido.setPercComissaoMax(percComissao);
        val.setComissao(comissaoItemPedido);
        return val;
    }

    public ValoresPrecoItemPedido findPrecoProdutoTabelaBase(OpcoesFaturamento op, UnidadeFatCliente unid, Produto produto, Date dataEmissao, Moeda moeda) throws ExceptionCalcPrecosProduto {
        UnidadeFederativa uf = this.getUf(unid);
        return this.findPrecosBase(op, produto, dataEmissao, uf, moeda, op.getEmpresa());
    }

    public ValoresPrecoItemPedido findPrecoProdutoTabelaBase(OpcoesFaturamento op, Empresa emp, Produto produto, Date dataEmissao, Moeda moeda) throws ExceptionCalcPrecosProduto {
        UnidadeFederativa uf = emp.getPessoa().getEndereco().getCidade().getUf();
        return this.findPrecosBase(op, produto, dataEmissao, uf, moeda, op.getEmpresa());
    }

    private ValoresPrecoItemPedido findPrecosBase(OpcoesFaturamento op, Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Empresa empresa) throws ExceptionCalcPrecosProduto {
        TabelaPrecoBase tabelaPrecoBase = this.serviceTabelaBase.getTabelaPrecoBasePrincipal(dataEmissao, uf, moeda, empresa);
        TabelaPrecoBaseProduto dadosPrecoProduto = this.serviceTabelaPrecoBaseProduto.getPrecosBasePrincipal(tabelaPrecoBase, produto, dataEmissao, uf, moeda, empresa);
        if (dadosPrecoProduto == null) {
            throw new ExceptionCalcPrecosProduto("E.ERP.0177.002", new Object[]{produto});
        }
        HelperOpcoesFaturamento helper = (HelperOpcoesFaturamento)Context.get(HelperOpcoesFaturamento.class);
        TabelaPrecoPromocoesProd tabelaPromo = null;
        tabelaPromo = CompOpcoes.isAffirmative(helper.build(op).getItens(), (EnumOpDinamicasInterface)EnumConstOpFaturamentoOp.UTILIZAR_TABELA_PROMO_TABELA_BASE) ? this.serviceTabelaPrecoPromocoesImpl.getTabelaPrecosPromoBase(produto, dataEmissao, empresa, tabelaPrecoBase) : this.serviceTabelaPrecoPromocoesImpl.getTabelaPrecosPromo(produto, dataEmissao, empresa);
        Double valorMinimo = 0.0;
        Double valorMaximo = 0.0;
        Double valorSugerido = 0.0;
        Double valorCusto = 0.0;
        Double percComissao = 0.0;
        Double percComissaoMin = 0.0;
        Double percComissaoMax = 0.0;
        Double valorDescontoPromo = 0.0;
        if (tabelaPromo != null) {
            valorMinimo = tabelaPromo.getValorMinimo();
            valorMaximo = tabelaPromo.getValorMaximo();
            valorSugerido = dadosPrecoProduto.getValorVenda();
            valorCusto = tabelaPromo.getValorCusto();
            percComissao = tabelaPromo.getPercComissao();
            percComissaoMin = tabelaPromo.getPercMinimoComissao();
            percComissaoMax = tabelaPromo.getPercMaximoComissao();
            if (dadosPrecoProduto.getValorVenda() - tabelaPromo.getValorVenda() >= 0.0) {
                valorDescontoPromo = dadosPrecoProduto.getValorVenda() - tabelaPromo.getValorVenda();
            }
        }
        if (tabelaPromo == null || !TMethods.isWithData((Number)valorSugerido)) {
            valorMinimo = dadosPrecoProduto.getValorMinimo();
            valorMaximo = dadosPrecoProduto.getValorMaximo();
            valorSugerido = dadosPrecoProduto.getValorVenda();
            valorCusto = dadosPrecoProduto.getValorCusto();
            percComissao = dadosPrecoProduto.getPercComissaoPadrao();
            percComissaoMin = dadosPrecoProduto.getPercMinimoComissao();
            percComissaoMax = dadosPrecoProduto.getPercMaximoComissao();
        }
        ValoresPrecoItemPedido val = new ValoresPrecoItemPedido(op.getTipoTabelaPreco());
        val.setValorMinimo(valorMinimo);
        val.setValorMaximo(valorMaximo);
        val.setValorSugerido(valorSugerido);
        val.setValorCusto(valorCusto);
        val.setValorDescontoTabelaPromo(valorDescontoPromo);
        val.setTabelaDescontoPromoProd(tabelaPromo);
        ComissaoItemPedido c = new ComissaoItemPedido();
        c.setPercComissao(percComissao);
        c.setPercComissaoMin(percComissaoMin);
        c.setPercComissaoMax(percComissaoMax);
        val.setComissao(c);
        return val;
    }

    private UnidadeFederativa getUf(UnidadeFatCliente unid) {
        return unid != null ? unid.getPessoa().getEndereco().getCidade().getUf() : null;
    }

    Double getValorVendaTabBaseUsoInterno(Produto produto, Date data, Empresa empresa, Moeda moeda) {
        TabelaPrecoBaseProduto dadosPrecoProduto = this.serviceTabelaPrecoBaseProduto.getTabBaseUsoInterno(produto, data, moeda, empresa);
        if (dadosPrecoProduto == null) {
            return 0.0;
        }
        return dadosPrecoProduto.getValorVenda();
    }
}

