/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecos;

import com.touchcomp.basementor.model.impl.ComissaoItemPedido;
import com.touchcomp.basementor.model.impl.ValoresPrecoItemPedido;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorservice.helpers.impl.calculos.HelperCalcPrecosProduto;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecocodigocodigo.ServiceTabelaPrecoCodigoCodigoImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes.ServiceTabelaPrecoPromocoesImpl;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceCalcTabelaCodigoAuxImpl
extends ServiceGenericImpl {
    @Autowired
    HelperCalcPrecosProduto helperCalcPrecosProduto;
    @Autowired
    private ServiceTabelaPrecoCodigoCodigoImpl serviceTabelaPrecoCodigoCodigo;
    @Autowired
    private HelperCondicoesPagamento helperCondicoesPagamento;
    @Autowired
    private ServiceTabelaPrecoPromocoesImpl serviceTabelaPrecoPromocoesImpl;
    @Autowired
    private ServiceProdutoImpl serviceProduto;

    public ValoresPrecoItemPedido findPrecoProduto(OpcoesFaturamento op, UnidadeFatCliente unid, String codigoAux, Date dataEmissao, Moeda moeda, CondicoesPagamento cp, String parcelas, TipoFrete tipoFrete, Empresa empresa) throws ExceptionCalcPrecosProduto {
        ValoresPrecoItemPedido val = this.findPrecoProdutoTabelaCodigo(op, unid, codigoAux, dataEmissao, moeda, empresa);
        val.getComissao().setPercComissao(this.helperCondicoesPagamento.calcularValorComissaoMinorado(cp, val.getComissao().getPercComissao(), parcelas));
        this.helperCalcPrecosProduto.calcularValoresMajorados(val, cp, parcelas, op);
        this.helperCalcPrecosProduto.calculaValoresFrete(tipoFrete, val);
        return val;
    }

    private ValoresPrecoItemPedido findPrecoProdutoTabelaCodigo(OpcoesFaturamento op, UnidadeFatCliente unid, String codigoAux, Date dataEmissao, Moeda moeda, Empresa empresa) throws ExceptionCalcPrecosProduto {
        Double percComissao;
        UnidadeFederativa uf = this.getUf(unid);
        Object[] dadosPrecoProduto = this.serviceTabelaPrecoCodigoCodigo.getPrecosBasePrincipal(codigoAux, dataEmissao, uf, moeda);
        if (dadosPrecoProduto == null || dadosPrecoProduto.length == 0) {
            throw new ExceptionCalcPrecosProduto("E.ERP.0177.002", new Object[]{codigoAux});
        }
        TabelaPrecoPromocoesProd tabelaPromo = this.serviceTabelaPrecoPromocoesImpl.getTabelaPrecosPromo(this.serviceProduto.getByCodigoAuxiliar(codigoAux), new Date(), empresa);
        ValoresPrecoItemPedido val = new ValoresPrecoItemPedido(op.getTipoTabelaPreco());
        if (tabelaPromo != null) {
            Double valorDesconto;
            val.setValorSugerido(tabelaPromo.getValorVenda());
            val.setValorMaximo(tabelaPromo.getValorMaximo());
            val.setValorMinimo(tabelaPromo.getValorMinimo());
            val.setValorCusto(tabelaPromo.getValorCusto());
            percComissao = tabelaPromo.getPercComissao();
            if (dadosPrecoProduto[0] != null && (valorDesconto = Double.valueOf((Double)dadosPrecoProduto[0] - tabelaPromo.getValorVenda())) >= 0.0) {
                val.setValorDescontoTabelaPromo(valorDesconto);
            }
        } else {
            Double valorVenda = dadosPrecoProduto[0] != null ? (Double)dadosPrecoProduto[0] : 0.0;
            Double percMinimo = dadosPrecoProduto[1] != null ? (Double)dadosPrecoProduto[1] : 0.0;
            Double percMaximo = dadosPrecoProduto[2] != null ? (Double)dadosPrecoProduto[2] : 0.0;
            percComissao = dadosPrecoProduto[3] != null ? (Double)dadosPrecoProduto[3] : 0.0;
            Double valorCusto = dadosPrecoProduto[4] != null ? (Double)dadosPrecoProduto[5] : 0.0;
            val.setValorSugerido(valorVenda);
            val.setValorMaximo(Double.valueOf(valorVenda + valorVenda * (percMaximo / 100.0)));
            val.setValorMinimo(Double.valueOf(valorVenda - valorVenda * (percMinimo / 100.0)));
            val.setValorCusto(valorCusto);
        }
        ComissaoItemPedido comissaoItemPedido = new ComissaoItemPedido();
        comissaoItemPedido.setPercComissao(percComissao);
        val.setComissao(comissaoItemPedido);
        return val;
    }

    private UnidadeFederativa getUf(UnidadeFatCliente unid) {
        return unid != null ? unid.getPessoa().getEndereco().getCidade().getUf() : null;
    }
}

