/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecos;

import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstTipoTabelaPreco;
import com.touchcomp.basementor.model.impl.ComissaoItemPedido;
import com.touchcomp.basementor.model.impl.ValoresPrecoItemPedido;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaDescFinancProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProdQtd;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.moeda.ServiceMoedaImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorservice.service.impl.tabeladescfinanceiro.ServiceTabelaDescFinanceiroImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes.ServiceTabelaPrecoPromocoesImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecos.ServiceCalcTabPrecoDinamicaImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecos.ServiceCalcTabelaBaseImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecos.ServiceCalcTabelaCodigoAuxImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresa;
import com.touchcomp.basementorvalidator.dto.impl.calctabelaprecos.DTOCalcValoresTabelaPrecos;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceCalcTabelaPrecosImpl
extends ServiceGenericImpl {
    @Autowired
    HelperCondicoesPagamento helperCondicoesPagamento;
    @Autowired
    ServiceCalcTabelaBaseImpl serviceCalcTabelaBase;
    @Autowired
    ServiceCalcTabPrecoDinamicaImpl serviceCalcValoresTabPrecoDinamica;
    @Autowired
    ServiceTabelaDescFinanceiroImpl serviceTabelaDescFinanceiro;
    @Autowired
    ServiceCalcTabelaCodigoAuxImpl serviceCalcTabelaCodigoAux;
    @Autowired
    ServiceProdutoImpl serviceProdutoImpl;
    @Autowired
    ServiceCondicoesPagamentoImpl serviceCondicoesPagamentoImpl;
    @Autowired
    ServiceMoedaImpl serviceMoedaImpl;
    @Autowired
    ServiceTipoFreteImpl serviceTipoFreteImpl;
    @Autowired
    ServiceRepresentanteImpl serviceRepresentanteImpl;
    @Autowired
    ServiceUnidadeFatClienteImpl serviceUnidadeFatClienteImpl;
    @Autowired
    ServiceEmpresa serviceEmpresa;
    @Autowired
    ServiceNaturezaOperacaoImpl serviceNaturezaOperacaoImpl;
    @Autowired
    ServiceTabelaPrecoPromocoesImpl serviceTabelaPrecoPromocoesProd;

    public ValoresPrecoItemPedido calcularValores(OpcoesFaturamento op, UnidadeFatCliente unid, Representante rep, Produto produto, Date dataEmissao, Moeda moeda, CondicoesPagamento condicoesPagamento, String parcelas, TipoFrete tipoFrete, Empresa empresa, NaturezaOperacao natOP, Usuario usuario, String codAux) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto {
        ValoresPrecoItemPedido val = null;
        if (dataEmissao == null) {
            dataEmissao = new Date();
        }
        if (moeda == null) {
            moeda = op.getMoeda();
        }
        Integer nrDiasMedios = this.helperCondicoesPagamento.calcularNrDiasMedios(condicoesPagamento, parcelas);
        val = this.isEquals(op.getTipoTabelaPreco(), EnumConstTipoTabelaPreco.TABELA_PRECO_CODIGO.getValue()) ? this.serviceCalcTabelaCodigoAux.findPrecoProduto(op, unid, codAux, dataEmissao, moeda, condicoesPagamento, parcelas, tipoFrete, empresa) : (this.isEquals(op.getTipoTabelaPreco(), EnumConstTipoTabelaPreco.TABELA_PRECO_DINAMICA.getValue()) ? this.serviceCalcValoresTabPrecoDinamica.calcularValores(op, unid, rep, produto, moeda, condicoesPagamento, tipoFrete, empresa, nrDiasMedios, natOP, usuario) : this.serviceCalcTabelaBase.findPrecoProduto(op, unid, rep, produto, dataEmissao, moeda, condicoesPagamento, parcelas, tipoFrete, empresa));
        if (val != null) {
            this.aplicaTabelaDescFinProduto(val, unid, produto, dataEmissao, op);
            val.setTipoTabPreco(op.getTipoTabelaPreco());
        }
        this.arredondarValores(op, val);
        return val;
    }

    public TabelaPrecoPromocoesProdQtd getPromocaoPorQuantidadeProduto(Produto produto, Empresa empresa, Date dataEmissao, Double quantidade) {
        return this.serviceTabelaPrecoPromocoesProd.getTabelaPrecosPromo(produto, empresa, dataEmissao, quantidade);
    }

    public DTOCalcValoresTabelaPrecos calcularValoresDTO(OpcoesFaturamento op, Long idUnid, Long idRep, Long idProduto, Date dataEmissao, Long idMoeda, Long idCondicoesPagamento, String parcelas, Long idTipoFrete, Long idEmpresa, Long idNatOP, Usuario usuario, String codAux) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto, ExceptionObjNotFound {
        Empresa empresa = (Empresa)this.serviceEmpresa.get(idEmpresa);
        ValoresPrecoItemPedido valores = this.calcularValores(op, idUnid, idRep, idProduto, dataEmissao, idMoeda, idCondicoesPagamento, parcelas, idTipoFrete, empresa, idNatOP, usuario, codAux);
        return this.buildToDTOGeneric(valores, DTOCalcValoresTabelaPrecos.class);
    }

    public DTOCalcValoresTabelaPrecos calcularValoresDTO(OpcoesFaturamento op, Long idUnid, Long idRep, Long idProduto, Date dataEmissao, Long idMoeda, Long idCondicoesPagamento, String parcelas, Long idTipoFrete, Empresa empresa, Long idNatOP, Usuario usuario, String codAux) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto, ExceptionObjNotFound {
        ValoresPrecoItemPedido valores = this.calcularValores(op, idUnid, idRep, idProduto, dataEmissao, idMoeda, idCondicoesPagamento, parcelas, idTipoFrete, empresa, idNatOP, usuario, codAux);
        return this.buildToDTOGeneric(valores, DTOCalcValoresTabelaPrecos.class);
    }

    public ValoresPrecoItemPedido calcularValores(OpcoesFaturamento op, Long idUnid, Long idRep, Long idProduto, Date dataEmissao, Long idMoeda, Long idCondicoesPagamento, String parcelas, Long idTipoFrete, Empresa empresa, Long idNatOP, Usuario usuario, String codAux) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto, ExceptionObjNotFound {
        UnidadeFatCliente unid = (UnidadeFatCliente)this.serviceUnidadeFatClienteImpl.getOrThrow(idUnid);
        CondicoesPagamento condicoesPagamento = (CondicoesPagamento)this.serviceCondicoesPagamentoImpl.getOrThrow(idCondicoesPagamento);
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        Representante rep = (Representante)this.serviceRepresentanteImpl.get(idRep);
        Moeda moeda = (Moeda)this.serviceMoedaImpl.get(idMoeda);
        TipoFrete tipoFrete = (TipoFrete)this.serviceTipoFreteImpl.get(idTipoFrete);
        NaturezaOperacao natOP = (NaturezaOperacao)this.serviceNaturezaOperacaoImpl.get(idNatOP);
        if (rep == null) {
            rep = this.serviceRepresentanteImpl.findByUsuarioOrThrow(usuario);
        }
        if (moeda == null) {
            moeda = op.getMoeda();
        }
        if (tipoFrete == null) {
            tipoFrete = unid.getCliente().getFaturamento().getTipoFrete();
        }
        if (tipoFrete == null) {
            tipoFrete = op.getTipoFrete();
        }
        if (natOP == null) {
            natOP = op.getNatPrefFaturamento();
        }
        return this.calcularValores(op, unid, rep, produto, dataEmissao, moeda, condicoesPagamento, parcelas, tipoFrete, empresa, natOP, usuario, codAux);
    }

    private void aplicaTabelaDescFinProduto(ValoresPrecoItemPedido val, UnidadeFatCliente unid, Produto produto, Date dataEmissao, OpcoesFaturamento op) {
        ClassificacaoClientes classificacaoClientes;
        ClassificacaoClientes classificacaoClientes2 = classificacaoClientes = unid != null ? unid.getCliente().getClassificacaoClientes() : null;
        if (classificacaoClientes != null && produto != null) {
            TabelaDescFinancProduto tab = this.serviceTabelaDescFinanceiro.getTabelaDescontoItem(classificacaoClientes, produto, dataEmissao);
            val.setTabelaDescFinancProduto(tab);
            Double valorDesc = 0.0;
            if (tab != null) {
                valorDesc = tab.getValorDesc();
                valorDesc = valorDesc == null ? 0.0 : valorDesc;
            }
            val.setValorDescontoPromo(valorDesc);
            this.calcularValorComDesconto(val, op);
        }
    }

    private void calcularValorComDesconto(ValoresPrecoItemPedido val, OpcoesFaturamento op) {
        Double valorUnitario = val.getValorSugerido();
        Double valorMin = val.getValorMinimo();
        Double valorMax = val.getValorMaximo();
        Double valorDesc = val.getValorDescontoPromo();
        if (op.getUsarValorOriginalItemPedido() == null || !this.isAffimative(op.getUsarValorOriginalItemPedido())) {
            if (valorUnitario > 0.0) {
                Double newVlrVenda = valorUnitario - valorDesc;
                if (newVlrVenda < 0.0) {
                    newVlrVenda = 0.0;
                }
                val.setValorSugerido(newVlrVenda);
            }
            if (valorMax > 0.0) {
                Double newVlrMax = valorMax - valorDesc;
                if (newVlrMax < 0.0) {
                    newVlrMax = 0.0;
                }
                val.setValorMaximo(newVlrMax);
            }
            if (valorMin > 0.0) {
                Double newVlrMin = valorMin - valorDesc;
                if (newVlrMin < 0.0) {
                    newVlrMin = 0.0;
                }
                val.setValorMinimo(newVlrMin);
            }
        }
    }

    private void arredondarValores(OpcoesFaturamento op, ValoresPrecoItemPedido val) {
        if (this.isAffimative(op.getArredondarVlrItem()) && val != null) {
            Double valorVenda = this.arredondaNumero(val.getValorSugerido(), 2);
            Double valorMinimo = this.arredondaNumero(val.getValorMinimo(), 2);
            Double valorMaximo = this.arredondaNumero(val.getValorMaximo(), 2);
            Double percComissao = this.arredondaNumero(val.getComissao().getPercComissao(), 2);
            Double valorCusto = this.arredondaNumero(val.getValorCusto(), 2);
            val.setValorSugerido(valorVenda);
            val.setValorMinimo(valorMinimo);
            val.setValorMaximo(valorMaximo);
            val.setValorCusto(valorCusto);
            val.getComissao().setPercComissao(percComissao);
        }
    }

    public ComissaoItemPedido findComissao(OpcoesFaturamento op, UnidadeFatCliente unid, Representante rep, Produto produto, Date dataEmissao, Moeda moeda, CondicoesPagamento condicoesPagamento, String parcelas, TipoFrete tipoFrete, Empresa empresa, Double valorUnitario, Double valorMin, Double valorMax, Double percComissao, Double percDesconto, NaturezaOperacao natOP, Usuario usuario) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto {
        int nrDiasMedios = this.helperCondicoesPagamento.calcularNrDiasMedios(condicoesPagamento, parcelas);
        if (op.getTipoTabelaPreco().shortValue() == EnumConstTipoTabelaPreco.TABELA_PRECO_DINAMICA.getValue()) {
            return this.serviceCalcValoresTabPrecoDinamica.avaliaComissao(op, unid, rep, produto, dataEmissao, moeda, condicoesPagamento, parcelas, tipoFrete, empresa, valorUnitario, valorMin, valorMax, percComissao, percDesconto, nrDiasMedios, natOP, usuario);
        }
        ValoresPrecoItemPedido val = this.serviceCalcTabelaBase.findPrecoProduto(op, unid, rep, produto, dataEmissao, moeda, condicoesPagamento, parcelas, tipoFrete, empresa);
        if (val != null) {
            return val.getComissao();
        }
        return new ComissaoItemPedido(percComissao);
    }

    public Double getValorVendaTabBaseUsoInterno(Produto produto, Date data, Empresa empresa, Moeda moeda) {
        return this.serviceCalcTabelaBase.getValorVendaTabBaseUsoInterno(produto, data, empresa, moeda);
    }
}

