/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprecosdinamica;

import com.touchcomp.basementor.constants.enums.tabelaprecosdinamica.EnumTabelaPrecosDinamicaTipo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaPrecosDinamica;
import com.touchcomp.basementor.model.vo.TabelaPrecosDinamicaCond;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoTabelaPrecosDinamicaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTabelaPrecosDinamicalImpl
extends ServiceGenericEntityImpl<TabelaPrecosDinamica, Long, DaoTabelaPrecosDinamicaImpl> {
    @Autowired
    public ServiceTabelaPrecosDinamicalImpl(DaoTabelaPrecosDinamicaImpl genericDao) {
        super(genericDao);
    }

    public TabelaPrecosDinamicaCond getTabela(UnidadeFatCliente unidadeFatCliente, Empresa empresa, Representante representante, Produto produto, String opcaoPesquisa, boolean throwEx) {
        TabelaPrecosDinamicaCond aval = null;
        String[] partes = ToolString.splitString((String)opcaoPesquisa, (char[])new char[]{','});
        HashMap<EnumTabelaPrecosDinamicaTipo, Object> data = new HashMap<EnumTabelaPrecosDinamicaTipo, Object>();
        if (unidadeFatCliente != null) {
            data.put(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1, unidadeFatCliente.getCliente().getPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2, unidadeFatCliente.getCliente().getPessoa().getGrupoPessoas());
            data.put(EnumTabelaPrecosDinamicaTipo.CLASSIFICACAO_CLIENTE_5, unidadeFatCliente.getCliente().getClassificacaoClientes());
            data.put(EnumTabelaPrecosDinamicaTipo.CATEGORIA_CLIENTE_6, unidadeFatCliente.getCategoriaPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.REGIAO_TAB_PRECO_CLIENTE_7, unidadeFatCliente.getCliente().getFaturamento().getRegiaoTabPrecoDinamica());
        }
        if (representante != null) {
            data.put(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3, representante.getPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4, representante.getPessoa().getGrupoPessoas());
        }
        data.put(EnumTabelaPrecosDinamicaTipo.PRODUTO_8, produto);
        for (String parte : partes) {
            aval = ((DaoTabelaPrecosDinamicaImpl)this.getDao()).getTabela(data, empresa, parte);
            if (aval == null) continue;
            return aval;
        }
        if (throwEx) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1538.001", new Object[]{unidadeFatCliente, representante, produto, empresa}));
        }
        return null;
    }

    public List<TabelaPrecosDinamicaCond> getTabelas(UnidadeFatCliente unidadeFatCliente, Empresa empresa, Representante representante, Produto produto, String opcaoPesquisa, boolean throwEx) {
        String[] partes = ToolString.splitString((String)opcaoPesquisa, (char[])new char[]{','});
        HashMap<EnumTabelaPrecosDinamicaTipo, Object> data = new HashMap<EnumTabelaPrecosDinamicaTipo, Object>();
        if (unidadeFatCliente != null) {
            data.put(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1, unidadeFatCliente.getCliente().getPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2, unidadeFatCliente.getCliente().getPessoa().getGrupoPessoas());
            data.put(EnumTabelaPrecosDinamicaTipo.CLASSIFICACAO_CLIENTE_5, unidadeFatCliente.getCliente().getClassificacaoClientes());
            data.put(EnumTabelaPrecosDinamicaTipo.CATEGORIA_CLIENTE_6, unidadeFatCliente.getCategoriaPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.REGIAO_TAB_PRECO_CLIENTE_7, unidadeFatCliente.getCliente().getFaturamento().getRegiaoTabPrecoDinamica());
        }
        if (representante != null) {
            data.put(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3, representante.getPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4, representante.getPessoa().getGrupoPessoas());
        }
        data.put(EnumTabelaPrecosDinamicaTipo.PRODUTO_8, produto);
        for (String parte : partes) {
            List<TabelaPrecosDinamicaCond> aval = ((DaoTabelaPrecosDinamicaImpl)this.getDao()).getTabelas(data, empresa, parte);
            if (aval == null || aval.size() <= 0) continue;
            return aval;
        }
        if (throwEx) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1538.001", new Object[]{unidadeFatCliente, representante, produto, empresa}));
        }
        return null;
    }

    public List<TabelaPrecosDinamicaCond> getTabelasValidas(Empresa empresa, String parte) {
        return ((DaoTabelaPrecosDinamicaImpl)this.getDao()).getTabelasValidas(empresa, parte);
    }
}

