/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.tabelaprocessosesoc;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorservice.dao.impl.DaoTabelaProcessosEsocImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTabelaProcessosEsocImpl
extends ServiceGenericEntityImpl<TabelaProcessosEsoc, Long, DaoTabelaProcessosEsocImpl> {
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private HelperEsocPreEvento helper;

    @Autowired
    public ServiceTabelaProcessosEsocImpl(DaoTabelaProcessosEsocImpl genericDao) {
        super(genericDao);
    }

    @Override
    public TabelaProcessosEsoc beforeSave(TabelaProcessosEsoc vo) {
        if (!this.isNull(vo.getIdentificador()).booleanValue()) {
            vo.setPreEventosEsocial(this.serviceEsocPreEvento.getEventosTabelaProcessos(vo));
        }
        return vo;
    }

    public void buildEsocEventos(TabelaProcessosEsoc vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (!ServiceTabelaProcessosEsocImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            if (ServiceTabelaProcessosEsocImpl.isWithData(vo.getPreEventosEsocial())) {
                this.serviceEsocPreEvento.saveOrUpdate(vo.getPreEventosEsocial());
            }
        } else {
            boolean achou = false;
            for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
                if (!this.isEquals(esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa(), empresa.getEmpresaDados().getGrupoEmpresa())) continue;
                achou = true;
                break;
            }
            if (!achou) {
                vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
                vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
                if (ServiceTabelaProcessosEsocImpl.isWithData(vo.getPreEventosEsocial())) {
                    this.serviceEsocPreEvento.saveOrUpdate(vo.getPreEventosEsocial());
                }
            }
        }
    }
}

