/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.terminotrabalhadorsemvinculo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.ItemTerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.Rubricas2299;
import com.touchcomp.basementor.model.vo.SituacaoColaborador;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.eventocolaborador.CompEventoColaboradorBase;
import com.touchcomp.basementorservice.dao.impl.DaoTerminoTrabalhadorSemVinculoImpl;
import com.touchcomp.basementorservice.helpers.impl.terminotrabalhadorsemvinculo.HelperTerminoTrabalhadorSemVinculo;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.situacaocolaborador.ServiceSituacaoColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculoevento.ServiceTipoCalculoEventoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.colaborador.web.DTOColaboradorRes;
import com.touchcomp.touchvomodel.vo.itemterminotrabalhadorsemvinculo.web.DTOItemTerminoTrabalhadorSemVinculo;
import com.touchcomp.touchvomodel.vo.terminotrabalhadorsemvinculo.web.DTOTerminoTrabalhadorSemVinculo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTerminoTrabalhadorSemVinculoImpl
extends ServiceGenericEntityImpl<TerminoTrabalhadorSemVinculo, Long, DaoTerminoTrabalhadorSemVinculoImpl> {
    ServiceColaboradorImpl serviceColaboradorImpl;
    ServiceTipoCalculoEventoImpl serviceTipoCalculoEventoImpl;
    CompEventoColaboradorBase compEventoColaboradorBase;
    HelperTerminoTrabalhadorSemVinculo helperTerminoTrabalhadorSemVinculo;
    ServiceSituacaoColaboradorImpl serviceSituacaoColaboradorImpl;

    @Autowired
    public ServiceTerminoTrabalhadorSemVinculoImpl(DaoTerminoTrabalhadorSemVinculoImpl dao, ServiceColaboradorImpl serviceColaboradorImpl, ServiceTipoCalculoEventoImpl serviceTipoCalculoEventoImpl, CompEventoColaboradorBase compEventoColaboradorBase, HelperTerminoTrabalhadorSemVinculo helperTerminoTrabalhadorSemVinculo, ServiceSituacaoColaboradorImpl serviceSituacaoColaboradorImpl) {
        super(dao);
        this.serviceColaboradorImpl = serviceColaboradorImpl;
        this.serviceTipoCalculoEventoImpl = serviceTipoCalculoEventoImpl;
        this.compEventoColaboradorBase = compEventoColaboradorBase;
        this.helperTerminoTrabalhadorSemVinculo = helperTerminoTrabalhadorSemVinculo;
        this.serviceSituacaoColaboradorImpl = serviceSituacaoColaboradorImpl;
    }

    @Override
    public TerminoTrabalhadorSemVinculo beforeSaveEntity(TerminoTrabalhadorSemVinculo vo) {
        vo.getItensTerminoTsv().forEach(i -> i.setTerminoContrato(vo));
        if (this.isNotNull(vo.getItensTerminoTsv()).booleanValue()) {
            this.criarRubricas2299(vo);
        }
        vo.getColaborador().setDataDemissao(vo.getDataTermino());
        vo.getColaborador().setSituacaoColaborador((SituacaoColaborador)this.serviceSituacaoColaboradorImpl.get(3L));
        return vo;
    }

    private void criarRubricas2299(TerminoTrabalhadorSemVinculo vo) {
        ArrayList<Rubricas2299> rubricas = new ArrayList<Rubricas2299>();
        rubricas.addAll(vo.getItensTerminoTsv().stream().map(i -> {
            Rubricas2299 rubrica = new Rubricas2299(i.getEventoColaborador().getTipoCalculoEvento(), i.getReferencia(), i.getValor(), vo);
            return rubrica;
        }).collect(Collectors.toList()));
        EmpresaRh empresaRh = this.getSharedData().getEmpresaRh(vo.getEmpresa());
        if (vo.getValorInss() > 0.0) {
            Rubricas2299 rubricaValorInss = new Rubricas2299(empresaRh.getTpInss(), vo.getAliquotaInss(), vo.getValorInss(), vo);
            rubricas.add(rubricaValorInss);
        }
        if (vo.getBaseCalculoInss() > 0.0) {
            Rubricas2299 rubricaBaseInss = new Rubricas2299(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), vo.getBaseCalculoInss(), vo);
            rubricas.add(rubricaBaseInss);
        }
        if (vo.getValorInssDec() > 0.0) {
            Rubricas2299 rubricaValorInssDec = new Rubricas2299(empresaRh.getTpInssDec(), vo.getAliquotaInssDec(), vo.getValorInssDec(), vo);
            rubricas.add(rubricaValorInssDec);
        }
        if (vo.getBaseCalculoInssDec() > 0.0) {
            Rubricas2299 rubricaBaseInssDec = new Rubricas2299(empresaRh.getEventoBaseInssDec(), Double.valueOf(0.0), vo.getBaseCalculoInssDec(), vo);
            rubricas.add(rubricaBaseInssDec);
        }
        if (vo.getValorIrrf() > 0.0) {
            Rubricas2299 rubricaValorIrrf = new Rubricas2299(empresaRh.getTpIrrf(), vo.getAliquotaIrrf(), vo.getValorIrrf(), vo);
            rubricas.add(rubricaValorIrrf);
        }
        if (vo.getBaseCalculoIrrf() > 0.0) {
            Rubricas2299 rubricaBaseIrrf = new Rubricas2299(empresaRh.getEventoBaseIrrf(), Double.valueOf(0.0), vo.getBaseCalculoIrrf(), vo);
            rubricas.add(rubricaBaseIrrf);
        }
        if (vo.getValorIrrfDec() > 0.0) {
            Rubricas2299 rubricaValorIrrfDec = new Rubricas2299(empresaRh.getTpIrrfDec(), vo.getAliquotaIrrfDec(), vo.getValorIrrfDec(), vo);
            rubricas.add(rubricaValorIrrfDec);
        }
        if (vo.getBaseCalculoIrrfDec() > 0.0) {
            Rubricas2299 rubricaBaseIrrfDec = new Rubricas2299(empresaRh.getEventoBaseIrrfDec(), Double.valueOf(0.0), vo.getBaseCalculoIrrfDec(), vo);
            rubricas.add(rubricaBaseIrrfDec);
        }
        vo.setRubricas(rubricas);
    }

    @Override
    public TerminoTrabalhadorSemVinculo beforeDeleteEntity(TerminoTrabalhadorSemVinculo aux) {
        aux.getColaborador().setDataDemissao(null);
        aux.getColaborador().setSituacaoColaborador((SituacaoColaborador)this.serviceSituacaoColaboradorImpl.get(1L));
        return aux;
    }

    public DTOColaboradorRes buscarColaboradorSemVinculo(Long idColaborador, Empresa empresa) throws ExceptionObjNotFound {
        Colaborador colaborador = (Colaborador)this.serviceColaboradorImpl.getOrThrow(idColaborador);
        this.validColaborador(colaborador, empresa);
        return this.buildToDTOGeneric(colaborador, DTOColaboradorRes.class);
    }

    private void validColaborador(Colaborador colaborador, Empresa empresa) {
        if (this.isNotNull(colaborador.getDataDemissao()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.001", new String[]{colaborador.getPessoa().getNome()}));
        }
        if (!this.isEquals(colaborador.getAtivo(), EnumConstantsMentorSimNao.SIM.getEnumId())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.002", new String[]{colaborador.getPessoa().getNome()}));
        }
        Object[] tipoColaboradoresNecessarios = new Object[]{1L, 2L, 7L};
        if (!ToolMethods.containsInArray((Object[])tipoColaboradoresNecessarios, (Object)colaborador.getTipoColaborador().getIdentificador())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.003", new String[]{colaborador.getPessoa().getNome()}));
        }
        if (!this.isEquals(colaborador.getEmpresa(), empresa)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.004", new String[]{colaborador.getPessoa().getNome()}));
        }
    }

    public List<DTOItemTerminoTrabalhadorSemVinculo> buscarEventosTerminoContrato(Long[] ids, Long idColaborador, Long dataTermino) throws ExceptionObjNotFound {
        List listTipoCalculoEvento = this.serviceTipoCalculoEventoImpl.gets(ids);
        Colaborador colaborador = (Colaborador)this.serviceColaboradorImpl.getOrThrow(idColaborador);
        List itemTerminoTrabalhadorSemVinculo = listTipoCalculoEvento.stream().map(i -> {
            EventoColaborador evento = CompEventoColaboradorBase.criarEventoColaborador(i, colaborador, new Date(dataTermino), new Date(dataTermino));
            ItemTerminoTrabalhadorSemVinculo item = new ItemTerminoTrabalhadorSemVinculo();
            item.setEventoColaborador(evento);
            item.setInformarValor(EnumConstantsMentorSimNao.SIM.getEnumId());
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(itemTerminoTrabalhadorSemVinculo, DTOItemTerminoTrabalhadorSemVinculo.class);
    }

    public DTOTerminoTrabalhadorSemVinculo calcularTerminoContratoTsv(DTOTerminoTrabalhadorSemVinculo input, EmpresaRh empresaRh) {
        this.validCalcularTerminoContratoTsv(input);
        TerminoTrabalhadorSemVinculo dto = this.helperTerminoTrabalhadorSemVinculo.calcularImpostoTerminoContratoTsv((TerminoTrabalhadorSemVinculo)this.buildToEntity(input), empresaRh);
        return this.buildToDTOGeneric(dto, DTOTerminoTrabalhadorSemVinculo.class);
    }

    private void validCalcularTerminoContratoTsv(DTOTerminoTrabalhadorSemVinculo input) {
        if (!ServiceTerminoTrabalhadorSemVinculoImpl.isWithData(input.getItensTerminoTsv())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.005"));
        }
        if (this.isNull(input.getColaboradorIdentificador()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.006"));
        }
        if (this.isNull(input.getDataTermino()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.007"));
        }
        if (this.isNull(input.getDataPagamento()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.008"));
        }
    }

    public List<TerminoTrabalhadorSemVinculo> findTerminoTrabalhadorSemVinculoPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return ((DaoTerminoTrabalhadorSemVinculoImpl)this.getGenericDao()).findTerminoTrabalhadorSemVinculoPorDataPagamentoEmpresa(dataPagamento, empresa);
    }
}

