/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ticketatendtouch;

import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.LogAtualizacaoVersaoCli;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.TicketAtendTouch;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorservice.components.relpessoacontato.CompRelPessoaContato;
import com.touchcomp.basementorservice.dao.impl.DaoTicketAtendTouchImpl;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.arquivamentodoc.ServiceArquivamentoDocImpl;
import com.touchcomp.basementorservice.service.impl.clientecontsistemas.ServiceClienteContSistemasImpl;
import com.touchcomp.basementorservice.service.impl.logatualizacaoversaocli.ServiceLogAtualizacaoVersaoCliImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.relpessoacontato.ServiceRelPessoaContatoImpl;
import com.touchcomp.basementorservice.service.impl.usuarioclientecontsistemas.ServiceUsuarioClienteContSistemasImpl;
import com.touchcomp.basementorservice.service.impl.versaomentor.ServiceVersaoMentorImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceTicketAtendTouch;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ServiceTicketAtendTouchImpl
extends ServiceGenericEntityImpl<TicketAtendTouch, Long, DaoTicketAtendTouchImpl>
implements ServiceTicketAtendTouch {
    ServiceNodoImpl serviceNodoImpl;
    ServiceUsuarioClienteContSistemasImpl serviceUsuarioCli;
    ServiceClienteContSistemasImpl serviceCli;
    ServiceRelPessoaContatoImpl serviceRel;
    ServiceArquivamentoDocImpl serviceArquivamento;
    ServiceLogAtualizacaoVersaoCliImpl serviceLogAtualizacao;
    CompRelPessoaContato compRelPessoa;
    HelperPessoa helperPessoa;

    public ServiceTicketAtendTouchImpl(DaoTicketAtendTouchImpl genericDao, ServiceNodoImpl serviceNodoImpl, ServiceUsuarioClienteContSistemasImpl serviceUsuarioCli, ServiceClienteContSistemasImpl serviceCli, ServiceRelPessoaContatoImpl serviceRel, HelperPessoa helperPessoa, ServiceArquivamentoDocImpl serviceArquivamento, ServiceLogAtualizacaoVersaoCliImpl serviceLogAtualizacao, ServiceVersaoMentorImpl serviceVersao, CompRelPessoaContato compRelPessoa) {
        super(genericDao);
        this.serviceNodoImpl = serviceNodoImpl;
        this.serviceUsuarioCli = serviceUsuarioCli;
        this.serviceCli = serviceCli;
        this.serviceRel = serviceRel;
        this.helperPessoa = helperPessoa;
        this.serviceArquivamento = serviceArquivamento;
        this.serviceLogAtualizacao = serviceLogAtualizacao;
        this.compRelPessoa = compRelPessoa;
    }

    @Override
    public TicketAtendTouch getTicket(Long localID, UsuarioClienteContSistemas userCli) {
        return ((DaoTicketAtendTouchImpl)this.getGenericDao()).getTicket(localID, userCli);
    }

    @Override
    public List<Map<String, Object>> getTicketsSemAtend(UsuarioClienteContSistemas user) {
        return ((DaoTicketAtendTouchImpl)this.getGenericDao()).getTicket(user);
    }

    public TicketAtendTouch novoTicket(Long nodoIdentificador, String observacao, List<String> chavesArquivosAnexos, UsuarioBasico usuario, String codigoCliente) throws ExceptionBase {
        ClienteContSistemas cliente = this.serviceCli.getByCodigoClienteOrThrow(codigoCliente);
        UsuarioClienteContSistemas usu = this.serviceUsuarioCli.getByPessoaOrThrow(cliente, usuario.getPessoa());
        TicketAtendTouch t = new TicketAtendTouch();
        t.setDataCadastro(new Date());
        t.setEmail(this.helperPessoa.build(usu.getPessoa()).getEmailsAtivosStr());
        t.setObservacao(observacao);
        if (TMethods.isWithData((Number)nodoIdentificador)) {
            Nodo found = (Nodo)this.serviceNodoImpl.get(nodoIdentificador);
            t.setNodo(found);
        }
        t.setUsuario(usu);
        t.setNrProtocolo(this.serviceRel.findProximoNrProtocolo());
        LogAtualizacaoVersaoCli log = this.serviceLogAtualizacao.getUltimaAtualizacao(cliente);
        if (log != null) {
            t.setCodigoVersao(String.valueOf(log.getCodigoVersao()));
        }
        RelPessoaContato rel = this.compRelPessoa.getNewAtendimento(t);
        rel = this.serviceRel.saveOrUpdate(rel);
        String descricao = this.getMessage("M.ERP.0694.001", t.getNrProtocolo());
        ArquivamentoDoc arquiva = this.serviceArquivamento.saveUpdateArquivamentoitens(descricao, rel.getClass().getSimpleName(), rel.getIdentificador(), null, chavesArquivosAnexos);
        t.setArquivamentoDoc(arquiva);
        t = this.saveOrUpdate(t);
        rel.setTicketAtendTouch(t);
        t.setRelPessoaContato(rel);
        return t;
    }
}

