/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ticketfiscal;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObsTicketFiscal;
import com.touchcomp.basementor.model.vo.PedidoTicketFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.ticketfiscal.ServiceTicketFiscalImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTicketFiscalExportacaoImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceTicketFiscalImpl serviceTicketFiscalImpl;

    public Element exportarTicketFiscal(Empresa empresa, Date dataInicial, Date dataFinal, Short filtrarProduto, Produto produto) {
        List<TicketFiscal> listTicketFiscal = this.serviceTicketFiscalImpl.pesquisarTicketFiscalDataFechamentoProduto(empresa, dataInicial, dataFinal, filtrarProduto, produto);
        if (listTicketFiscal != null && !listTicketFiscal.isEmpty()) {
            Element touchCompErp = new Element("TOUCH_COMP_ERP");
            touchCompErp.addContent((Content)new Element("CNPJ").setText(empresa.getPessoa().getComplemento().getCnpj()));
            touchCompErp.addContent(this.criarXmlTicketFiscal(listTicketFiscal));
            return touchCompErp;
        }
        return null;
    }

    private List<Element> criarXmlTicketFiscal(List<TicketFiscal> listTicketFiscal) {
        ArrayList<Element> listElement = new ArrayList<Element>();
        for (TicketFiscal ticketFiscal : listTicketFiscal) {
            listElement.add(this.criarTicketFiscal(ticketFiscal));
        }
        return listElement;
    }

    private Element criarTicketFiscal(TicketFiscal ticketFiscal) {
        Element elementTicketFiscal = new Element("TICKET_FISCAL");
        elementTicketFiscal.addContent((Content)new Element("STATUS").setText(ticketFiscal.getStatus().toString()));
        elementTicketFiscal.addContent((Content)new Element("SERIE").setText(ticketFiscal.getSerie()));
        elementTicketFiscal.addContent((Content)new Element("NUMERO").setText(ticketFiscal.getNumero().toString()));
        elementTicketFiscal.addContent((Content)new Element("DATA_ABERTURA").setText(ToolDate.dateToStr((Date)ticketFiscal.getDataAbertura(), (String)"dd/MM/yyyy HH:mm:ss")));
        elementTicketFiscal.addContent((Content)new Element("DATA_FECHAMENTO").setText(ToolDate.dateToStr((Date)ticketFiscal.getDataFechamento(), (String)"dd/MM/yyyy HH:mm:ss")));
        elementTicketFiscal.addContent((Content)new Element("CNPJ_CLIENTE").setText(ticketFiscal.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj()));
        elementTicketFiscal.addContent(this.criarPedido(ticketFiscal));
        elementTicketFiscal.addContent((Content)new Element("PESO_VEICULO").setText(ticketFiscal.getPesoVeiculo().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_ESTIMADO").setText(ticketFiscal.getPesoEstimado().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_LIQUIDO_ESTIMADO").setText(ticketFiscal.getPesoLiquidoEstimado().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_TOTAL").setText(ticketFiscal.getPesoTotal().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_LIQUIDO_TOTAL").setText(ticketFiscal.getPesoLiquidoTotal().toString()));
        elementTicketFiscal.addContent((Content)new Element("INFORMAR_MANUAL_PESO").setText(ticketFiscal.getInfManualPeso().toString()));
        elementTicketFiscal.addContent((Content)new Element("MOTIVO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getMotivoManualPeso())));
        elementTicketFiscal.addContent((Content)this.criarTransportador(ticketFiscal));
        if (ticketFiscal.getMotorista() != null) {
            elementTicketFiscal.addContent((Content)this.criarMotorista(ticketFiscal));
        }
        elementTicketFiscal.addContent((Content)new Element("PLACA").setText(ticketFiscal.getPlaca()));
        elementTicketFiscal.addContent((Content)new Element("PLACA_CARRETA").setText(ticketFiscal.getPlacaCarreta()));
        elementTicketFiscal.addContent((Content)new Element("CODIGO_AUXILIAR_PRODUTO").setText(ticketFiscal.getProduto().getIdentificador().toString()));
        elementTicketFiscal.addContent((Content)new Element("GRADE_COR").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getGradeCor().getCor().getNome())));
        elementTicketFiscal.addContent((Content)new Element("LOTE_FABRICACAO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getLoteFabricacao().getLoteFabricacao())));
        elementTicketFiscal.addContent((Content)new Element("CENTRO_ESTOQUE").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getCentroEstoque().getDescricao())));
        elementTicketFiscal.addContent((Content)new Element("OBSERVACAO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getObservacoes())));
        elementTicketFiscal.addContent(this.criarObservacaoFaturamento(ticketFiscal));
        return elementTicketFiscal;
    }

    private List<Element> criarPedido(TicketFiscal ticketFiscal) {
        ArrayList<Element> listElement = new ArrayList<Element>();
        for (PedidoTicketFiscal pedidoTicketFiscal : ticketFiscal.getPedidoTicketFiscal()) {
            Element elementObservacaoFaturamento = new Element("PEDIDO");
            elementObservacaoFaturamento.addContent((Content)new Element("NUMERO_PEDIDO_CLIENTE").setText(pedidoTicketFiscal.getPedido().getNrPedidoCliente()));
            listElement.add(elementObservacaoFaturamento);
        }
        return listElement;
    }

    private Element criarTransportador(TicketFiscal ticketFiscal) {
        Element elementTransportador = new Element("TRANSPORTADOR");
        elementTransportador.addContent((Content)new Element("NOME").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getTransportador().getPessoa().getNome())));
        elementTransportador.addContent((Content)new Element("NOME_FANTASIA").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getTransportador().getPessoa().getNomeFantasia())));
        elementTransportador.addContent((Content)new Element("CONTATO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getTransportador().getPessoa().getPessoaContato())));
        elementTransportador.addContent((Content)new Element("CNPJ_CPF").setText(ticketFiscal.getTransportador().getPessoa().getComplemento().getCnpj()));
        elementTransportador.addContent((Content)new Element("TIPO_PESSOA_COMPLEMENTO").setText(ticketFiscal.getTransportador().getPessoa().getComplemento().getTipoPessoa().toString()));
        elementTransportador.addContent((Content)new Element("INSCRICAO_ESTADUAL").setText(ticketFiscal.getTransportador().getPessoa().getComplemento().getInscEst()));
        elementTransportador.addContent((Content)new Element("CONTRIBUINTE_ESTADO").setText(ticketFiscal.getTransportador().getPessoa().getComplemento().getContribuinteEstado().toString()));
        elementTransportador.addContent((Content)new Element("CEP").setText(ticketFiscal.getTransportador().getPessoa().getEndereco().getCep()));
        elementTransportador.addContent((Content)new Element("LOGRADOURO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getTransportador().getPessoa().getEndereco().getLogradouro())));
        elementTransportador.addContent((Content)new Element("NUMERO").setText(ticketFiscal.getTransportador().getPessoa().getEndereco().getNumero()));
        elementTransportador.addContent((Content)new Element("BAIRRO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getTransportador().getPessoa().getEndereco().getBairro())));
        elementTransportador.addContent((Content)new Element("CODIGO_IBGE").setText(ticketFiscal.getTransportador().getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        elementTransportador.addContent((Content)new Element("COMPLEMENTO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getTransportador().getPessoa().getEndereco().getComplemento())));
        return elementTransportador;
    }

    private Element criarMotorista(TicketFiscal ticketFiscal) {
        Element elementMotorista = new Element("MOTORISTA");
        elementMotorista.addContent((Content)new Element("NOME").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getMotorista().getPessoa().getNome())));
        elementMotorista.addContent((Content)new Element("NOME_FANTASIA").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getMotorista().getPessoa().getNomeFantasia())));
        elementMotorista.addContent((Content)new Element("CONTATO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getMotorista().getPessoa().getPessoaContato())));
        elementMotorista.addContent((Content)new Element("CNPJ_CPF").setText(ticketFiscal.getMotorista().getPessoa().getComplemento().getCnpj()));
        elementMotorista.addContent((Content)new Element("TIPO_PESSOA_COMPLEMENTO").setText(ticketFiscal.getMotorista().getPessoa().getComplemento().getTipoPessoa().toString()));
        elementMotorista.addContent((Content)new Element("INSCRICAO_ESTADUAL").setText(ticketFiscal.getMotorista().getPessoa().getComplemento().getInscEst()));
        elementMotorista.addContent((Content)new Element("CONTRIBUINTE_ESTADO").setText(ticketFiscal.getMotorista().getPessoa().getComplemento().getContribuinteEstado().toString()));
        elementMotorista.addContent((Content)new Element("CEP").setText(ticketFiscal.getMotorista().getPessoa().getEndereco().getCep()));
        elementMotorista.addContent((Content)new Element("LOGRADOURO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getMotorista().getPessoa().getEndereco().getLogradouro())));
        elementMotorista.addContent((Content)new Element("NUMERO").setText(ticketFiscal.getMotorista().getPessoa().getEndereco().getNumero()));
        elementMotorista.addContent((Content)new Element("BAIRRO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getMotorista().getPessoa().getEndereco().getBairro())));
        elementMotorista.addContent((Content)new Element("CODIGO_IBGE").setText(ticketFiscal.getMotorista().getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        elementMotorista.addContent((Content)new Element("COMPLEMENTO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscal.getMotorista().getPessoa().getEndereco().getComplemento())));
        elementMotorista.addContent((Content)new Element("TIPO_SANGUINEO").setText(ticketFiscal.getMotorista().getTipoSanguineo()));
        elementMotorista.addContent((Content)new Element("DATA_VENCIMENTO_ASO").setText(ToolDate.dateToStr((Date)ticketFiscal.getMotorista().getDataVencimentoASO(), (String)"dd/MM/yyyy HH:mm:ss")));
        elementMotorista.addContent((Content)new Element("MOTORISTA_PROPRIA").setText(ticketFiscal.getMotorista().getMotoristaProprio().toString()));
        elementMotorista.addContent((Content)new Element("NUMERO_CNH").setText(ticketFiscal.getMotorista().getNumeroCNH()));
        elementMotorista.addContent((Content)new Element("DATA_EMISSAO_CNH").setText(ToolDate.dateToStr((Date)ticketFiscal.getMotorista().getDataEmissaoCNH(), (String)"dd/MM/yyyy HH:mm:ss")));
        elementMotorista.addContent((Content)new Element("UNIDADE_FEDERATIVA_CNH").setText(ticketFiscal.getMotorista().getUnidadeFederativaCNH().getSigla()));
        elementMotorista.addContent((Content)new Element("NUMERO_REGISTRO").setText(ticketFiscal.getMotorista().getNumeroRegistroCNH()));
        elementMotorista.addContent((Content)new Element("DATA_VENCIMENTO_CNH").setText(ToolDate.dateToStr((Date)ticketFiscal.getMotorista().getDataVencimentoCNH(), (String)"dd/MM/yyyy HH:mm:ss")));
        elementMotorista.addContent((Content)new Element("CATEGORIA").setText(ticketFiscal.getMotorista().getCategoriaCNH()));
        return elementMotorista;
    }

    private List<Element> criarObservacaoFaturamento(TicketFiscal ticketFiscal) {
        ArrayList<Element> listElement = new ArrayList<Element>();
        for (ObsTicketFiscal obsTicketFiscal : ticketFiscal.getObsTicketFiscal()) {
            Element elementObservacaoFaturamento = new Element("OBSERVACAO_FATURAMENTO");
            elementObservacaoFaturamento.addContent((Content)new Element("CONTEUDO").setText(ToolString.clearSpecialCharacXML((String)obsTicketFiscal.getConteudo())));
            listElement.add(elementObservacaoFaturamento);
        }
        return listElement;
    }
}

