/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ticketfiscal;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.constants.enums.ticketfiscal.EnumConstTicketFiscalStatus;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.GradeItemTicketFiscal;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoObservacaoFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoTicketFiscal;
import com.touchcomp.basementor.model.vo.ObsTicketFiscal;
import com.touchcomp.basementor.model.vo.OpcoesTicketFiscal;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PedidoTicketFiscal;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.conjuntotransportador.ServiceConjuntoTransportadorImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.motorista.ServiceMotoristaImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacaoticketfiscal.ServiceNaturezaOperacaoTicketFiscalImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.ticketfiscal.ServiceTicketFiscalImpl;
import com.touchcomp.basementorservice.service.impl.transportador.ServiceTransportadorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTicketFiscalImportacaoImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceTicketFiscalImpl serviceTicketFiscalImpl;
    @Autowired
    ServiceNaturezaOperacaoTicketFiscalImpl serviceNaturezaOperacaoTicketFiscalImpl;
    @Autowired
    ServiceUnidadeFatClienteImpl serviceUnidadeFatClienteImpl;
    @Autowired
    ServicePedidoImpl servicePedidoImpl;
    @Autowired
    ServiceTransportadorImpl serviceTransportadorImpl;
    @Autowired
    ServiceMotoristaImpl serviceMotoristaImpl;
    @Autowired
    ServicePessoaImpl servicePessoaImpl;
    @Autowired
    ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl;
    @Autowired
    ServiceCidadeImpl serviceCidadeImpl;
    @Autowired
    ServiceProdutoImpl serviceProdutoImpl;
    @Autowired
    ServiceGradeCorImpl serviceGradeCorImpl;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    @Autowired
    ServiceCentroEstoqueImpl serviceCentroEstoqueImpl;
    @Autowired
    ServiceConjuntoTransportadorImpl serviceConjuntoTransportadorImpl;

    public List<TicketFiscal> importarTicketFiscal(Empresa empresa, File file, StringBuilder s, OpcoesTicketFiscal opcoesTicketFiscal, Short informarDadosProdGradeLoteCentroEst, Produto produto, GradeCor gradeCor, LoteFabricacao loteFabricacao, CentroEstoque centroEstoque) throws IOException, JDOMException, Exception {
        ArrayList<TicketFiscal> listTicketFiscal = new ArrayList<TicketFiscal>();
        Element e = this.converterArquivo(file);
        NaturezaOperacaoTicketFiscal naturezaOperacaoTicketFiscal = this.serviceNaturezaOperacaoTicketFiscalImpl.pesquisarNaturezaOperacaoTicketFiscalAtivo();
        this.validarDadosTicketFiscal(empresa, e, naturezaOperacaoTicketFiscal, opcoesTicketFiscal);
        for (Element elementTicketFiscal : e.getChildren("TICKET_FISCAL")) {
            this.buscarCamposTicketFiscal(empresa, naturezaOperacaoTicketFiscal, s, opcoesTicketFiscal, listTicketFiscal, elementTicketFiscal, informarDadosProdGradeLoteCentroEst, produto, gradeCor, loteFabricacao, centroEstoque);
        }
        return this.serviceTicketFiscalImpl.saveOrUpdate(listTicketFiscal);
    }

    private Element converterArquivo(File file) throws IOException, JDOMException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(file);
        return d.getRootElement();
    }

    private void validarDadosTicketFiscal(Empresa empresa, Element e, NaturezaOperacaoTicketFiscal naturezaOperacaoTicketFiscal, OpcoesTicketFiscal opcoesTicketFiscal) throws Exception {
        if (!ToolMethods.isEquals((Object)empresa.getPessoa().getComplemento().getCnpj(), (Object)e.getChildText("CNPJ"))) {
            throw new Exception("A empresa logada \u00e9 diferente do CNPJ " + e.getChildText("CNPJ") + " a ser importado!");
        }
        if (naturezaOperacaoTicketFiscal == null) {
            throw new Exception("N\u00e3o foi encontrado Natureza Opera\u00e7\u00e3o Ticket Fiscal Ativo cadastrado!");
        }
        if (ToolMethods.isEquals((Object)opcoesTicketFiscal.getImportarDadosProdutoXml(), (Object)EnumConstantsMentorSimNao.NAO.value) && naturezaOperacaoTicketFiscal.getCentroEstoque() == null) {
            throw new Exception("Informe Centro de Estoque no cadastro de Natureza Opera\u00e7\u00e3o Ticket Fiscal " + naturezaOperacaoTicketFiscal.toString() + "!");
        }
        if (naturezaOperacaoTicketFiscal.getNaturezaOperacaoObservacaoFiscal() == null || naturezaOperacaoTicketFiscal.getNaturezaOperacaoObservacaoFiscal().size() <= 0) {
            throw new Exception("Informe Observa\u00e7\u00e3o Fiscal no cadastro de Natureza Opera\u00e7\u00e3o Ticket Fiscal " + naturezaOperacaoTicketFiscal.toString() + "!");
        }
    }

    private void buscarCamposTicketFiscal(Empresa empresa, NaturezaOperacaoTicketFiscal naturezaOperacaoTicketFiscal, StringBuilder s, OpcoesTicketFiscal opcoesTicketFiscal, List<TicketFiscal> listTicketFiscal, Element elementTicketFiscal, Short informarDadosProdGradeLoteCentroEst, Produto produto, GradeCor gradeCor, LoteFabricacao loteFabricacao, CentroEstoque centroEstoque) {
        Short status = Short.valueOf(elementTicketFiscal.getChildText("STATUS"));
        String serie = elementTicketFiscal.getChildText("SERIE");
        Integer numero = Integer.valueOf(elementTicketFiscal.getChildText("NUMERO"));
        Date dataAbertura = ToolDate.strToDate((String)elementTicketFiscal.getChildText("DATA_ABERTURA"), (String)"dd/MM/yyyy HH:mm:ss");
        Date dataFechamento = ToolDate.strToDate((String)elementTicketFiscal.getChildText("DATA_FECHAMENTO"), (String)"dd/MM/yyyy HH:mm:ss");
        String cnpjCliente = elementTicketFiscal.getChildText("CNPJ_CLIENTE");
        List listElementPedido = elementTicketFiscal.getChildren("PEDIDO");
        Double pesoVeiculo = Double.valueOf(elementTicketFiscal.getChildText("PESO_VEICULO"));
        Double pesoEstimado = Double.valueOf(elementTicketFiscal.getChildText("PESO_ESTIMADO"));
        Double pesoLiquidoEstimado = Double.valueOf(elementTicketFiscal.getChildText("PESO_LIQUIDO_ESTIMADO"));
        Double pesoTotal = Double.valueOf(elementTicketFiscal.getChildText("PESO_TOTAL"));
        Double pesoLiquidoTotal = Double.valueOf(elementTicketFiscal.getChildText("PESO_LIQUIDO_TOTAL"));
        Short informarManualPeso = Short.valueOf(elementTicketFiscal.getChildText("INFORMAR_MANUAL_PESO"));
        String motivo = elementTicketFiscal.getChildText("MOTIVO");
        Element elementTransportador = elementTicketFiscal.getChild("TRANSPORTADOR");
        Element elementMotorista = elementTicketFiscal.getChild("MOTORISTA");
        String placa = elementTicketFiscal.getChildText("PLACA");
        String placaCarreta = elementTicketFiscal.getChildText("PLACA_CARRETA");
        String codigoAuxiliarProduto = elementTicketFiscal.getChildText("CODIGO_AUXILIAR_PRODUTO");
        String nomeGradeCor = elementTicketFiscal.getChildText("GRADE_COR");
        String nomeLoteFabricacao = elementTicketFiscal.getChildText("LOTE_FABRICACAO");
        String nomeCentroEstoque = elementTicketFiscal.getChildText("CENTRO_ESTOQUE");
        String observacao = elementTicketFiscal.getChildText("OBSERVACAO");
        List listElementObsTicketFiscal = elementTicketFiscal.getChildren("OBSERVACAO_FATURAMENTO");
        if (this.validarExisteTicketFiscal(empresa, serie, numero, s, opcoesTicketFiscal)) {
            this.criarTicketFiscal(empresa, naturezaOperacaoTicketFiscal, s, opcoesTicketFiscal, listTicketFiscal, status, serie, numero, dataAbertura, dataFechamento, cnpjCliente, listElementPedido, pesoVeiculo, pesoEstimado, pesoLiquidoEstimado, pesoTotal, pesoLiquidoTotal, informarManualPeso, motivo, elementTransportador, elementMotorista, placa, placaCarreta, codigoAuxiliarProduto, nomeGradeCor, nomeLoteFabricacao, nomeCentroEstoque, observacao, listElementObsTicketFiscal, informarDadosProdGradeLoteCentroEst, produto, gradeCor, loteFabricacao, centroEstoque);
        }
    }

    private boolean validarExisteTicketFiscal(Empresa empresa, String serie, Integer numero, StringBuilder s, OpcoesTicketFiscal opcoesTicketFiscal) {
        if (ToolMethods.isEquals((Object)opcoesTicketFiscal.getImportarNumeroXml(), (Object)EnumConstantsMentorSimNao.SIM.value)) {
            TicketFiscal t = this.serviceTicketFiscalImpl.pesquisarTicketFiscalEmpresaSerieNumero(empresa, serie, numero);
            if (t != null) {
                s.append("Ticket Fiscal com S\u00e9rie: ").append(serie).append(" N\u00famero: ").append(numero).append(" j\u00e1 importado!\n");
                return false;
            }
        } else {
            TicketFiscal t = this.serviceTicketFiscalImpl.pesquisarTicketFiscalEmpresaSerieImportadoNumeroImportado(empresa, serie, numero);
            if (t != null) {
                s.append("Ticket Fiscal com S\u00e9rie Importado: ").append(serie).append(" N\u00famero Importado: ").append(numero).append(" j\u00e1 importado!\n");
                return false;
            }
        }
        return true;
    }

    private void criarTicketFiscal(Empresa empresa, NaturezaOperacaoTicketFiscal naturezaOperacaoTicketFiscal, StringBuilder s, OpcoesTicketFiscal opcoesTicketFiscal, List<TicketFiscal> listTicketFiscal, Short status, String serie, Integer numero, Date dataAbertura, Date dataFechamento, String cnpjCliente, List<Element> listElementPedido, Double pesoVeiculo, Double pesoEstimado, Double pesoLiquidoEstimado, Double pesoTotal, Double pesoLiquidoTotal, Short informarManualPeso, String motivo, Element elementTransportador, Element elementMotorista, String placa, String placaCarreta, String codigoAuxiliarProduto, String nomeGradeCor, String nomeLoteFabricacao, String nomeCentroEstoque, String observacao, List<Element> listElementObsTicketFiscal, Short informarDadosProdGradeLoteCentroEst, Produto produto, GradeCor gradeCor, LoteFabricacao loteFabricacao, CentroEstoque centroEstoque) {
        TicketFiscal t = new TicketFiscal();
        t.setEmpresa(empresa);
        t.setDataCadastro(new Date());
        if (ToolMethods.isEquals((Object)opcoesTicketFiscal.getImportarStatusAbertoXml(), (Object)EnumConstantsMentorSimNao.SIM.value)) {
            t.setStatus(Short.valueOf(EnumConstTicketFiscalStatus.ABERTO.value));
        } else {
            t.setStatus(status);
        }
        t.setNaturezaOperacaoTicketFiscal(naturezaOperacaoTicketFiscal);
        t.setSerie(naturezaOperacaoTicketFiscal.getSerie());
        if (ToolMethods.isEquals((Object)opcoesTicketFiscal.getImportarNumeroXml(), (Object)EnumConstantsMentorSimNao.SIM.value)) {
            t.setSerie(serie);
            t.setNumero(numero);
            t.setNumeroInformado(numero);
        }
        t.setSerieImportado(serie);
        t.setNumeroImportado(numero);
        t.setDataAbertura(dataAbertura);
        t.setDataFechamento(dataFechamento);
        t.setUnidadeFatCliente(this.serviceUnidadeFatClienteImpl.findUnidadeFatByCpfCnpj(cnpjCliente));
        if (t.getUnidadeFatCliente() == null) {
            s.append("N\u00e3o foi encontrado Cliente cadastrado com o CNPJ ").append(cnpjCliente).append("!\n");
            return;
        }
        t.setPesoVeiculo(pesoVeiculo);
        t.setPesoEstimado(pesoEstimado);
        t.setPesoLiquidoEstimado(pesoLiquidoEstimado);
        t.setPesoTotal(pesoTotal);
        t.setPesoLiquidoTotal(pesoLiquidoTotal);
        t.setInfManualPeso(informarManualPeso);
        t.setMotivoManualPeso(motivo);
        t.setTransportador(this.pesquisarCriarTransportador(empresa, elementTransportador));
        if (elementMotorista != null) {
            t.setMotorista(this.pesquisarCriarMotorista(empresa, elementMotorista));
        }
        t.setPlaca(placa);
        t.setPlacaCarreta(placaCarreta);
        if (!ToolMethods.isStrWithData((String)placaCarreta)) {
            t.setPlacaCarreta(placa);
        }
        if (ToolMethods.isEquals((Object)informarDadosProdGradeLoteCentroEst, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            t.setProduto(produto);
            t.setGradeCor(gradeCor);
            t.setLoteFabricacao(loteFabricacao);
            t.setCentroEstoque(centroEstoque);
        } else if (ToolMethods.isEquals((Object)opcoesTicketFiscal.getImportarDadosProdutoXml(), (Object)EnumConstantsMentorSimNao.SIM.value)) {
            t.setProduto(this.serviceProdutoImpl.getByCodigoAuxiliar(codigoAuxiliarProduto));
            if (t.getProduto() == null) {
                s.append("N\u00e3o foi encontrado Produto cadastrado com o C\u00f3digo Auxiliar ").append(codigoAuxiliarProduto).append("!\n");
                return;
            }
            t.setGradeCor(this.serviceGradeCorImpl.getGradeCorProdutoNome(t.getProduto(), nomeGradeCor));
            if (t.getGradeCor() == null) {
                s.append("N\u00e3o foi encontrado Grade Cor cadastrado com o Nome ").append(nomeGradeCor).append(" para o Produto ").append(t.getProduto().getNome()).append("!\n");
                return;
            }
            t.setLoteFabricacao(this.serviceLoteFabricacaoImpl.findLoteFabricacao(t.getProduto(), nomeLoteFabricacao));
            if (t.getLoteFabricacao() == null) {
                s.append("N\u00e3o foi encontrado Lote Fabrica\u00e7\u00e3o cadastrado com o Nome ").append(nomeLoteFabricacao).append(" para o Produto ").append(t.getProduto().getNome()).append("!\n");
                return;
            }
            t.setCentroEstoque(this.serviceCentroEstoqueImpl.getCentroEstoqueNome(nomeCentroEstoque));
            if (t.getCentroEstoque() == null) {
                s.append("N\u00e3o foi encontrado Centro Estoque cadastrado com o Nome ").append(nomeCentroEstoque).append("!\n");
                return;
            }
        } else {
            t.setProduto(this.serviceProdutoImpl.getByCodigoAuxiliar(codigoAuxiliarProduto));
            if (t.getProduto() == null) {
                s.append("N\u00e3o foi encontrado Produto cadastrado com o C\u00f3digo Auxiliar ").append(codigoAuxiliarProduto).append("!\n");
                return;
            }
            t.setGradeCor((GradeCor)((ProdutoGrade)t.getProduto().getGradesProduto().get(0)).getGradesCores().get(0));
            if (t.getGradeCor() == null) {
                s.append("N\u00e3o foi encontrado Grade Cor cadastrado para o Produto ").append(t.getProduto().getIdentificador()).append(" - ").append(t.getProduto().getNome()).append("!\n");
                return;
            }
            if (ToolMethods.isEquals((Object)t.getProduto().getLoteUnico(), (Object)EnumConstantsMentorSimNao.SIM.value)) {
                t.setLoteFabricacao(this.serviceLoteFabricacaoImpl.findLoteUnico(t.getProduto()));
            } else {
                t.setLoteFabricacao(this.serviceLoteFabricacaoImpl.findLoteFabricacaoProduto(t.getProduto()).get(0));
            }
            if (t.getLoteFabricacao() == null) {
                s.append("N\u00e3o foi encontrado Lote de Fabrica\u00e7\u00e3o cadastrado para o Produto ").append(t.getProduto().getIdentificador()).append(" - ").append(t.getProduto().getNome()).append("!\n");
                return;
            }
            t.setCentroEstoque(naturezaOperacaoTicketFiscal.getCentroEstoque());
        }
        if (ToolMethods.isEquals((Object)opcoesTicketFiscal.getInformarPedido(), (Object)EnumConstantsMentorSimNao.SIM.value)) {
            t.setPedidoTicketFiscal(this.criarPedidoTicketFiscal(s, t, listElementPedido));
            if (ToolMethods.isEquals((Object)t.getPedidoTicketFiscal(), null) || t.getPedidoTicketFiscal().isEmpty()) {
                return;
            }
        }
        t.setGradeItemTicketFiscal(this.criarGradeItemTicketFiscal(t));
        t.setObsTicketFiscal(this.criarObsTicketFiscal(t, listElementObsTicketFiscal));
        t.setObservacoes(observacao);
        t.setInfManualPeso(Short.valueOf(EnumConstantsMentorSimNao.NAO.value));
        t.setConjuntoTransportador(this.serviceConjuntoTransportadorImpl.getConjuntoTranspPorPlaca(t.getDataAbertura(), ToolString.refina((String)t.getPlaca().toUpperCase())));
        listTicketFiscal.add(t);
    }

    private Transportador pesquisarCriarTransportador(Empresa empresa, Element elementTransportador) {
        String nome = elementTransportador.getChildText("NOME");
        String nomeFantasia = elementTransportador.getChildText("NOME_FANTASIA");
        String contato = elementTransportador.getChildText("CONTATO");
        String cnpjCpf = elementTransportador.getChildText("CNPJ_CPF");
        Short tipoPessoaComplemento = Short.valueOf(elementTransportador.getChildText("TIPO_PESSOA_COMPLEMENTO"));
        String inscricaoEstadual = elementTransportador.getChildText("INSCRICAO_ESTADUAL");
        Short contribuinteEstado = Short.valueOf(elementTransportador.getChildText("CONTRIBUINTE_ESTADO"));
        String cep = elementTransportador.getChildText("CEP");
        String logradouro = elementTransportador.getChildText("LOGRADOURO");
        String numero = elementTransportador.getChildText("NUMERO");
        String bairro = elementTransportador.getChildText("BAIRRO");
        String codigoIbge = elementTransportador.getChildText("CODIGO_IBGE");
        String complemento = elementTransportador.getChildText("COMPLEMENTO");
        return this.criarTransportador(empresa, nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento);
    }

    private Transportador criarTransportador(Empresa empresa, String nome, String nomeFantasia, String contato, String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado, String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento) {
        Transportador transportador = this.serviceTransportadorImpl.findByCNPJAtivo(cnpjCpf);
        if (transportador == null) {
            transportador = new Transportador();
            transportador.setPessoa(this.criarPessoa(nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento));
            transportador.setEmpresa(empresa);
            transportador.setDataCadastro(new Date());
        }
        return this.serviceTransportadorImpl.saveOrUpdate(transportador);
    }

    private Motorista pesquisarCriarMotorista(Empresa empresa, Element elementMotorista) {
        String nome = elementMotorista.getChildText("NOME");
        String nomeFantasia = elementMotorista.getChildText("NOME_FANTASIA");
        String contato = elementMotorista.getChildText("CONTATO");
        String cnpjCpf = elementMotorista.getChildText("CNPJ_CPF");
        Short tipoPessoaComplemento = Short.valueOf(elementMotorista.getChildText("TIPO_PESSOA_COMPLEMENTO"));
        String inscricaoEstadual = elementMotorista.getChildText("INSCRICAO_ESTADUAL");
        Short contribuinteEstado = Short.valueOf(elementMotorista.getChildText("CONTRIBUINTE_ESTADO"));
        String cep = elementMotorista.getChildText("CEP");
        String logradouro = elementMotorista.getChildText("LOGRADOURO");
        String numero = elementMotorista.getChildText("NUMERO");
        String bairro = elementMotorista.getChildText("BAIRRO");
        String codigoIbge = elementMotorista.getChildText("CODIGO_IBGE");
        String complemento = elementMotorista.getChildText("COMPLEMENTO");
        String tipoSanguineo = elementMotorista.getChildText("TIPO_SANGUINEO");
        Date dataVencimentoAso = elementMotorista.getChildText("DATA_VENCIMENTO_ASO") != null && elementMotorista.getChildText("DATA_VENCIMENTO_ASO").length() > 0 ? ToolDate.strToDate((String)elementMotorista.getChildText("DATA_VENCIMENTO_ASO"), (String)"dd/MM/yyyy HH:mm:ss") : null;
        Short motoristaPropria = Short.valueOf(elementMotorista.getChildText("MOTORISTA_PROPRIA"));
        String numeroCnh = elementMotorista.getChildText("NUMERO_CNH");
        Date dataEmissaoCnh = ToolDate.strToDate((String)elementMotorista.getChildText("DATA_EMISSAO_CNH"), (String)"dd/MM/yyyy HH:mm:ss");
        String unidadeFederativaCnh = elementMotorista.getChildText("UNIDADE_FEDERATIVA_CNH");
        String numeroRegistro = elementMotorista.getChildText("NUMERO_REGISTRO");
        Date dataVencimentoCnh = ToolDate.strToDate((String)elementMotorista.getChildText("DATA_VENCIMENTO_CNH"), (String)"dd/MM/yyyy HH:mm:ss");
        String categoria = elementMotorista.getChildText("CATEGORIA");
        return this.criarMotorista(empresa, nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento, tipoSanguineo, dataVencimentoAso, motoristaPropria, numeroCnh, dataEmissaoCnh, unidadeFederativaCnh, numeroRegistro, dataVencimentoCnh, categoria);
    }

    private Motorista criarMotorista(Empresa empresa, String nome, String nomeFantasia, String contato, String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado, String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento, String tipoSanguineo, Date dataVencimentoAso, Short motoristaPropria, String numeroCnh, Date dataEmissaoCnh, String unidadeFederativaCnh, String numeroRegistro, Date dataVencimentoCnh, String categoria) {
        Motorista motorista = this.serviceMotoristaImpl.findByCNPJAtivo(cnpjCpf);
        if (motorista == null) {
            motorista = new Motorista();
            motorista.setPessoa(this.criarPessoa(nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento));
            motorista.setTipoSanguineo(tipoSanguineo);
            motorista.setNumeroCNH(numeroCnh);
            motorista.setDataEmissaoCNH(dataEmissaoCnh);
            motorista.setNumeroRegistroCNH(numeroRegistro);
            motorista.setDataVencimentoCNH(dataVencimentoCnh);
            motorista.setCategoriaCNH(categoria);
            motorista.setEmpresa(empresa);
            motorista.setDataCadastro(new Date());
            motorista.setMotoristaProprio(motoristaPropria);
            motorista.setUnidadeFederativaCNH(this.serviceUnidadeFederativaImpl.getBySigla(unidadeFederativaCnh));
            motorista.setDataVencimentoASO(dataVencimentoAso);
        }
        return this.serviceMotoristaImpl.saveOrUpdate(motorista);
    }

    private Pessoa criarPessoa(String nome, String nomeFantasia, String contato, String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado, String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento) {
        Pessoa pessoa = this.servicePessoaImpl.getByCPFCNPJ(cnpjCpf);
        if (pessoa == null) {
            pessoa = new Pessoa();
            pessoa.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.value));
            pessoa.setNome(nome);
            pessoa.setNomeFantasia(nomeFantasia);
            pessoa.setPessoaContato(contato);
            pessoa.setEndereco(this.criarEnderecoPessoa(cep, logradouro, numero, bairro, codigoIbge, complemento));
            pessoa.setComplemento(this.criarComplementoPessoa(cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado));
            pessoa.setDataCadastro(new Date());
            pessoa.setDataInicioRelacionamento(new Date());
            pessoa.setTipoPessoa(Short.valueOf(EnumConstTipoPessoa.PESSOA_PRIMARIA.value));
        }
        return this.servicePessoaImpl.saveOrUpdate(pessoa);
    }

    private Endereco criarEnderecoPessoa(String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento) {
        Endereco endereco = new Endereco();
        endereco.setLogradouro(logradouro);
        endereco.setCep(cep);
        endereco.setBairro(bairro);
        endereco.setNumero(numero);
        endereco.setComplemento(complemento);
        endereco.setCidade(this.serviceCidadeImpl.getByCodigoIBGECompleto(codigoIbge));
        return endereco;
    }

    private Complemento criarComplementoPessoa(String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado) {
        Complemento complemento = new Complemento();
        complemento.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.value));
        complemento.setCnpj(cnpjCpf);
        complemento.setTipoPessoa(tipoPessoaComplemento);
        complemento.setInscEst(inscricaoEstadual);
        complemento.setContribuinteEstado(contribuinteEstado);
        return complemento;
    }

    private List<PedidoTicketFiscal> criarPedidoTicketFiscal(StringBuilder s, TicketFiscal t, List<Element> listElementPedido) {
        List<Object> listPedidoTicketFiscal = new ArrayList();
        for (Element element : listElementPedido) {
            Pedido pedido = this.servicePedidoImpl.getPedidoEmpresaNumeroPedidoCliente(t.getEmpresa(), t.getUnidadeFatCliente(), element.getChildText("NUMERO_PEDIDO_CLIENTE"));
            if (pedido == null) {
                s.append("N\u00e3o foi encontrado Pedido cadastrado com o N\u00famero Pedido Cliente ").append(element.getChildText("NUMERO_PEDIDO_CLIENTE")).append("!\n");
                break;
            }
            for (ItemPedido itemPedido : pedido.getItemPedido()) {
                for (GradeItemPedido gradeItemPedido : itemPedido.getGradeItemPedido()) {
                    if (!ToolMethods.isEquals((Object)gradeItemPedido.getGradeCor(), (Object)t.getGradeCor())) continue;
                    PedidoTicketFiscal p = new PedidoTicketFiscal();
                    p.setTicketFiscal(t);
                    p.setPedido(pedido);
                    p.setGradeItemPedido(gradeItemPedido);
                    Double qtdeTicket = this.serviceTicketFiscalImpl.pesquisarTicketFiscalSaldoPorPedidoAndGrade(p.getPedido(), p.getGradeItemPedido());
                    if (!(qtdeTicket < gradeItemPedido.getQuantidade())) continue;
                    p.setSaldo(Double.valueOf(gradeItemPedido.getQuantidade() - qtdeTicket));
                    listPedidoTicketFiscal.add(p);
                }
            }
        }
        listPedidoTicketFiscal = this.ordenacaoPedido(listPedidoTicketFiscal);
        Double pesoLiquidoTotal = t.getPesoLiquidoTotal();
        for (PedidoTicketFiscal pedidoTicketFiscal : listPedidoTicketFiscal) {
            if (!pedidoTicketFiscal.getGradeItemPedido().getGradeCor().equals((Object)t.getGradeCor())) continue;
            if (pesoLiquidoTotal > pedidoTicketFiscal.getSaldo()) {
                pedidoTicketFiscal.setQuantidade(pedidoTicketFiscal.getSaldo());
                pesoLiquidoTotal = pesoLiquidoTotal - pedidoTicketFiscal.getSaldo();
                continue;
            }
            pedidoTicketFiscal.setQuantidade(pesoLiquidoTotal);
            break;
        }
        ArrayList<PedidoTicketFiscal> arrayList = new ArrayList<PedidoTicketFiscal>();
        for (PedidoTicketFiscal pedidoTicketFiscal : listPedidoTicketFiscal) {
            if ((!ToolMethods.isEquals((Object)pedidoTicketFiscal.getGradeItemPedido().getGradeCor(), (Object)t.getGradeCor()) || !ToolMethods.isEquals((Object)t.getStatus(), (Object)EnumConstTicketFiscalStatus.ABERTO.value)) && !(pedidoTicketFiscal.getQuantidade() > 0.0)) continue;
            arrayList.add(pedidoTicketFiscal);
        }
        return arrayList;
    }

    private List<PedidoTicketFiscal> ordenacaoPedido(List lista) {
        if (lista != null) {
            Collections.sort(lista, (o1, o2) -> {
                PedidoTicketFiscal item1 = (PedidoTicketFiscal)o1;
                PedidoTicketFiscal item2 = (PedidoTicketFiscal)o2;
                return item1.getPedido().getIdentificador().compareTo(item2.getPedido().getIdentificador());
            });
            return lista;
        }
        return null;
    }

    private List<GradeItemTicketFiscal> criarGradeItemTicketFiscal(TicketFiscal t) {
        ArrayList<GradeItemTicketFiscal> listGradeItemTicketFiscal = new ArrayList<GradeItemTicketFiscal>();
        GradeItemTicketFiscal g = new GradeItemTicketFiscal();
        g.setGradeCor(t.getGradeCor());
        g.setQuantidade(t.getPesoLiquidoTotal());
        g.setValorCusto(Double.valueOf(0.0));
        g.setLoteFabricacao(t.getLoteFabricacao());
        g.setMovimentacaoFisica(t.getNaturezaOperacaoTicketFiscal().getMvEstoque());
        g.setTicketFiscal(t);
        g.setProvisao(Short.valueOf((short)1));
        g.setDataMovimentacao(t.getDataFechamento());
        g.setCentroEstoque(t.getCentroEstoque());
        g.setEmpresa(t.getEmpresa());
        listGradeItemTicketFiscal.add(g);
        return listGradeItemTicketFiscal;
    }

    private List<ObsTicketFiscal> criarObsTicketFiscal(TicketFiscal t, List<Element> listElementObsTicketFiscal) {
        ArrayList<ObsTicketFiscal> listObsTicketFiscal = new ArrayList<ObsTicketFiscal>();
        for (Element elementObsTicketFiscal : listElementObsTicketFiscal) {
            ObsTicketFiscal o = new ObsTicketFiscal();
            o.setTicketFiscal(t);
            o.setObservacao(((NaturezaOperacaoObservacaoFiscal)t.getNaturezaOperacaoTicketFiscal().getNaturezaOperacaoObservacaoFiscal().get(0)).getObsFaturamento());
            o.setConteudo(elementObsTicketFiscal.getChildText("CONTEUDO"));
            listObsTicketFiscal.add(o);
        }
        return listObsTicketFiscal;
    }
}

