/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ticketfiscalterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.OpcoesTicketFiscal;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TicketFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.service.impl.categoriapessoa.ServiceCategoriaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.ticketfiscalterceiros.ServiceTicketFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.transportador.ServiceTransportadorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class UtilExportarImportarTicketFiscalEntrada {
    private static final ServiceTicketFiscalTerceirosImpl serviceTicketFiscalTerceirosImpl = (ServiceTicketFiscalTerceirosImpl)Context.get(ServiceTicketFiscalTerceirosImpl.class);
    private static final ServiceFornecedorImpl serviceFornecedorImpl = (ServiceFornecedorImpl)Context.get(ServiceFornecedorImpl.class);
    private static final ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl = (ServiceUnidadeFatFornecedorImpl)Context.get(ServiceUnidadeFatFornecedorImpl.class);
    private static final ServiceTransportadorImpl serviceTransportadorImpl = (ServiceTransportadorImpl)Context.get(ServiceTransportadorImpl.class);
    private static final ServicePessoaImpl servicePessoaImpl = (ServicePessoaImpl)Context.get(ServicePessoaImpl.class);
    private static final ServiceCidadeImpl serviceCidadeImpl = (ServiceCidadeImpl)Context.get(ServiceCidadeImpl.class);
    private static final ServiceCategoriaPessoaImpl serviceCategoriaPessoaImpl = (ServiceCategoriaPessoaImpl)Context.get(ServiceCategoriaPessoaImpl.class);
    private static final ServiceProdutoImpl serviceProdutoImpl = (ServiceProdutoImpl)Context.get(ServiceProdutoImpl.class);
    private static final ServiceGradeCorImpl serviceGradeCorImpl = (ServiceGradeCorImpl)Context.get(ServiceGradeCorImpl.class);
    private static final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
    private static final ServiceCentroEstoqueImpl serviceCentroEstoqueImpl = (ServiceCentroEstoqueImpl)Context.get(ServiceCentroEstoqueImpl.class);

    static Element exportarTicketFiscalEntrada(Empresa empresa, Date dataInicial, Date dataFinal) {
        List<TicketFiscalTerceiros> listTicketFiscalEntrada = serviceTicketFiscalTerceirosImpl.pesquisarTicketFiscalEntradaDataTicket(empresa, dataInicial, dataFinal);
        if (listTicketFiscalEntrada != null && !listTicketFiscalEntrada.isEmpty()) {
            Element touchCompErp = new Element("TOUCH_COMP_ERP");
            touchCompErp.addContent((Content)new Element("CNPJ").setText(empresa.getPessoa().getComplemento().getCnpj()));
            touchCompErp.addContent(UtilExportarImportarTicketFiscalEntrada.criarXmlTicketFiscalEntrada(listTicketFiscalEntrada));
            return touchCompErp;
        }
        return null;
    }

    private static List<Element> criarXmlTicketFiscalEntrada(List<TicketFiscalTerceiros> listTicketFiscalEntrada) {
        ArrayList<Element> listElement = new ArrayList<Element>();
        for (TicketFiscalTerceiros ticketFiscalEntrada : listTicketFiscalEntrada) {
            listElement.add(UtilExportarImportarTicketFiscalEntrada.criarTicketFiscalEntrada(ticketFiscalEntrada));
        }
        return listElement;
    }

    private static Element criarTicketFiscalEntrada(TicketFiscalTerceiros ticketFiscalEntrada) {
        Element elementTicketFiscal = new Element("TICKET_FISCAL_ENTRADA");
        elementTicketFiscal.addContent((Content)new Element("STATUS").setText(ticketFiscalEntrada.getStatus().toString()));
        elementTicketFiscal.addContent((Content)UtilExportarImportarTicketFiscalEntrada.criarFornecedor(ticketFiscalEntrada));
        elementTicketFiscal.addContent((Content)UtilExportarImportarTicketFiscalEntrada.criarTransportador(ticketFiscalEntrada));
        elementTicketFiscal.addContent((Content)new Element("PLACA").setText(ticketFiscalEntrada.getPlaca()));
        elementTicketFiscal.addContent((Content)new Element("NOME_MOTORISTA").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getNomeMotorista())));
        elementTicketFiscal.addContent((Content)new Element("CPF_MOTORISTA").setText(ticketFiscalEntrada.getCpfMotorista()));
        elementTicketFiscal.addContent((Content)new Element("NUMERO").setText(ticketFiscalEntrada.getNumero().toString()));
        elementTicketFiscal.addContent((Content)new Element("DATA_TICKET").setText(ToolDate.dateToStr((Date)ToolDate.mergeDateWithHour((Date)ticketFiscalEntrada.getDataTicket(), (Date)ticketFiscalEntrada.getHoraTicket()), (String)"dd/MM/yyyy HH:mm:ss")));
        elementTicketFiscal.addContent((Content)new Element("CODIGO_AUXILIAR_PRODUTO").setText(ticketFiscalEntrada.getProduto().getCodigoAuxiliar()));
        elementTicketFiscal.addContent((Content)new Element("VALOR_PRECO_MEDIO_UNITARIO").setText(ticketFiscalEntrada.getValorPrecoMedio().toString()));
        elementTicketFiscal.addContent((Content)new Element("GRADE_COR").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getGradeCor().getCor().getNome())));
        elementTicketFiscal.addContent((Content)new Element("LOTE_FABRICACAO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getLoteFabricacao().getLoteFabricacao())));
        elementTicketFiscal.addContent((Content)new Element("CENTRO_ESTOQUE").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getCentroEstoque().getDescricao())));
        elementTicketFiscal.addContent((Content)new Element("PESO_BRUTO").setText(ticketFiscalEntrada.getPesoBruto().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_LIQUIDO").setText(ticketFiscalEntrada.getPesoLiquido().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_BRUTO_BALANCA").setText(ticketFiscalEntrada.getPesoBrutoBalanca().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_TARA_BALANCA").setText(ticketFiscalEntrada.getPesoTara().toString()));
        elementTicketFiscal.addContent((Content)new Element("PESO_LIQUIDO_BALANCA").setText(ticketFiscalEntrada.getPesoLiquidoBalanca().toString()));
        elementTicketFiscal.addContent((Content)new Element("INFORMAR_MANUAL_PESO_TARA_TOTAL").setText(ticketFiscalEntrada.getInfManualPeso().toString()));
        elementTicketFiscal.addContent((Content)new Element("MOTIVO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getMotivoManualPeso())));
        elementTicketFiscal.addContent((Content)new Element("OBSERVACAO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getObservacao())));
        return elementTicketFiscal;
    }

    private static Element criarFornecedor(TicketFiscalTerceiros ticketFiscalEntrada) {
        Element elementFornecedor = new Element("FORNECEDOR");
        elementFornecedor.addContent((Content)new Element("NOME").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome())));
        elementFornecedor.addContent((Content)new Element("NOME_FANTASIA").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getNomeFantasia())));
        elementFornecedor.addContent((Content)new Element("CONTATO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getPessoaContato())));
        elementFornecedor.addContent((Content)new Element("CNPJ_CPF").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj()));
        elementFornecedor.addContent((Content)new Element("TIPO_PESSOA_COMPLEMENTO").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getTipoPessoa().toString()));
        elementFornecedor.addContent((Content)new Element("INSCRICAO_ESTADUAL").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getInscEst()));
        elementFornecedor.addContent((Content)new Element("CONTRIBUINTE_ESTADO").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getContribuinteEstado().toString()));
        elementFornecedor.addContent((Content)new Element("CEP").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getEndereco().getCep()));
        elementFornecedor.addContent((Content)new Element("LOGRADOURO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getEndereco().getLogradouro())));
        elementFornecedor.addContent((Content)new Element("NUMERO").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getEndereco().getNumero()));
        elementFornecedor.addContent((Content)new Element("BAIRRO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getEndereco().getBairro())));
        elementFornecedor.addContent((Content)new Element("CODIGO_IBGE").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        elementFornecedor.addContent((Content)new Element("COMPLEMENTO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getPessoa().getEndereco().getComplemento())));
        elementFornecedor.addContent((Content)new Element("TIPO").setText(ticketFiscalEntrada.getUnidadeFatFornecedor().getFornecedor().getTipo().toString()));
        elementFornecedor.addContent((Content)new Element("CATEGORIA_PESSOA").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getUnidadeFatFornecedor().getCategoriaPessoa().getDescricao())));
        return elementFornecedor;
    }

    private static Element criarTransportador(TicketFiscalTerceiros ticketFiscalEntrada) {
        Element elementTransportador = new Element("TRANSPORTADOR");
        elementTransportador.addContent((Content)new Element("NOME").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getTransportador().getPessoa().getNome())));
        elementTransportador.addContent((Content)new Element("NOME_FANTASIA").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getTransportador().getPessoa().getNomeFantasia())));
        elementTransportador.addContent((Content)new Element("CONTATO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getTransportador().getPessoa().getPessoaContato())));
        elementTransportador.addContent((Content)new Element("CNPJ_CPF").setText(ticketFiscalEntrada.getTransportador().getPessoa().getComplemento().getCnpj()));
        elementTransportador.addContent((Content)new Element("TIPO_PESSOA_COMPLEMENTO").setText(ticketFiscalEntrada.getTransportador().getPessoa().getComplemento().getTipoPessoa().toString()));
        elementTransportador.addContent((Content)new Element("INSCRICAO_ESTADUAL").setText(ticketFiscalEntrada.getTransportador().getPessoa().getComplemento().getInscEst()));
        elementTransportador.addContent((Content)new Element("CONTRIBUINTE_ESTADO").setText(ticketFiscalEntrada.getTransportador().getPessoa().getComplemento().getContribuinteEstado().toString()));
        elementTransportador.addContent((Content)new Element("CEP").setText(ticketFiscalEntrada.getTransportador().getPessoa().getEndereco().getCep()));
        elementTransportador.addContent((Content)new Element("LOGRADOURO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getTransportador().getPessoa().getEndereco().getLogradouro())));
        elementTransportador.addContent((Content)new Element("NUMERO").setText(ticketFiscalEntrada.getTransportador().getPessoa().getEndereco().getNumero()));
        elementTransportador.addContent((Content)new Element("BAIRRO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getTransportador().getPessoa().getEndereco().getBairro())));
        elementTransportador.addContent((Content)new Element("CODIGO_IBGE").setText(ticketFiscalEntrada.getTransportador().getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        elementTransportador.addContent((Content)new Element("COMPLEMENTO").setText(ToolString.clearSpecialCharacXML((String)ticketFiscalEntrada.getTransportador().getPessoa().getEndereco().getComplemento())));
        return elementTransportador;
    }

    static List<TicketFiscalTerceiros> importarTicketFiscalEntrada(Empresa empresa, OpcoesTicketFiscal opcoesTicketFiscal, File file, StringBuilder s) throws IOException, JDOMException, Exception {
        ArrayList<TicketFiscalTerceiros> listTicketFiscalEntrada = new ArrayList<TicketFiscalTerceiros>();
        Element e = UtilExportarImportarTicketFiscalEntrada.converterArquivo(file);
        UtilExportarImportarTicketFiscalEntrada.validarDadosTicketFiscalEntrada(empresa, e);
        for (Element elementTicketFiscalEntrada : e.getChildren("TICKET_FISCAL_ENTRADA")) {
            UtilExportarImportarTicketFiscalEntrada.buscarCamposTicketFiscalEntrada(empresa, opcoesTicketFiscal, s, listTicketFiscalEntrada, elementTicketFiscalEntrada);
        }
        return serviceTicketFiscalTerceirosImpl.saveOrUpdate(listTicketFiscalEntrada);
    }

    private static Element converterArquivo(File file) throws IOException, JDOMException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(file);
        return d.getRootElement();
    }

    private static void validarDadosTicketFiscalEntrada(Empresa empresa, Element e) throws Exception {
        if (!ToolMethods.isEquals((Object)empresa.getPessoa().getComplemento().getCnpj(), (Object)e.getChildText("CNPJ"))) {
            throw new Exception("A empresa logada \u00e9 diferente do CNPJ " + e.getChildText("CNPJ") + " a ser importado!");
        }
    }

    private static void buscarCamposTicketFiscalEntrada(Empresa empresa, OpcoesTicketFiscal opcoesTicketFiscal, StringBuilder s, List<TicketFiscalTerceiros> listTicketFiscalEntrada, Element elementTicketFiscalEntrada) {
        Short status = Short.valueOf(elementTicketFiscalEntrada.getChildText("STATUS"));
        Element elementFornecedor = elementTicketFiscalEntrada.getChild("FORNECEDOR");
        Element elementTransportador = elementTicketFiscalEntrada.getChild("TRANSPORTADOR");
        String placa = elementTicketFiscalEntrada.getChildText("PLACA");
        String nomeMotorista = elementTicketFiscalEntrada.getChildText("NOME_MOTORISTA");
        String cpfMotorista = elementTicketFiscalEntrada.getChildText("CPF_MOTORISTA");
        Long numero = Long.valueOf(elementTicketFiscalEntrada.getChildText("NUMERO"));
        Date dataTicket = ToolDate.strToDate((String)elementTicketFiscalEntrada.getChildText("DATA_TICKET"), (String)"dd/MM/yyyy HH:mm:ss");
        String codigoAuxiliarProduto = elementTicketFiscalEntrada.getChildText("CODIGO_AUXILIAR_PRODUTO");
        Double valorPrecoMedioUnitario = Double.valueOf(elementTicketFiscalEntrada.getChildText("VALOR_PRECO_MEDIO_UNITARIO"));
        String gradeCor = elementTicketFiscalEntrada.getChildText("GRADE_COR");
        String loteFabricacao = elementTicketFiscalEntrada.getChildText("LOTE_FABRICACAO");
        String centroEstoque = elementTicketFiscalEntrada.getChildText("CENTRO_ESTOQUE");
        Double pesoBruto = Double.valueOf(elementTicketFiscalEntrada.getChildText("PESO_BRUTO"));
        Double pesoLiquido = Double.valueOf(elementTicketFiscalEntrada.getChildText("PESO_LIQUIDO"));
        Double pesoBrutoBalanca = Double.valueOf(elementTicketFiscalEntrada.getChildText("PESO_BRUTO_BALANCA"));
        Double pesoTaraBalanca = Double.valueOf(elementTicketFiscalEntrada.getChildText("PESO_TARA_BALANCA"));
        Double pesoLiquidoBalanca = Double.valueOf(elementTicketFiscalEntrada.getChildText("PESO_LIQUIDO_BALANCA"));
        Short informarManualPesoTaraTotal = Short.valueOf(elementTicketFiscalEntrada.getChildText("INFORMAR_MANUAL_PESO_TARA_TOTAL"));
        String motivo = elementTicketFiscalEntrada.getChildText("MOTIVO");
        String observacao = elementTicketFiscalEntrada.getChildText("OBSERVACAO");
        if (UtilExportarImportarTicketFiscalEntrada.validarExisteTicketFiscalEntrada(empresa, elementFornecedor, numero, s)) {
            UtilExportarImportarTicketFiscalEntrada.criarTicketFiscalEntrada(empresa, opcoesTicketFiscal, s, listTicketFiscalEntrada, status, elementFornecedor, elementTransportador, placa, nomeMotorista, cpfMotorista, numero, dataTicket, codigoAuxiliarProduto, valorPrecoMedioUnitario, gradeCor, loteFabricacao, centroEstoque, pesoBruto, pesoLiquido, pesoBrutoBalanca, pesoTaraBalanca, pesoLiquidoBalanca, informarManualPesoTaraTotal, motivo, observacao);
        }
    }

    private static boolean validarExisteTicketFiscalEntrada(Empresa empresa, Element elementFornecedor, Long numero, StringBuilder s) {
        String cnpjCpf = elementFornecedor.getChildText("CNPJ_CPF");
        TicketFiscalTerceiros t = serviceTicketFiscalTerceirosImpl.pesquisarTicketFiscalEntradaEmpresaCnpjFornecedorNumero(empresa, cnpjCpf, numero);
        if (t != null) {
            s.append("Ticket Fiscal de Entrada com CNPJ Fornecedor: ").append(cnpjCpf).append(" N\u00famero: ").append(numero).append(" j\u00e1 importado!\n");
            return false;
        }
        return true;
    }

    private static void criarTicketFiscalEntrada(Empresa empresa, OpcoesTicketFiscal opcoesTicketFiscal, StringBuilder s, List<TicketFiscalTerceiros> listTicketFiscalEntrada, Short status, Element elementFornecedor, Element elementTransportador, String placa, String nomeMotorista, String cpfMotorista, Long numero, Date dataTicket, String codigoAuxiliarProduto, Double valorPrecoMedioUnitario, String gradeCor, String loteFabricacao, String centroEstoque, Double pesoBruto, Double pesoLiquido, Double pesoBrutoBalanca, Double pesoTaraBalanca, Double pesoLiquidoBalanca, Short informarManualPesoTaraTotal, String motivo, String observacao) {
        TicketFiscalTerceiros t = new TicketFiscalTerceiros();
        t.setEmpresa(empresa);
        t.setDataCadastro(new Date());
        t.setStatus(status);
        t.setMovimentarEstoque(opcoesTicketFiscal.getMovimentarEstoqueTicketEnt());
        t.setUnidadeFatFornecedor(UtilExportarImportarTicketFiscalEntrada.pesquisarCriarFornecedor(empresa, elementFornecedor));
        t.setTransportador(UtilExportarImportarTicketFiscalEntrada.pesquisarCriarTransportador(empresa, elementTransportador));
        t.setPlaca(placa);
        t.setNomeMotorista(nomeMotorista);
        t.setCpfMotorista(cpfMotorista);
        t.setNumero(numero);
        t.setNumeroInfManual(numero);
        t.setDataTicket(dataTicket);
        t.setHoraTicket(dataTicket);
        t.setProduto(serviceProdutoImpl.getByCodigoAuxiliar(codigoAuxiliarProduto));
        if (t.getProduto() == null) {
            s.append("N\u00e3o foi encontrado Produto cadastrado com o C\u00f3digo Auxiliar ").append(codigoAuxiliarProduto).append("!\n");
            return;
        }
        t.setValorPrecoMedio(valorPrecoMedioUnitario);
        t.setGradeCor(serviceGradeCorImpl.getGradeCorProdutoNome(t.getProduto(), gradeCor));
        if (t.getGradeCor() == null) {
            s.append("N\u00e3o foi encontrado Grade Cor cadastrado com o Nome ").append(gradeCor).append(" para o Produto ").append(t.getProduto().getNome()).append("!\n");
            return;
        }
        t.setLoteFabricacao(serviceLoteFabricacaoImpl.findLoteFabricacao(t.getProduto(), loteFabricacao));
        if (t.getLoteFabricacao() == null) {
            s.append("N\u00e3o foi encontrado Lote Fabrica\u00e7\u00e3o cadastrado com o Nome ").append(loteFabricacao).append(" para o Produto ").append(t.getProduto().getNome()).append("!\n");
            return;
        }
        t.setCentroEstoque(serviceCentroEstoqueImpl.getCentroEstoqueNome(centroEstoque));
        if (t.getCentroEstoque() == null) {
            s.append("N\u00e3o foi encontrado Centro Estoque cadastrado com o Nome ").append(centroEstoque).append("!\n");
            return;
        }
        t.setPesoBruto(pesoBruto);
        t.setPesoLiquido(pesoLiquido);
        t.setPesoBrutoBalanca(pesoBrutoBalanca);
        t.setPesoTara(pesoTaraBalanca);
        t.setPesoLiquidoBalanca(pesoLiquidoBalanca);
        t.setInfManualPeso(informarManualPesoTaraTotal);
        t.setMotivoManualPeso(motivo);
        t.setObservacao(observacao);
        listTicketFiscalEntrada.add(t);
    }

    private static UnidadeFatFornecedor pesquisarCriarFornecedor(Empresa empresa, Element elementFornecedor) {
        String nome = elementFornecedor.getChildText("NOME");
        String nomeFantasia = elementFornecedor.getChildText("NOME_FANTASIA");
        String contato = elementFornecedor.getChildText("CONTATO");
        String cnpjCpf = elementFornecedor.getChildText("CNPJ_CPF");
        Short tipoPessoaComplemento = Short.valueOf(elementFornecedor.getChildText("TIPO_PESSOA_COMPLEMENTO"));
        String inscricaoEstadual = elementFornecedor.getChildText("INSCRICAO_ESTADUAL");
        Short contribuinteEstado = Short.valueOf(elementFornecedor.getChildText("CONTRIBUINTE_ESTADO"));
        String cep = elementFornecedor.getChildText("CEP");
        String logradouro = elementFornecedor.getChildText("LOGRADOURO");
        String numero = elementFornecedor.getChildText("NUMERO");
        String bairro = elementFornecedor.getChildText("BAIRRO");
        String codigoIbge = elementFornecedor.getChildText("CODIGO_IBGE");
        String complemento = elementFornecedor.getChildText("COMPLEMENTO");
        Short tipo = Short.valueOf(elementFornecedor.getChildText("TIPO"));
        String categoriaPessoa = elementFornecedor.getChildText("CATEGORIA_PESSOA");
        return UtilExportarImportarTicketFiscalEntrada.criarFornecedor(empresa, nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento, tipo, categoriaPessoa);
    }

    private static UnidadeFatFornecedor criarFornecedor(Empresa empresa, String nome, String nomeFantasia, String contato, String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado, String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento, Short tipo, String categoriaPessoa) {
        UnidadeFatFornecedor unidadeFatFornecedor = serviceUnidadeFatFornecedorImpl.getFirstByCnpjCPF(cnpjCpf);
        if (unidadeFatFornecedor == null) {
            Fornecedor fornecedor = new Fornecedor();
            fornecedor.setPessoa(UtilExportarImportarTicketFiscalEntrada.criarFornecedorTransportadorPessoa(nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento));
            fornecedor.setEmpresa(empresa);
            fornecedor.setDataCadastro(new Date());
            fornecedor.setTipo(tipo);
            fornecedor.setCategoriaPessoa(UtilExportarImportarTicketFiscalEntrada.criarCategoriaPessoa(empresa, categoriaPessoa));
            fornecedor.setUnidadesFatForn(UtilExportarImportarTicketFiscalEntrada.criarUnidadeFatFornecedor(fornecedor));
            fornecedor = serviceFornecedorImpl.saveOrUpdate(fornecedor);
            unidadeFatFornecedor = (UnidadeFatFornecedor)fornecedor.getUnidadesFatForn().get(0);
        }
        return serviceUnidadeFatFornecedorImpl.saveOrUpdate(unidadeFatFornecedor);
    }

    private static Transportador pesquisarCriarTransportador(Empresa empresa, Element elementTransportador) {
        String nome = elementTransportador.getChildText("NOME");
        String nomeFantasia = elementTransportador.getChildText("NOME_FANTASIA");
        String contato = elementTransportador.getChildText("CONTATO");
        String cnpjCpf = elementTransportador.getChildText("CNPJ_CPF");
        Short tipoPessoaComplemento = Short.valueOf(elementTransportador.getChildText("TIPO_PESSOA_COMPLEMENTO"));
        String inscricaoEstadual = elementTransportador.getChildText("INSCRICAO_ESTADUAL");
        Short contribuinteEstado = Short.valueOf(elementTransportador.getChildText("CONTRIBUINTE_ESTADO"));
        String cep = elementTransportador.getChildText("CEP");
        String logradouro = elementTransportador.getChildText("LOGRADOURO");
        String numero = elementTransportador.getChildText("NUMERO");
        String bairro = elementTransportador.getChildText("BAIRRO");
        String codigoIbge = elementTransportador.getChildText("CODIGO_IBGE");
        String complemento = elementTransportador.getChildText("COMPLEMENTO");
        return UtilExportarImportarTicketFiscalEntrada.criarTransportador(empresa, nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento);
    }

    private static Transportador criarTransportador(Empresa empresa, String nome, String nomeFantasia, String contato, String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado, String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento) {
        Transportador transportador = serviceTransportadorImpl.findByCNPJAtivo(cnpjCpf);
        if (transportador == null) {
            transportador = new Transportador();
            transportador.setPessoa(UtilExportarImportarTicketFiscalEntrada.criarFornecedorTransportadorPessoa(nome, nomeFantasia, contato, cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado, cep, logradouro, numero, bairro, codigoIbge, complemento));
            transportador.setEmpresa(empresa);
            transportador.setDataCadastro(new Date());
        }
        return serviceTransportadorImpl.saveOrUpdate(transportador);
    }

    private static Pessoa criarFornecedorTransportadorPessoa(String nome, String nomeFantasia, String contato, String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado, String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento) {
        Pessoa pessoa = servicePessoaImpl.getByCPFCNPJ(cnpjCpf);
        if (pessoa == null) {
            pessoa = new Pessoa();
            pessoa.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.value));
            pessoa.setNome(nome);
            pessoa.setNomeFantasia(nomeFantasia);
            pessoa.setPessoaContato(contato);
            pessoa.setEndereco(UtilExportarImportarTicketFiscalEntrada.criarFornecedorTransportadorEndereco(cep, logradouro, numero, bairro, codigoIbge, complemento));
            pessoa.setComplemento(UtilExportarImportarTicketFiscalEntrada.criarFornecedorTransportadorComplemento(cnpjCpf, tipoPessoaComplemento, inscricaoEstadual, contribuinteEstado));
            pessoa.setDataCadastro(new Date());
            pessoa.setDataInicioRelacionamento(new Date());
            pessoa.setTipoPessoa(Short.valueOf(EnumConstTipoPessoa.PESSOA_PRIMARIA.value));
        }
        return servicePessoaImpl.saveOrUpdate(pessoa);
    }

    private static Endereco criarFornecedorTransportadorEndereco(String cep, String logradouro, String numero, String bairro, String codigoIbge, String complemento) {
        Endereco endereco = new Endereco();
        endereco.setLogradouro(logradouro);
        endereco.setCep(cep);
        endereco.setBairro(bairro);
        endereco.setNumero(numero);
        endereco.setComplemento(complemento);
        endereco.setCidade(serviceCidadeImpl.getByCodigoIBGECompleto(codigoIbge));
        return endereco;
    }

    private static Complemento criarFornecedorTransportadorComplemento(String cnpjCpf, Short tipoPessoaComplemento, String inscricaoEstadual, Short contribuinteEstado) {
        Complemento complemento = new Complemento();
        complemento.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.value));
        complemento.setCnpj(cnpjCpf);
        complemento.setTipoPessoa(tipoPessoaComplemento);
        complemento.setInscEst(inscricaoEstadual);
        complemento.setContribuinteEstado(contribuinteEstado);
        return complemento;
    }

    private static CategoriaPessoa criarCategoriaPessoa(Empresa empresa, String categoriaPessoa) {
        CategoriaPessoa c = serviceCategoriaPessoaImpl.getCategoriaPessoaNome(categoriaPessoa);
        if (c == null) {
            c = new CategoriaPessoa();
            c.setDescricao(categoriaPessoa);
            c.setEmpresa(empresa);
            c.setDataCadastro(new Date());
        }
        return serviceCategoriaPessoaImpl.saveOrUpdate(c);
    }

    private static List<UnidadeFatFornecedor> criarUnidadeFatFornecedor(Fornecedor fornecedor) {
        ArrayList<UnidadeFatFornecedor> listUnidadeFatFornecedor = new ArrayList<UnidadeFatFornecedor>();
        UnidadeFatFornecedor unidadeFatFornecedor = new UnidadeFatFornecedor();
        unidadeFatFornecedor.setFornecedor(fornecedor);
        unidadeFatFornecedor.setPessoa(fornecedor.getPessoa());
        unidadeFatFornecedor.setUnidadeFatPadrao(Short.valueOf(EnumConstantsMentorSimNao.SIM.value));
        unidadeFatFornecedor.setCategoriaPessoa(fornecedor.getCategoriaPessoa());
        listUnidadeFatFornecedor.add(unidadeFatFornecedor);
        return listUnidadeFatFornecedor;
    }
}

