/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ticketfiscalterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ticketfiscal.EnumConstTicketFiscalStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesTicketFiscal;
import com.touchcomp.basementor.model.vo.TicketFiscalTerceiros;
import com.touchcomp.basementorclientwebservices.integracaobalanca.gridnet.IntegracaoBalancaGridNetService;
import com.touchcomp.basementorclientwebservices.integracaobalanca.gridnet.services.IntegracaoServiceServiceStub;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.ticketfiscalterceiros.ServiceTicketFiscalTerceirosImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.rmi.RemoteException;
import java.util.Date;

public class UtilImportarTicketFiscalEntradaGridNet {
    private static final ServiceGradeCorImpl serviceGradeCorImpl = (ServiceGradeCorImpl)Context.get(ServiceGradeCorImpl.class);
    private static final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
    private static final ServiceTicketFiscalTerceirosImpl serviceTicketFiscalTerceirosImpl = (ServiceTicketFiscalTerceirosImpl)Context.get(ServiceTicketFiscalTerceirosImpl.class);

    static void importarTicketFiscalEntradaGridNet(Empresa empresa, OpcoesTicketFiscal opcoesTicketFiscal, Short numeroPeriodo, Long numero, Date dataInicial, Date dataFinal) throws RemoteException, Exception {
        if (ToolMethods.isEquals((Object)numeroPeriodo, (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            IntegracaoServiceServiceStub.Response r = new IntegracaoBalancaGridNetService().conexaoPorNumero(opcoesTicketFiscal.getBalancaRodoviario().getLoginGridnet(), opcoesTicketFiscal.getBalancaRodoviario().getSenhaGridNet(), String.valueOf(numero));
            UtilImportarTicketFiscalEntradaGridNet.criarTicketFiscal(empresa, opcoesTicketFiscal, r);
        } else {
            IntegracaoServiceServiceStub.Response[] r = new IntegracaoBalancaGridNetService().conexaoPorPeriodo(opcoesTicketFiscal.getBalancaRodoviario().getLoginGridnet(), opcoesTicketFiscal.getBalancaRodoviario().getSenhaGridNet(), ToolDate.dateToStr((Date)dataInicial, (String)"dd/MM/yyyy"), ToolDate.dateToStr((Date)dataFinal, (String)"dd/MM/yyyy"));
            UtilImportarTicketFiscalEntradaGridNet.validarResponse(empresa, opcoesTicketFiscal, r);
        }
    }

    private static void validarResponse(Empresa empresa, OpcoesTicketFiscal opcoesTicketFiscal, IntegracaoServiceServiceStub.Response[] r) throws Exception {
        for (IntegracaoServiceServiceStub.Response response : r) {
            UtilImportarTicketFiscalEntradaGridNet.criarTicketFiscal(empresa, opcoesTicketFiscal, response);
        }
    }

    private static void criarTicketFiscal(Empresa empresa, OpcoesTicketFiscal opcoesTicketFiscal, IntegracaoServiceServiceStub.Response r) throws Exception {
        if (r != null && r.getPESOBRUTO() != null) {
            TicketFiscalTerceiros t = new TicketFiscalTerceiros();
            t.setEmpresa(empresa);
            t.setDataCadastro(new Date());
            if (ToolMethods.isEquals((Object)opcoesTicketFiscal.getImpStatusFechadoGridNetEnt(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                t.setStatus(Short.valueOf(EnumConstTicketFiscalStatus.FECHADA.getValue()));
            } else {
                t.setStatus(Short.valueOf(EnumConstTicketFiscalStatus.ABERTO.getValue()));
            }
            t.setMovimentarEstoque(opcoesTicketFiscal.getMovimentarEstoqueTicketEnt());
            t.setUnidadeFatFornecedor(opcoesTicketFiscal.getUnidFatFornGridNetEnt());
            t.setTransportador(opcoesTicketFiscal.getTransportadorGridNetEnt());
            t.setPlaca(r.getCODE());
            t.setNumero(Long.valueOf(r.getCODE()));
            t.setNumeroInfManual(Long.valueOf(r.getCODE()));
            t.setDataTicket(ToolDate.strToDate((String)r.getDATAENTRADA()));
            t.setHoraTicket(ToolDate.strToDate((String)(r.getDATAENTRADA() + " " + r.getHORAENTRADA()), (String)"dd/MM/yyyy HH:mm:ss"));
            t.setProduto(opcoesTicketFiscal.getProdutoGridNetEnt());
            t.setValorPrecoMedio(Double.valueOf(0.0));
            t.setGradeCor(serviceGradeCorImpl.getFirstGradeCor(t.getProduto()));
            if (t.getGradeCor() == null) {
                throw new Exception("N\u00e3o foi encontrado Grade Cor cadastrado com o Produto " + t.getProduto().getNome() + "!");
            }
            t.setLoteFabricacao(serviceLoteFabricacaoImpl.findLoteUnico(t.getProduto()));
            if (t.getLoteFabricacao() == null) {
                throw new Exception("N\u00e3o foi encontrado Lote Fabrica\u00e7\u00e3o cadastrado com o Produto " + t.getProduto().getNome() + "!");
            }
            t.setCentroEstoque(opcoesTicketFiscal.getCentroEstoqueGridNetEnt());
            t.setPesoBruto(Double.valueOf(r.getPESOBRUTO().doubleValue() / opcoesTicketFiscal.getBalancaRodoviario().getFatorConversao()));
            t.setPesoLiquido(Double.valueOf(r.getPES0LIQUIDO().doubleValue() / opcoesTicketFiscal.getBalancaRodoviario().getFatorConversao()));
            t.setPesoBrutoBalanca(Double.valueOf(r.getPESOBRUTO().doubleValue() / opcoesTicketFiscal.getBalancaRodoviario().getFatorConversao()));
            t.setPesoTara(Double.valueOf(r.getPESOTARA().doubleValue() / opcoesTicketFiscal.getBalancaRodoviario().getFatorConversao()));
            t.setPesoLiquidoBalanca(Double.valueOf(r.getPES0LIQUIDO().doubleValue() / opcoesTicketFiscal.getBalancaRodoviario().getFatorConversao()));
            t.setInfManualPeso(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            if (UtilImportarTicketFiscalEntradaGridNet.verificarExisteTicketFiscalTerceiros(t)) {
                serviceTicketFiscalTerceirosImpl.saveOrUpdate(t);
            }
        }
    }

    private static boolean verificarExisteTicketFiscalTerceiros(TicketFiscalTerceiros t) {
        TicketFiscalTerceiros ticketFiscalTerceiros = serviceTicketFiscalTerceirosImpl.pesquisarTicketFiscalEntradaEmpresaNumeroDataHora(t.getEmpresa(), t.getNumero(), t.getDataTicket(), t.getHoraTicket());
        return ticketFiscalTerceiros == null;
    }
}

