/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.titulo;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRec;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.FechamentoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoTituloImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceTitulo;
import com.touchcomp.touchvomodel.vo.liberacaotitulo.DTOLiberacaoTitulos;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceTituloImpl
extends ServiceGenericEntityImpl<Titulo, Long, DaoTituloImpl>
implements ServiceTitulo {
    @Autowired
    private ServiceFornecedorImpl serviceFornecedor;

    @Override
    public Titulo beforeSave(Titulo vo) {
        if (vo.getBoletoTitulo() != null) {
            for (BoletoTitulo bt : vo.getBoletoTitulo()) {
                bt.setTitulo(vo);
                if (bt.getLogTitulos() != null) {
                    bt.getLogTitulos().forEach(lt -> lt.setBoletoTitulo(bt));
                }
                if (bt.getItensAltBoleto() == null) continue;
                bt.getItensAltBoleto().forEach(iab -> iab.setBoletoTitulo(bt));
            }
        }
        if (vo.getLogCobrancaTitulos() != null) {
            vo.getLogCobrancaTitulos().forEach(lct -> lct.setTitulo(vo));
        }
        if (vo.getLogTituloCnab() != null) {
            vo.getLogTituloCnab().forEach(ltc -> ltc.setTitulo(vo));
        }
        if (vo.getRepresentantes() != null) {
            vo.getRepresentantes().forEach(tr -> tr.setTitulo(vo));
        }
        if (vo.getTipoValoresTitulosTitulos() != null) {
            vo.getTipoValoresTitulosTitulos().forEach(tvt -> tvt.setTitulo(vo));
        }
        if (vo.getTituloPisCofins() != null) {
            vo.getTituloPisCofins().forEach(tpc -> tpc.setTitulo(vo));
        }
        return vo;
    }

    @Autowired
    public ServiceTituloImpl(DaoTituloImpl genericDao) {
        super(genericDao);
    }

    @Override
    public Double findValorTotalTitulos(Pessoa pessoa, EnumConstTituloPagRec pagRec) {
        return this.findValorTotalTitulos(pessoa.getIdentificador(), pagRec);
    }

    @Override
    public Long findNumTitulosProtestados(Pessoa pessoa, EnumConstTituloPagRec pagRec) {
        return this.findNumTitulosProtestados(pessoa.getIdentificador(), pagRec);
    }

    @Override
    public Double findMaiorAtrasoTitulo(Pessoa pessoa, EnumConstTituloPagRec pagRec) {
        return this.findMaiorAtrasoTitulo(pessoa.getIdentificador(), pagRec);
    }

    @Override
    public Double findAtrasoMedioTitulos(Pessoa pessoa, EnumConstTituloPagRec pagRec) {
        return this.findAtrasoMedioTitulos(pessoa.getIdentificador(), pagRec);
    }

    @Override
    public Double findPercentualAtrasoTitulos(Pessoa pessoa, EnumConstTituloPagRec pagRec) {
        return this.findPercentualAtrasoTitulos(pessoa.getIdentificador(), pagRec);
    }

    @Override
    public Double findValorTotalTitulos(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findValorTotalTitulos(idPessoa, pagRec);
    }

    @Override
    public Long findNumTitulosProtestados(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findNumTitulosProtestados(idPessoa, pagRec);
    }

    @Override
    public Long findNumTitulosCartorio(Pessoa pessoa, EnumConstTituloPagRec pagRec) {
        return this.findNumTitulosCartorio(pessoa.getIdentificador(), pagRec);
    }

    @Override
    public Long findNumTitulosCartorio(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findNumTitulosCartorio(idPessoa, pagRec);
    }

    @Override
    public Double findMaiorAtrasoTitulo(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findMaiorAtrasoTitulo(idPessoa, pagRec);
    }

    @Override
    public Double findAtrasoMedioTitulos(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findAtrasoMedioTitulos(idPessoa, pagRec);
    }

    @Override
    public Double findPercentualAtrasoTitulos(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findPercentualAtrasoTitulos(idPessoa, pagRec);
    }

    @Override
    public Titulo getByCodigoAuxiliar(String codigoAuxiliar) {
        return ((DaoTituloImpl)this.getGenericDao()).getByCodigoAuxiliar(codigoAuxiliar);
    }

    @Override
    public Date findUltimaDataTituloCartorio(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findUltimaDataTituloCartorio(idPessoa, pagRec);
    }

    @Override
    public Date findUltimaDataTituloProtesto(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findUltimaDataTituloProtesto(idPessoa, pagRec);
    }

    public Date findUltimaDataTituloSustado(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findUltimaDataTituloSustado(idPessoa, pagRec);
    }

    public List<Titulo> findTitulosComCotacaoOutraMoedaSemIntegracaoTaxaCambial(Long idGrupoEmpresa, Long idMoeda, Date dataFinal) {
        return ((DaoTituloImpl)this.getGenericDao()).findTitulosComCotacaoOutraMoedaSemIntegracaoTaxaCambial(idGrupoEmpresa, idMoeda, dataFinal);
    }

    @Override
    public Double findSaldoTitulosAntecipado(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findSaldoTitulosAntecipado(idPessoa, pagRec);
    }

    @Override
    public Double findValorTotalTitulosAntecipados(Long idPessoa, EnumConstTituloPagRec pagRec) {
        return ((DaoTituloImpl)this.getGenericDao()).findValorTotalTitulosAntecipados(idPessoa, pagRec);
    }

    @Transactional(readOnly=true)
    public List<BaixaTitulo> findBaixasPorTitulo(Titulo titulo) {
        return ((DaoTituloImpl)this.getGenericDao()).findBaixasPorTitulo(titulo);
    }

    public List<Titulo> findTitulosPorDataEmissaoAndVencimentoAndMeioPagAndTipoDocAndPagRec(Date dataEmissaoInicial, Date dataEmissaoFinal, Date dateVencInicial, Date dataVencFinal, Short pagRec, MeioPagamento meioPagamento, TipoDoc tipoDoc) {
        return ((DaoTituloImpl)this.getGenericDao()).findTitulosPorDataEmissaoAndVencimentoAndMeioPagAndTipoDocAndPagRec(dataEmissaoInicial, dataEmissaoFinal, dateVencInicial, dataVencFinal, pagRec, meioPagamento, tipoDoc);
    }

    public List<DTOLiberacaoTitulos.DTOItemLiberacaoTitulo> findTitulosNaoLiberados(Short filtrarDataCad, Date dataCadInicial, Date dataCadFinal, Short filtrarDataVenc, Date dataVencInicial, Date dataVencFinal, Short filtrarEmpresa, Long empresaIdentificador, Short filtrarFornecedor, Long idFornecedor) throws ExceptionObjNotFound {
        Long pessoaFornIdentificador = 0L;
        if (this.isAffimative(filtrarFornecedor)) {
            Fornecedor fornecedor = (Fornecedor)this.serviceFornecedor.getOrThrow(idFornecedor);
            pessoaFornIdentificador = fornecedor.getPessoa().getIdentificador();
        }
        List aux = ((DaoTituloImpl)this.getDao()).findTitulosNaoLiberados(filtrarDataCad, dataCadInicial, dataCadFinal, filtrarDataVenc, dataVencInicial, dataVencFinal, filtrarFornecedor, pessoaFornIdentificador, filtrarEmpresa, empresaIdentificador);
        List<DTOLiberacaoTitulos.DTOTitulo> temp = this.buildToDTO(aux, DTOLiberacaoTitulos.DTOTitulo.class);
        LinkedList<DTOLiberacaoTitulos.DTOItemLiberacaoTitulo> ret = new LinkedList<DTOLiberacaoTitulos.DTOItemLiberacaoTitulo>();
        for (DTOLiberacaoTitulos.DTOTitulo titulo : temp) {
            ret.add(new DTOLiberacaoTitulos.DTOItemLiberacaoTitulo(titulo));
        }
        return ret;
    }

    public DTOLiberacaoTitulos.DTOItemLiberacaoTitulo findTituloNaoLiberado(Long idTitulo) {
        Titulo t = ((DaoTituloImpl)this.getGenericDao()).findTituloNaoLiberado(idTitulo);
        if (t == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0791.001", new Object[]{idTitulo}));
        }
        return new DTOLiberacaoTitulos.DTOItemLiberacaoTitulo(this.buildToDTO(t, DTOLiberacaoTitulos.DTOTitulo.class));
    }

    public Double findSomatorioValorTotalTitulos(Cliente cliente) {
        return ((DaoTituloImpl)this.getGenericDao()).findSomatorioValorTotalTitulos(cliente);
    }

    public Double findTotalCompraPorPeriodoAndPessoa(Date dataInicial, Date dataFinal, String cnpj) {
        return ((DaoTituloImpl)this.getDao()).findTotalCompraPorPeriodoAndPessoa(dataInicial, dataFinal, cnpj);
    }

    public Double findTotalPagoPorPeriodoAndPessoa(Date dataInicial, Date dataFinal, String cnpj) {
        return ((DaoTituloImpl)this.getDao()).findTotalPagoPorPeriodoAndPessoa(dataInicial, dataFinal, cnpj);
    }

    public Double findTotalAVencerPorPeriodoAndPessoa(Date dataInicial, Date dataFinal, String cnpj) {
        return ((DaoTituloImpl)this.getDao()).findTotalAVencerPorPeriodoAndPessoa(dataInicial, dataFinal, cnpj);
    }

    public Double findTotalVencidoPorPessoa(Date dataInicial, String cnpj) {
        return ((DaoTituloImpl)this.getDao()).findTotalVencidoPorPessoa(dataInicial, cnpj);
    }

    public List<Titulo> findTitulosCooperados(Date dataVencimentoInicial, Date dataVencimentoFinal, TipoCooperado tipoCooperado, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos) {
        return ((DaoTituloImpl)this.getDao()).findTitulosCooperados(dataVencimentoInicial, dataVencimentoFinal, tipoCooperado, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos);
    }

    public List<Titulo> findTitulosCliente(Date dataVencimentoInicial, Date dataVencimentoFinal, ClassificacaoClientes classificacaoClientes, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, UnidadeFatCliente unidadeFatCliente, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        return ((DaoTituloImpl)this.getDao()).findTitulosCliente(dataVencimentoInicial, dataVencimentoFinal, classificacaoClientes, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, unidadeFatCliente, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo);
    }

    public List<Titulo> titulosAbertoMesesAnterioresCooperado(TipoCooperado tipoCooperado, Date periodoInicial, Date periodoEmissaoInicial, Date periodoEmissaoFinal, List<MeioPagamento> meiosPagamentos) {
        return ((DaoTituloImpl)this.getDao()).titulosAbertoMesesAnterioresCooperado(tipoCooperado, periodoInicial, periodoEmissaoInicial, periodoEmissaoFinal, meiosPagamentos);
    }

    public List<Titulo> titulosAbertoMesesAnterioresCliente(ClassificacaoClientes classificacaoClientes, Date dataVencimentoInicial, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        return ((DaoTituloImpl)this.getDao()).titulosAbertoMesesAnterioresCliente(classificacaoClientes, dataVencimentoInicial, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo);
    }

    public Titulo findTituloFechamentoAdiantamentoViagem(FechamentoAdiantamentoViagem vo) {
        return ((DaoTituloImpl)this.getGenericDao()).findTituloFechamentoAdiantamentoViagem(vo);
    }
}

