/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.transferenciacentroestoque;

import com.touchcomp.basementor.constants.enums.codigobarras.EnumConstCodigoBarras;
import com.touchcomp.basementor.model.vo.EmbalagemProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.PreEventoOsLinhaProducao;
import com.touchcomp.basementor.model.vo.TransFerenciaCCPreEvento;
import com.touchcomp.basementor.model.vo.TransfCentroEstoqueItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.embalagemproducao.ServiceEmbalagemProducaoImpl;
import com.touchcomp.basementorservice.service.impl.itemtransfcentroestoque.SCompItemTransfCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.preeventooslinhaproducao.ServicePreEventoOsLinhaProducaoImpl;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompTransferenciaCentroEstoqueImpl
extends ServiceGenericImpl {
    ServicePreEventoOsLinhaProducaoImpl servicePreEventoOsLinhaProducaoImpl;
    ServiceEmbalagemProducaoImpl serviceEmbalagemProducaoImpl;
    SCompItemTransfCentroEstoqueImpl sCompItemTransfCentroEstoqueImpl;

    public TransferenciaCentroEstoque getItemTransfCentroEstoqueByCodigoBarras(String codBarras, Empresa empresa, TransferenciaCentroEstoque transferenciaCentroEstoque) {
        String codigoBarras = codBarras.trim();
        if (this.isNotNull(codigoBarras).booleanValue() && codigoBarras.trim().length() > 3) {
            String origem = codigoBarras.substring(0, 2);
            if (origem.startsWith(EnumConstCodigoBarras.CODIGO_BARRAS_PRE_EVENTO_OS_LINHA.getCodigo())) {
                this.createItemByCodigoBarrasPreEvento(codigoBarras, empresa, transferenciaCentroEstoque);
            } else {
                this.createItemByCodigoBarrasEmbalagem(codigoBarras, empresa, transferenciaCentroEstoque);
            }
        }
        return transferenciaCentroEstoque;
    }

    private void createItemByCodigoBarrasPreEvento(String codigoBarras, Empresa empresa, TransferenciaCentroEstoque transferenciaCentroEstoque) {
        PreEventoOsLinhaProducao preEvento = this.servicePreEventoOsLinhaProducaoImpl.getPreEventoOsLinhaProducaoByCodigoBarras(codigoBarras);
        if (this.existenciaPreEvento(preEvento, transferenciaCentroEstoque.getPreEventos())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.818.004", new String[]{codigoBarras}));
        }
        ItemTransfCentroEstoque itemTransfCentroEstoque = this.sCompItemTransfCentroEstoqueImpl.createItemTransfCentroEstoque(transferenciaCentroEstoque.getDataTransferencia(), transferenciaCentroEstoque.getOrigem(), transferenciaCentroEstoque.getDestino(), preEvento.getProduto(), preEvento.getGradeCor(), preEvento.getQuantidade(), empresa);
        transferenciaCentroEstoque.getItemTransfCentroEstoque().add(itemTransfCentroEstoque);
        transferenciaCentroEstoque.getPreEventos().add(new TransFerenciaCCPreEvento(preEvento));
    }

    private boolean existenciaPreEvento(PreEventoOsLinhaProducao preEvento, List<TransFerenciaCCPreEvento> transferenciaCcPreEvento) {
        return transferenciaCcPreEvento.stream().anyMatch(item -> this.isEquals(item.getPreEvento(), preEvento));
    }

    private void createItemByCodigoBarrasEmbalagem(String codigoBarras, Empresa empresa, TransferenciaCentroEstoque transferenciaCentroEstoque) {
        EmbalagemProducao embalagemProducao = this.serviceEmbalagemProducaoImpl.getEmbalagemProducaoByCodigoBarras(codigoBarras, empresa);
        if (this.existenciaEmbalagem(embalagemProducao, transferenciaCentroEstoque.getItemEmbalagemProducao())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.818.005", new String[]{codigoBarras}));
        }
        if (SCompTransferenciaCentroEstoqueImpl.isWithData(embalagemProducao.getItemEmbalagemProducao())) {
            List itemTransfCentroEstoque = embalagemProducao.getItemEmbalagemProducao().stream().map(i -> {
                ItemTransfCentroEstoque item = this.sCompItemTransfCentroEstoqueImpl.createItemTransfCentroEstoque(transferenciaCentroEstoque.getDataTransferencia(), transferenciaCentroEstoque.getOrigem(), transferenciaCentroEstoque.getDestino(), i.getGradeCor().getProdutoGrade().getProduto(), i.getGradeCor(), i.getQuantidade(), empresa);
                if (this.isNotNull(i.getLoteFabricacao()).booleanValue()) {
                    ((GradeItemTransfCentroEstoque)item.getGradeItemTransCentroEst().getFirst()).setLoteFabricacao(i.getLoteFabricacao());
                }
                return item;
            }).collect(Collectors.toList());
            transferenciaCentroEstoque.getItemTransfCentroEstoque().addAll(itemTransfCentroEstoque);
            List transfCentroEstoqueItemEmbalagemProducao = embalagemProducao.getItemEmbalagemProducao().stream().map(i -> {
                TransfCentroEstoqueItemEmbalagemProducao item = new TransfCentroEstoqueItemEmbalagemProducao(i);
                return item;
            }).collect(Collectors.toList());
            transferenciaCentroEstoque.getItemEmbalagemProducao().addAll(transfCentroEstoqueItemEmbalagemProducao);
        }
    }

    private boolean existenciaEmbalagem(EmbalagemProducao embalagemProducao, List<TransfCentroEstoqueItemEmbalagemProducao> itemEmbalagemProducao) {
        return itemEmbalagemProducao.stream().anyMatch(item -> this.isEquals(item.getItemEmbalagemProducao().getEmbalagemProducao(), embalagemProducao));
    }

    @Generated
    public SCompTransferenciaCentroEstoqueImpl(ServicePreEventoOsLinhaProducaoImpl servicePreEventoOsLinhaProducaoImpl, ServiceEmbalagemProducaoImpl serviceEmbalagemProducaoImpl, SCompItemTransfCentroEstoqueImpl sCompItemTransfCentroEstoqueImpl) {
        this.servicePreEventoOsLinhaProducaoImpl = servicePreEventoOsLinhaProducaoImpl;
        this.serviceEmbalagemProducaoImpl = serviceEmbalagemProducaoImpl;
        this.sCompItemTransfCentroEstoqueImpl = sCompItemTransfCentroEstoqueImpl;
    }
}

