/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.transferenciacentroestoque;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.permissao.ExceptionNaoPermitido;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoTransferenciaCentroEstoqueImpl;
import com.touchcomp.basementorservice.helpers.impl.transferenciacentroestoque.HelperTransferenciaCentroEstoque;
import com.touchcomp.basementorservice.helpers.impl.wmsentradaprodutos.HelperWmsEntradaProdutos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.opcoesestoque.ServiceOpcoesEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.transferenciacentroestoque.SCompTransferenciaCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.touchvomodel.vo.transferenciacentroestoque.web.DTOTransferenciaCentroEstoque;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTransferenciaCentroEstoqueImpl
extends ServiceGenericEntityImpl<TransferenciaCentroEstoque, Long, DaoTransferenciaCentroEstoqueImpl> {
    HelperWmsEntradaProdutos wmsEntradaProdutos;
    HelperTransferenciaCentroEstoque helperTransferenciaCentroEstoque;
    ServiceCentroEstoqueImpl serviceCentroEstoqueImpl;
    ServiceEmpresaImpl serviceEmpresaImpl;
    ServiceProdutoImpl serviceProdutoImpl;
    ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;
    ServiceOpcoesEstoqueImpl serviceOpcoesEstoqueImpl;
    ServiceUsuarioImpl serviceUsuarioImpl;
    SCompTransferenciaCentroEstoqueImpl sCompTransferenciaCentroEstoqueImpl;

    @Autowired
    public ServiceTransferenciaCentroEstoqueImpl(DaoTransferenciaCentroEstoqueImpl genericDao, HelperWmsEntradaProdutos wmsEntradaProdutos, HelperTransferenciaCentroEstoque helperTransferenciaCentroEstoque, ServiceCentroEstoqueImpl serviceCentroEstoqueImpl, ServiceEmpresaImpl serviceEmpresaImpl, ServiceProdutoImpl serviceProdutoImpl, ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl, ServiceOpcoesEstoqueImpl serviceOpcoesEstoqueImpl, ServiceUsuarioImpl serviceUsuarioImpl, SCompTransferenciaCentroEstoqueImpl sCompTransferenciaCentroEstoqueImpl) {
        super(genericDao);
        this.wmsEntradaProdutos = wmsEntradaProdutos;
        this.helperTransferenciaCentroEstoque = helperTransferenciaCentroEstoque;
        this.serviceCentroEstoqueImpl = serviceCentroEstoqueImpl;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
        this.serviceOpcoesEstoqueImpl = serviceOpcoesEstoqueImpl;
        this.serviceUsuarioImpl = serviceUsuarioImpl;
        this.sCompTransferenciaCentroEstoqueImpl = sCompTransferenciaCentroEstoqueImpl;
    }

    @Override
    public TransferenciaCentroEstoque beforeSaveEntity(TransferenciaCentroEstoque aux) {
        for (ItemTransfCentroEstoque item : aux.getItemTransfCentroEstoque()) {
            Double quantidadeItem = 0.0;
            item.setTransfCentroEstoque(aux);
            for (GradeItemTransfCentroEstoque grade : item.getGradeItemTransCentroEst()) {
                grade.setItemTransfCentroEst(item);
                quantidadeItem = quantidadeItem + grade.getQuantidade();
            }
            item.setQuantidadeTotal(quantidadeItem);
        }
        aux.getItemEmbalagemProducao().forEach(i -> i.setTransferenciaCentroEstoque(aux));
        aux.getPreEventos().forEach(i -> i.setTransferenciaCentroEstoque(aux));
        try {
            aux.setWmsEntradaEstoque(this.wmsEntradaProdutos.getWmsEntrada(aux, this.getSharedData().getWmsOpcoes(aux.getEmpresa())));
        }
        catch (ExceptionInvalidState ex) {
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
        return super.beforeSave(aux);
    }

    public DTOTransferenciaCentroEstoque leituraCodigoBarras(String codBarras, CapsEmpresa capsEmpresa, DTOTransferenciaCentroEstoque dto) throws ExceptionObjNotFound {
        CentroEstoque centroEstoqueOrigem = (CentroEstoque)this.serviceCentroEstoqueImpl.get(dto.getOrigemIdentificador());
        this.serviceCentroEstoqueImpl.checkAndThrownNotExists((Object)centroEstoqueOrigem, MessagesBaseMentor.getMsg((String)"M.ERP.0818.001", (Object[])new Object[]{dto.getOrigemIdentificador()}));
        CentroEstoque centroEstoqueDestino = (CentroEstoque)this.serviceCentroEstoqueImpl.get(dto.getDestinoIdentificador());
        this.serviceCentroEstoqueImpl.checkAndThrownNotExists((Object)centroEstoqueDestino, MessagesBaseMentor.getMsg((String)"M.ERP.0818.002", (Object[])new Object[]{dto.getDestinoIdentificador()}));
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        if (this.isNull(dto.getDataTransferencia()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.818.003 "));
        }
        TransferenciaCentroEstoque transferenciaCentroEstoque = this.sCompTransferenciaCentroEstoqueImpl.getItemTransfCentroEstoqueByCodigoBarras(codBarras, empresa, (TransferenciaCentroEstoque)this.buildToEntity(dto));
        return this.buildToDTOGeneric(transferenciaCentroEstoque, DTOTransferenciaCentroEstoque.class);
    }

    public DTOTransferenciaCentroEstoque buscarSaldoEstoque(DTOTransferenciaCentroEstoque input) {
        input.getItemTransfCentroEstoque().forEach(item -> item.getGradeItemTransCentroEst().forEach(grade -> grade.setEstoque(this.getSaldo(item.getProdutoIdentificador(), grade.getGradeCorIdentificador(), input.getDataTransferencia(), input.getEmpresaIdentificador(), grade.getLoteFabricacaoIdentificador(), grade.getOrigemIdentificador()))));
        return input;
    }

    private Double getSaldo(Long produto, Long gradeCor, Date dataMovimentacao, Long empresa, Long loteFabricacao, Long centroEstoqueOrigem) {
        if (this.isNull(loteFabricacao).booleanValue()) {
            return 0.0;
        }
        CentroEstoque centroEstoque = (CentroEstoque)this.serviceCentroEstoqueImpl.get(centroEstoqueOrigem);
        SaldoEstoqueGeral saldoEstoqueGeral = this.serviceSaldoEstoqueImpl.findSaldoGradeCentroEstoqueLote(produto, gradeCor, dataMovimentacao, empresa, loteFabricacao, centroEstoqueOrigem, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, this.isNotNull(centroEstoque) != false ? EnumConstCentroEstTipoPropTerc.get((Object)centroEstoque.getTipoEstProprioTerceiros()) : EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        return this.isNotNull(saldoEstoqueGeral) != false ? saldoEstoqueGeral.getQuantidade() : 0.0;
    }

    public void verificarPermissaoUsuario(CapsEmpresa capsEmpresa, CapsUsuario capsUsuario, DTOTransferenciaCentroEstoque dto) throws ExceptionNaoPermitido {
        TransferenciaCentroEstoque vo = (TransferenciaCentroEstoque)this.buildToEntity(dto);
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.get(capsEmpresa.get());
        Usuario usuario = (Usuario)this.serviceUsuarioImpl.get(capsUsuario.get());
        OpcoesEstoque opcoesEstoque = this.serviceOpcoesEstoqueImpl.get(empresa);
        Boolean allowed = this.helperTransferenciaCentroEstoque.build(vo).verificaPermissaoUsuario(opcoesEstoque, usuario);
        if (!allowed.booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.818.008"));
        }
    }
}

