/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.transferenciacolaborador;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstRegistroESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoTransferenciaColaboradorImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.touchvomodel.vo.transferenciacolaborador.web.DTOTransferenciaColaborador;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTransferenciaColaboradorImpl
extends ServiceGenericEntityImpl<TransferenciaColaborador, Long, DaoTransferenciaColaboradorImpl> {
    @Autowired
    private ServiceColaboradorImpl serviceColaborador;
    @Autowired
    private ServiceMovimentoFolhaImpl serviceMovimentoFolha;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private HelperEsocPreEvento helperEsocPreEvento;

    @Autowired
    public ServiceTransferenciaColaboradorImpl(DaoTransferenciaColaboradorImpl dao) {
        super(dao);
    }

    @Override
    public TransferenciaColaborador beforeSave(TransferenciaColaborador vo) {
        if (ServiceTransferenciaColaboradorImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.getPreEventosEsocial().forEach(i -> i.setTransferenciaColaborador(vo));
        }
        if (this.isNotNull(vo.getColaborador()).booleanValue()) {
            vo.getColaborador().setEmpresa(vo.getEmpresaNova());
            vo.getColaborador().setDataTransferencia(vo.getDataTransferencia());
            if (this.isNotNull(vo.getEmpresaNova()).booleanValue()) {
                vo.getColaborador().setNumeroRegistro(vo.getNovaMatricula());
            }
            vo.getColaborador().setEstabelecimento(vo.getEstabelecimento());
            vo.getColaborador().setLotacaoTributaria(vo.getLotacaoTributaria());
            if (!this.isEquals(vo.getEmpresaNova().getEmpresaDados().getGrupoEmpresa(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa())) {
                vo.getColaborador().setNumeroRegistroESocial(vo.getColaborador().getNumeroRegistro());
            }
        }
        return vo;
    }

    public List<DTOTransferenciaColaborador> getTransferenciaColaboradorPorColaborador(Long idColaborador) {
        return this.buildToDTOGeneric(((DaoTransferenciaColaboradorImpl)this.getGenericDao()).getTransferenciaColaboradorPorColaborador(idColaborador), DTOTransferenciaColaborador.class);
    }

    public Boolean existeFolhaEmAberto(Long colaborador, Long empresa, Long dataFinal) {
        List<MovimentoFolha> movs = this.serviceMovimentoFolha.findFolhaAbertaColaborador(colaborador, empresa, dataFinal != null ? new Date(dataFinal) : null);
        return ServiceTransferenciaColaboradorImpl.isWithData(movs);
    }

    public void buildEsocEventos(TransferenciaColaborador vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        this.reload(vo);
        if (!ServiceTransferenciaColaboradorImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, EnumConstantsMentorSimNao.NAO.getValue(), EnumConstTipoEventoESocial.DESLIGAMENTO, EnumConstRegistroESocial.REGISTRO_2299));
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, EnumConstantsMentorSimNao.NAO.getValue(), EnumConstTipoEventoESocial.DESLIGAMENTO, EnumConstRegistroESocial.REGISTRO_2299));
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, EnumConstantsMentorSimNao.NAO.getValue(), EnumConstTipoEventoESocial.CADASTRAMENTO_INICIAL_VINC_ADMISSAO_INGRESSO_TRAB, EnumConstRegistroESocial.REGISTRO_2200));
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, EnumConstantsMentorSimNao.NAO.getValue(), EnumConstTipoEventoESocial.CADASTRAMENTO_INICIAL_VINC_ADMISSAO_INGRESSO_TRAB, EnumConstRegistroESocial.REGISTRO_2200));
            this.serviceEsocPreEvento.saveOrUpdate(vo.getPreEventosEsocial());
        }
    }

    public void deleteTransferenciaColaborador(Long identificador) throws ExceptionObjNotFound {
        TransferenciaColaborador vo = (TransferenciaColaborador)this.getOrThrow(identificador);
        if (this.isNotNull(vo).booleanValue()) {
            Colaborador c = vo.getColaborador();
            c.setEmpresa(vo.getEmpresa());
            c.setNumeroRegistro(vo.getMatriculaAnterior());
            if (!this.isEquals(vo.getEmpresa().getEmpresaDados().getGrupoEmpresa(), vo.getEmpresaNova().getEmpresaDados().getGrupoEmpresa())) {
                c.setNumeroRegistroESocial(vo.getMatriculaAnterior());
            }
            c.setDataTransferencia(null);
            this.delete(vo);
            this.serviceColaborador.saveOrUpdate(c);
        }
    }
}

