/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.transferenciacolaboradorcentrocusto;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorCentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemTransferenciaColaboradorCentroCusto;
import com.touchcomp.basementor.model.vo.TransferenciaColaboradorCentroCusto;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoTransferenciaColaboradorCentroCustoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.itemtransferenciacolaboradorcentrocusto.web.DTOItemTransferenciaColaboradorCentroCusto;
import com.touchcomp.touchvomodel.vo.transferenciacolaboradorcentrocusto.web.DTOTransferenciaColaboradorCentroCusto;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTransferenciaColaboradorCentroCustoImpl
extends ServiceGenericEntityImpl<TransferenciaColaboradorCentroCusto, Long, DaoTransferenciaColaboradorCentroCustoImpl> {
    @Autowired
    ServiceColaboradorImpl serviceColaboradorImpl;
    @Autowired
    ServiceCentroCustoImpl serviceCentroCustoImpl;
    @Autowired
    ServiceEmpresaImpl serviceEmpresaImpl;

    @Autowired
    public ServiceTransferenciaColaboradorCentroCustoImpl(DaoTransferenciaColaboradorCentroCustoImpl dao) {
        super(dao);
    }

    @Override
    public TransferenciaColaboradorCentroCusto beforeSaveEntity(TransferenciaColaboradorCentroCusto vo) {
        vo.getItemColaboradorCentroCusto().forEach(i -> {
            i.getColaborador().setCentroCusto(vo.getDestino());
            i.setTransferenciaColaboradorCentroCusto(vo);
        });
        return vo;
    }

    @Override
    public TransferenciaColaboradorCentroCusto beforeDeleteEntity(TransferenciaColaboradorCentroCusto vo) {
        vo.getItemColaboradorCentroCusto().forEach(i -> {
            i.getColaborador().setCentroCusto(vo.getOrigem());
            this.serviceColaboradorImpl.saveOrUpdate(i.getColaborador());
        });
        return vo;
    }

    public List<DTOItemTransferenciaColaboradorCentroCusto> buscarColaboradoresCentroCusto(DTOTransferenciaColaboradorCentroCusto input) throws ExceptionObjNotFound {
        if (this.isNull(input.getPeriodo()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1448.001"));
        }
        CentroCusto centroCustoOrigem = (CentroCusto)this.serviceCentroCustoImpl.getOrThrow(input.getOrigemIdentificador());
        CentroCusto centroCustoDestino = (CentroCusto)this.serviceCentroCustoImpl.getOrThrow(input.getDestinoIdentificador());
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(input.getEmpresaIdentificador());
        List<Colaborador> listColaborador = this.serviceColaboradorImpl.findColaboradorByCentroCustoAndEmpresa(empresa.getIdentificador(), centroCustoOrigem.getIdentificador());
        if (!ServiceTransferenciaColaboradorCentroCustoImpl.isWithData(listColaborador)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1448.002"));
        }
        List itemTransferenciaColaboradorCentroCusto = listColaborador.stream().map(i -> {
            ItemTransferenciaColaboradorCentroCusto item = new ItemTransferenciaColaboradorCentroCusto(i);
            item.setColaboradorCentroCusto(this.getColaboradorCentroCusto((Colaborador)i, ToolDate.getDateFirstMonthDay((Date)input.getPeriodo()), centroCustoOrigem, centroCustoDestino));
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(itemTransferenciaColaboradorCentroCusto, DTOItemTransferenciaColaboradorCentroCusto.class);
    }

    private ColaboradorCentroCusto getColaboradorCentroCusto(Colaborador colaborador, Date periodo, CentroCusto centroCustoOrigem, CentroCusto centroCustoDestino) {
        ColaboradorCentroCusto colaboradorCentroCusto = new ColaboradorCentroCusto();
        colaboradorCentroCusto.setColaborador(colaborador);
        colaboradorCentroCusto.setDataCadastro(new Date());
        colaboradorCentroCusto.setObservacao(this.getMessage("M.ERP.1448.001", new Object[0]));
        colaboradorCentroCusto.setPeriodo(periodo);
        colaboradorCentroCusto.setCentroCustoOrigem(centroCustoOrigem);
        colaboradorCentroCusto.setCentroCusto(centroCustoDestino);
        return colaboradorCentroCusto;
    }
}

