/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.transfestoquepcplin;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.planejamentolinhaproducao.materiais.EnumTipoGrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.GrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.model.vo.ItemMaterialPlanejLin;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.PlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.PlanejamentoMateriaisProdLin;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPLin;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPLinItem;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SCompTransfCentroEstoquePCPLin
extends ServiceGenericImpl {
    @Autowired
    private ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    private ServiceCentroEstoqueImpl serviceCentroEstoque;
    @Autowired
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao;

    public void gerarTransferencias(PlanejamentoMateriaisProdLin planejamento) throws ExceptionInvalidData {
        if (!this.isAffimative(planejamento.getLiberarReserva())) {
            return;
        }
        ArrayList<SaldoEstoqueGeralBasico> saldosUtilizados = new ArrayList<SaldoEstoqueGeralBasico>();
        for (GrupoPlanejamentoMateriaisLin grupo : planejamento.getGruposPlanejMat()) {
            if (!TMethods.isEquals((Object)grupo.getTipo(), (Object)EnumTipoGrupoPlanejamentoMateriaisLin.RESERVA.getValue()) || !SCompTransfCentroEstoquePCPLin.isWithData(grupo.getItensMateriaisPlanejLin())) continue;
            ArrayList<TransfEstoquePCPLinItem> itens = new ArrayList<TransfEstoquePCPLinItem>();
            TransfEstoquePCPLin transf = this.buildTransfEstoquePCPLin(planejamento, grupo);
            for (ItemMaterialPlanejLin itemMaterial : grupo.getItensMateriaisPlanejLin()) {
                this.reservarEstoque(transf, itemMaterial, saldosUtilizados, itens, planejamento.getCentroEstoque(), planejamento.getEmpresa());
            }
            this.atualizaTotalizadores(itens);
            transf.setTransferencias(itens);
            grupo.setTransfEstoquePCPLinReserva(transf);
        }
    }

    private TransfEstoquePCPLin buildTransfEstoquePCPLin(PlanejamentoMateriaisProdLin planejamento, GrupoPlanejamentoMateriaisLin grupo) {
        TransfEstoquePCPLin transf = new TransfEstoquePCPLin();
        transf.setDataCadastro(new Date());
        transf.setEmpresa(planejamento.getEmpresa());
        transf.setDescricao(grupo.getObservacao());
        transf.setCentroEstoqueReserva(planejamento.getCentroEstoque());
        transf.setGrupoPlanejamentoMateriais(grupo);
        return transf;
    }

    private void reservarEstoque(TransfEstoquePCPLin transf, ItemMaterialPlanejLin itemMaterial, List<SaldoEstoqueGeralBasico> saldosUtilizados, List<TransfEstoquePCPLinItem> itens, CentroEstoque reserva, Empresa emp) {
        Double qtdReservaBase;
        PlanejProdLinProdPrevConsProd p = itemMaterial.getPrevisaoConsProduto();
        if (!this.isAffimative(p.getEnviarParaReserva())) {
            return;
        }
        Double qtdReserva = qtdReservaBase = itemMaterial.getQuantidade();
        GradeCor gc = p.getGradeCor();
        Optional<SaldoEstoqueGeralBasico> opt = this.getSaldoInCash(saldosUtilizados, p);
        SaldoEstoqueGeralBasico saldo = opt.isEmpty() ? this.serviceSaldoEstoque.findSaldoGradeCor(p.getGradeCor().getProdutoGrade().getProduto(), p.getGradeCor(), new Date(), emp, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null) : opt.get();
        if (this.isNotNull(saldo).booleanValue()) {
            qtdReserva = this.addReserva(transf, qtdReserva, gc, saldo, itens, reserva, emp);
            if (opt.isEmpty()) {
                saldosUtilizados.add(saldo);
            }
        }
        if (qtdReserva > 0.0) {
            transf.setObservacaoSistema(MessagesBaseMentor.getMsg((String)"naoFoiPossivelReservarQuantidadeItem", (Object[])new Object[]{gc.getProdutoGrade().getProduto().getIdentificador(), gc.getProdutoGrade().getProduto().getCodigoAuxiliar(), gc.getProdutoGrade().getProduto().getNome(), String.valueOf(qtdReservaBase), String.valueOf(qtdReserva)}));
        }
    }

    private Optional<SaldoEstoqueGeralBasico> getSaldoInCash(List<SaldoEstoqueGeralBasico> saldos, PlanejProdLinProdPrevConsProd p) {
        return saldos.stream().filter(i -> this.isEquals(i.getIdProduto(), p.getGradeCor().getProdutoGrade().getProduto().getIdentificador()) && this.isEquals(i.getIdGradeCor(), p.getGradeCor().getIdentificador())).findFirst();
    }

    private Double addReserva(TransfEstoquePCPLin transf, Double qtdReserva, GradeCor gc, SaldoEstoqueGeralBasico saldo, List<TransfEstoquePCPLinItem> itens, CentroEstoque reserva, Empresa emp) {
        double aux;
        Double saldoQtd = ToolNumber.asZeroIfNull((Double)saldo.getQuantidade());
        if (saldoQtd > qtdReserva) {
            aux = 0.0;
            this.getTransfEstoquePCPLin(transf, gc, itens, saldo, reserva, emp, qtdReserva);
            saldo.setQuantidade(Double.valueOf(saldoQtd - qtdReserva));
        } else {
            this.getTransfEstoquePCPLin(transf, gc, itens, saldo, reserva, emp, saldoQtd);
            aux = qtdReserva - saldoQtd;
            saldo.setQuantidade(Double.valueOf(0.0));
        }
        return aux;
    }

    private void getTransfEstoquePCPLin(TransfEstoquePCPLin transf, GradeCor gc, List<TransfEstoquePCPLinItem> itens, SaldoEstoqueGeralBasico saldo, CentroEstoque reserva, Empresa emp, Double qtd) {
        Long idLoteFabN = saldo.getIdLoteFabricacao();
        Long idLoteFab = idLoteFabN != null ? idLoteFabN : 0L;
        Long idCentroEstoqueN = saldo.getIdCentroEstoque();
        Long idCentroEstoque = idCentroEstoqueN != null ? idCentroEstoqueN : 0L;
        CentroEstoque origem = (CentroEstoque)this.serviceCentroEstoque.get(idCentroEstoque);
        TransfEstoquePCPLinItem transfItem = null;
        TransferenciaCentroEstoque transfEst = null;
        ItemTransfCentroEstoque item = null;
        GradeItemTransfCentroEstoque grade = null;
        for (TransfEstoquePCPLinItem aux : itens) {
            if (!this.isEquals(aux.getCentroEstoqueOrin(), origem)) continue;
            transfItem = aux;
            transfEst = aux.getTransferenciaCentroEst();
            block1: for (ItemTransfCentroEstoque itensTransf : aux.getTransferenciaCentroEst().getItemTransfCentroEstoque()) {
                if (!this.isEquals(itensTransf.getProduto(), gc.getProdutoGrade().getProduto())) continue;
                item = itensTransf;
                for (GradeItemTransfCentroEstoque gr : itensTransf.getGradeItemTransCentroEst()) {
                    if (!this.isEquals(gr.getGradeCor(), gc) || !this.isNotNull(gr.getLoteFabricacao()).booleanValue() || !this.isEquals(gr.getLoteFabricacao().getIdentificador(), idLoteFab)) continue;
                    grade = gr;
                    continue block1;
                }
            }
        }
        if (this.isNull(transfItem).booleanValue()) {
            transfItem = this.buildTransfEstoquePCPLinItem(reserva, origem);
            itens.add(transfItem);
        }
        if (this.isNull(transfEst).booleanValue()) {
            transfEst = this.buildTransferenciaCentroEstoque(reserva, origem, emp);
            transfItem.setTransferenciaCentroEst(transfEst);
        }
        if (this.isNull(item).booleanValue()) {
            item = this.buildItemTransfCentroEstoque(reserva, origem, gc, transfEst);
            transfEst.getItemTransfCentroEstoque().add(item);
        }
        if (this.isNull(grade).booleanValue()) {
            grade = this.buildGradeItemTransfCentroEstoque(transfEst, item, gc);
            item.getGradeItemTransCentroEst().add(grade);
        }
        transfItem.setTransfEstoquePCPLin(transf);
        grade.setLoteFabricacao((LoteFabricacao)this.serviceLoteFabricacao.get(idLoteFab));
        grade.setQuantidade(qtd);
    }

    private TransfEstoquePCPLinItem buildTransfEstoquePCPLinItem(CentroEstoque reserva, CentroEstoque origem) {
        TransfEstoquePCPLinItem transfItem = new TransfEstoquePCPLinItem();
        transfItem.setCentroEstoqueDest(reserva);
        transfItem.setCentroEstoqueOrin(origem);
        return transfItem;
    }

    private TransferenciaCentroEstoque buildTransferenciaCentroEstoque(CentroEstoque reserva, CentroEstoque origem, Empresa empresa) {
        TransferenciaCentroEstoque transfEst = new TransferenciaCentroEstoque();
        transfEst.setDataCadastro(new Date());
        transfEst.setDataTransferencia(new Date());
        transfEst.setDestino(reserva);
        transfEst.setOrigem(origem);
        transfEst.setEmpresa(empresa);
        transfEst.setItemTransfCentroEstoque(new ArrayList());
        return transfEst;
    }

    private ItemTransfCentroEstoque buildItemTransfCentroEstoque(CentroEstoque reserva, CentroEstoque origem, GradeCor gc, TransferenciaCentroEstoque transfEst) {
        ItemTransfCentroEstoque item = new ItemTransfCentroEstoque();
        item.setDestino(reserva);
        item.setOrigem(origem);
        item.setProduto(gc.getProdutoGrade().getProduto());
        item.setTransfCentroEstoque(transfEst);
        item.setGradeItemTransCentroEst(new ArrayList());
        return item;
    }

    private GradeItemTransfCentroEstoque buildGradeItemTransfCentroEstoque(TransferenciaCentroEstoque transfEst, ItemTransfCentroEstoque item, GradeCor gc) {
        GradeItemTransfCentroEstoque grade = new GradeItemTransfCentroEstoque();
        grade.setDataTransferencia(transfEst.getDataTransferencia());
        grade.setGradeCor(gc);
        grade.setItemTransfCentroEst(item);
        grade.setOrigem(item.getOrigem());
        grade.setDestino(item.getDestino());
        grade.setEmpresa(transfEst.getEmpresa());
        return grade;
    }

    private void atualizaTotalizadores(List<TransfEstoquePCPLinItem> itens) {
        if (TMethods.isWithData(itens)) {
            for (TransfEstoquePCPLinItem aux : itens) {
                if (!TMethods.isNotNull((Object)aux.getTransferenciaCentroEst()).booleanValue() || !TMethods.isWithData((Collection)aux.getTransferenciaCentroEst().getItemTransfCentroEstoque())) continue;
                for (ItemTransfCentroEstoque itensTransf : aux.getTransferenciaCentroEst().getItemTransfCentroEstoque()) {
                    double qtdTotal = 0.0;
                    for (GradeItemTransfCentroEstoque gr : itensTransf.getGradeItemTransCentroEst()) {
                        qtdTotal += gr.getQuantidade().doubleValue();
                    }
                    itensTransf.setQuantidadeTotal(Double.valueOf(qtdTotal));
                }
            }
        }
    }
}

