/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.transportador;

import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.TransportadorPraca;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoTransportadorImpl;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.touchvomodel.vo.pessoa.DTOPessoaRes;
import com.touchcomp.touchvomodel.vo.transportador.DTOTransportador;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTransportadorImpl
extends ServiceGenericEntityImpl<Transportador, Long, DaoTransportadorImpl> {
    @Autowired
    private ServicePessoaImpl servicePessoa;
    @Autowired
    private ServiceUnidadeFederativaImpl serviceUF;
    @Autowired
    private HelperPessoa helperPessoa;

    @Autowired
    public ServiceTransportadorImpl(DaoTransportadorImpl genericDao) {
        super(genericDao);
    }

    @Override
    public Transportador beforeSave(Transportador vo) {
        if (this.isNotNull(vo.getObservacaoFaturamento()).booleanValue()) {
            vo.getObservacaoFaturamento().forEach(i -> i.setTransportador(vo));
        }
        if (this.isNotNull(vo.getPraca()).booleanValue()) {
            vo.getPraca().forEach(i -> i.setTransportador(vo));
        }
        return vo;
    }

    public Transportador findByCNPJ(String cnpj) {
        return ((DaoTransportadorImpl)this.getDao()).findByCNPJ(cnpj);
    }

    public Transportador findByCNPJAtivo(String cnpj) {
        return ((DaoTransportadorImpl)this.getDao()).findByCNPJAtivo(cnpj);
    }

    public Transportador findByPessoa(Pessoa pessoa) {
        return ((DaoTransportadorImpl)this.getDao()).findByPessoa(pessoa);
    }

    public DTOPessoaRes validarPessoa(Long identificador) throws ExceptionObjNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        Pessoa pessoa = (Pessoa)this.servicePessoa.getOrThrow(identificador);
        if (this.isNotNull(pessoa).booleanValue()) {
            Transportador aux = this.findByPessoa(pessoa);
            if (this.isNotNull(aux).booleanValue()) {
                throw new ExceptionValidacaoDados("E.ERP.0068.001", new Object[0]);
            }
            pessoa = this.helperPessoa.validarPessoa(pessoa);
            return this.buildToDTOGeneric(pessoa, DTOPessoaRes.class);
        }
        return null;
    }

    public DTOTransportador.DTOTransportadorPraca novaPracaTransportador(Long identificador) throws ExceptionObjNotFound {
        UnidadeFederativa uf = (UnidadeFederativa)this.serviceUF.getOrThrow(identificador);
        if (this.isNotNull(uf).booleanValue()) {
            TransportadorPraca vo = new TransportadorPraca();
            vo.setUf(uf);
            return this.buildToDTOGeneric(vo, DTOTransportador.DTOTransportadorPraca.class);
        }
        return null;
    }
}

