/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.unidadefatcliente;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.impl.DaoUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceUnidadeFatCliente;
import com.touchcomp.touchvomodel.res.DTOUnidadeFatClienteRes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceUnidadeFatClienteImpl
extends ServiceGenericEntityImpl<UnidadeFatCliente, Long, DaoUnidadeFatClienteImpl>
implements ServiceUnidadeFatCliente {
    @Autowired
    public ServiceUnidadeFatClienteImpl(DaoUnidadeFatClienteImpl genericDao) {
        super(genericDao);
    }

    @Override
    public UnidadeFatCliente beforeSave(UnidadeFatCliente vo) {
        if (ServiceUnidadeFatClienteImpl.isWithData(vo.getTalhoes())) {
            vo.getTalhoes().forEach(i -> i.setUnidadeFatCliente(vo));
        }
        return vo;
    }

    @Override
    public UnidadeFatCliente findFirstClienteAtivoPorUF(UnidadeFederativa uf) {
        return ((DaoUnidadeFatClienteImpl)this.getGenericDao()).findFirstClienteAtivoPorUF(uf);
    }

    @Override
    public UnidadeFatCliente findUnidadeFatByCpfCnpj(String cpfCnpj) {
        return ((DaoUnidadeFatClienteImpl)this.getGenericDao()).getCNPJ(cpfCnpj);
    }

    public UnidadeFatCliente getCNPJInscEst(String cpfCnpj, String inscEst) {
        return ((DaoUnidadeFatClienteImpl)this.getDao()).getCNPJInscEst(cpfCnpj, inscEst);
    }

    public UnidadeFatCliente getCNPJInscEstAtivo(String cpfCnpj, String inscEst) {
        return ((DaoUnidadeFatClienteImpl)this.getDao()).getCNPJInscEstAtivo(cpfCnpj, inscEst);
    }

    public UnidadeFatCliente findFirstUnidFatClientePorCliente(Cliente cliente) {
        return ((DaoUnidadeFatClienteImpl)this.getDao()).findFirstUnidFatClientePorCliente(cliente);
    }

    @Override
    public UnidadeFatCliente findUnidadeFatByPessoa(Pessoa pessoa) {
        return ((DaoUnidadeFatClienteImpl)this.getDao()).findUnidadeFatByPessoa(pessoa);
    }

    public UnidadeFatCliente getUnidFatTomadorTransp(String cnpj, String inscEst, String cep) {
        UnidadeFatCliente unid = ((DaoUnidadeFatClienteImpl)this.getDao()).getByCnpjCepAtiva(cnpj, cep);
        if (unid != null) {
            return unid;
        }
        unid = ((DaoUnidadeFatClienteImpl)this.getDao()).getByCnpjRaizCepAtiva(cnpj, cep);
        if (unid != null) {
            return unid;
        }
        unid = this.getCNPJInscEstAtivo(cnpj, inscEst);
        if (unid != null) {
            return unid;
        }
        unid = ((DaoUnidadeFatClienteImpl)this.getDao()).getByCnpjUnidPadraoAtiva(cnpj, cep);
        if (unid != null) {
            return unid;
        }
        return null;
    }

    public List<UnidadeFatCliente> getAltCriados(Date lastDateSync) {
        return ((DaoUnidadeFatClienteImpl)this.getDao()).getAltCriados(lastDateSync);
    }

    public List<DTOUnidadeFatClienteRes> findByDescricao(String descricao) {
        if (descricao == null || descricao.isEmpty()) {
            return new ArrayList<DTOUnidadeFatClienteRes>();
        }
        if (descricao.length() < 3) {
            return new ArrayList<DTOUnidadeFatClienteRes>();
        }
        return ((DaoUnidadeFatClienteImpl)this.getDao()).findByDescricao(descricao);
    }
}

