/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.usuario;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.vo.ConexaoUsuario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.LogConexaoUsuario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.impl.DaoUsuarioConectadoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceLogConexaoUsuarioImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceConexaoUsuarioImpl
extends ServiceGenericEntityImpl<ConexaoUsuario, Long, DaoUsuarioConectadoImpl> {
    private final ServiceLogConexaoUsuarioImpl serviceLogConexao;

    @Autowired
    public ServiceConexaoUsuarioImpl(DaoUsuarioConectadoImpl genericDao, ServiceLogConexaoUsuarioImpl serviceLogConexao) {
        super(genericDao);
        this.serviceLogConexao = serviceLogConexao;
    }

    public ConexaoUsuario registraLogin(Usuario user, Empresa emp, Grupo grupo, GrupoEmpresa grEmp, String token, Date expirationDate, EnumConstTipoSistemasTouch tipoSistema) {
        List<ConexaoUsuario> aux = ((DaoUsuarioConectadoImpl)this.getDao()).getByUser(user, tipoSistema);
        ConexaoUsuario usu = null;
        if (!aux.isEmpty()) {
            usu = aux.remove(0);
            this.logout(aux, false);
        }
        if (usu != null && TMethods.isEquals((Object)token, (Object)usu.getToken())) {
            return usu;
        }
        usu = new ConexaoUsuario();
        usu.setDataConexao(new Date());
        usu.setEmpresa(emp);
        usu.setGrupo(grupo);
        usu.setGrupoEmpresa(grEmp);
        usu.setTipoSistema(Integer.valueOf(32));
        usu.setToken(token);
        usu.setUsuario(user);
        return this.saveOrUpdate(usu);
    }

    public void logout(Usuario user, EnumConstTipoSistemasTouch tipo) {
        List<ConexaoUsuario> aux = ((DaoUsuarioConectadoImpl)this.getDao()).getByUser(user, tipo);
        if (!aux.isEmpty()) {
            this.logout(aux, false);
        }
    }

    public void logout(List<ConexaoUsuario> data, boolean logoutTimeout) {
        for (ConexaoUsuario conexaoUsuario : data) {
            LogConexaoUsuario l = new LogConexaoUsuario();
            l.setDataLogin(conexaoUsuario.getDataConexao());
            l.setDataLogout(new Date());
            l.setEmpresa(conexaoUsuario.getEmpresa());
            l.setUsuario(conexaoUsuario.getUsuario());
            l.setEmpresa(conexaoUsuario.getEmpresa());
            l.setGrupoEmpresa(conexaoUsuario.getGrupoEmpresa());
            l.setGrupoUsuarios(conexaoUsuario.getGrupo());
            l.setHorasConectado(TDate.calcularDifHoras((Date)l.getDataLogin(), (Date)l.getDataLogout()));
            this.serviceLogConexao.saveOrUpdate(l);
            this.deleteCollection(data);
        }
    }

    public void logoutUsuariosPendentes() {
        List<ConexaoUsuario> aux = ((DaoUsuarioConectadoImpl)this.getDao()).getConexaoUsuariosPendentes();
        this.logout(aux, true);
    }
}

