/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.usuario;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoUsuarioImpl;
import com.touchcomp.basementorservice.helpers.impl.usuariobasico.HelperUsuarioBasico;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.usuariobasico.ServiceUsuarioBasicoImpl;
import com.touchcomp.touchvomodel.vo.usuario.web.DTOUsuarioRes;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceUsuarioImpl
extends ServiceGenericEntityImpl<Usuario, Long, DaoUsuarioImpl> {
    ServiceUsuarioBasicoImpl serviceUsuarioBasico;

    @Autowired
    public ServiceUsuarioImpl(DaoUsuarioImpl genericDao, ServiceUsuarioBasicoImpl serviceUsuarioBasico) {
        super(genericDao);
        this.serviceUsuarioBasico = serviceUsuarioBasico;
    }

    public List<Usuario> getUsuarios(Long idGrupo) {
        return ((DaoUsuarioImpl)this.getDao()).getUsuarios(idGrupo);
    }

    public List<Usuario> getUsuariosAtivos() {
        return ((DaoUsuarioImpl)this.getDao()).getUsuariosAtivos();
    }

    public List<Usuario> getUsuarioRepresentanteAtivoByEmpresa(Empresa emp) {
        return ((DaoUsuarioImpl)this.getDao()).getUsuarioRepresentanteAtivoByEmpresa(emp);
    }

    public List<Usuario> getUsuariosAtivosBySetor(SetorUsuario s) {
        return ((DaoUsuarioImpl)this.getDao()).getUsuariosAtivosBySetor(s);
    }

    public Usuario getByLogin(String user) {
        return ((DaoUsuarioImpl)this.getDao()).findByLogin(user);
    }

    @Override
    public Usuario beforeSaveEntity(Usuario aux) {
        return aux;
    }

    @Override
    public Usuario saveOrUpdate(Usuario entity) {
        entity.setUsuarioBasico(this.serviceUsuarioBasico.saveOrUpdate(entity.getUsuarioBasico()));
        return super.saveOrUpdate(entity);
    }

    public Usuario saveOrUpdateSemSalvarPessoa(Usuario entity) {
        entity.setUsuarioBasico(this.serviceUsuarioBasico.saveOrUpdateSemSalvarPessoa(entity.getUsuarioBasico()));
        return super.saveOrUpdate(entity);
    }

    public Usuario getBasicAuth(String userName, String pass) throws ExceptionObjNotFound, NoSuchAlgorithmException {
        Usuario user = this.getByLogin(userName = String.valueOf(userName).toUpperCase());
        if (user == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.000001", new String[]{userName}));
        }
        if (!HelperUsuarioBasico.validadePassword(pass, user.getUsuarioBasico().getLogin().getSenha())) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.000001", new String[]{userName}));
        }
        return user;
    }

    public List<Usuario> getUsuarioNodo(List<Nodo> listNodo) {
        return ((DaoUsuarioImpl)this.getDao()).getUsuarioNodo(listNodo);
    }

    public DTOUsuarioRes getDTOUsuario(Long idUsuario) throws ExceptionObjNotFound {
        Usuario usuario = (Usuario)this.getOrThrow(idUsuario);
        if (usuario != null) {
            DTOUsuarioRes dto = new DTOUsuarioRes();
            dto.setIdentificador(usuario.getIdentificador());
            dto.setPessoaNome(usuario.getUsuarioBasico().getPessoa().getNome());
            return dto;
        }
        return null;
    }

    public Usuario getEager(Long idUsuario) {
        Usuario user = (Usuario)((DaoUsuarioImpl)this.getDao()).get(idUsuario);
        if (user != null) {
            user.getUsuarioConfiguracoes().getIdentificador();
            user.getUsuarioBasico().getPessoa().getEndereco();
            user.getUsuarioBasico().getPessoa().getComplemento();
            return user;
        }
        return null;
    }

    @Override
    public Usuario get(UsuarioBasico ub) {
        return ((DaoUsuarioImpl)this.getDao()).get(ub);
    }

    @Override
    public Usuario get(Pessoa pessoa) {
        return ((DaoUsuarioImpl)this.getDao()).get(pessoa);
    }

    public List<Map<String, Object>> getIdsUsuariosAtivos() {
        return ((DaoUsuarioImpl)this.getDao()).getIdsUsuariosAtivos();
    }
}

