/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.usuariobasico;

import com.touchcomp.basementor.model.vo.Login;
import com.touchcomp.basementor.model.vo.OpcoesSistLogin;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioEmpresa;
import com.touchcomp.basementor.rules.usuariobasico.CompUsuarioBasico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoUsuarioBasicoImpl;
import com.touchcomp.basementorservice.helpers.impl.usuariobasico.HelperUsuarioBasico;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.login.ServiceLoginImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidExtraData;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.touchvomodel.vo.grupo.web.DTOGrupo;
import com.touchcomp.touchvomodel.vo.usuariobasico.web.DTOUsuarioBasicoSimple;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceUsuarioBasicoImpl
extends ServiceGenericEntityImpl<UsuarioBasico, Long, DaoUsuarioBasicoImpl>
implements ValidExtraData<Login> {
    ServiceLoginImpl serviceLoginImpl;
    ServicePessoaImpl servicePessoa;
    CompUsuarioBasico compUsuarioBasico;

    public ServiceUsuarioBasicoImpl(ServiceLoginImpl serviceLoginImpl, ServicePessoaImpl servicePessoa, CompUsuarioBasico compUsuarioBasico, DaoUsuarioBasicoImpl genericDao) {
        super(genericDao);
        this.serviceLoginImpl = serviceLoginImpl;
        this.servicePessoa = servicePessoa;
        this.compUsuarioBasico = compUsuarioBasico;
    }

    public List<UsuarioBasico> getUsuarios(Long idGrupo) {
        return ((DaoUsuarioBasicoImpl)this.getDao()).getUsuarios(idGrupo);
    }

    public List<DTOGrupo.DTOUsuario> getUsuariosDTO(Long idGrupo) {
        if (!TMethods.isWithData((Number)idGrupo)) {
            return new LinkedList<DTOGrupo.DTOUsuario>();
        }
        return this.buildToDTOGeneric(this.getUsuarios(idGrupo), DTOGrupo.DTOUsuario.class);
    }

    public UsuarioBasico getUsuarioByEmailCpfCnpj(String email, String cpfCnpj) {
        return ((DaoUsuarioBasicoImpl)this.getDao()).getUsuarioByEmailCpfCnpj(email, cpfCnpj);
    }

    public boolean existeEmailAtivoMaisUsuario() {
        return ((DaoUsuarioBasicoImpl)this.getDao()).existeEmailAtivoMaisUsuario();
    }

    public UsuarioBasico getUsuarioByLogin(String login) {
        return ((DaoUsuarioBasicoImpl)this.getDao()).getUsuarioByLogin(login);
    }

    @Override
    public UsuarioBasico beforeSaveEntity(UsuarioBasico aux) {
        if (aux.getLogin() != null) {
            aux.getLogin().setLogin(String.valueOf(aux.getLogin().getLogin()).toUpperCase());
            aux.getLogin().setUsuarioBasico(aux);
        }
        for (UsuarioEmpresa uemp : aux.getEmpresas()) {
            uemp.setUsuarioBasico(aux);
        }
        aux.getLogin().setSenha(HelperUsuarioBasico.encrypt(aux.getLogin().getSenha()));
        return aux;
    }

    @Override
    public UsuarioBasico saveOrUpdateOnly(UsuarioBasico entity) {
        entity.setLogin(this.serviceLoginImpl.saveOrUpdate(entity.getLogin()));
        entity.setPessoa(this.servicePessoa.saveOrUpdate(entity.getPessoa()));
        return super.saveOrUpdateOnly(entity);
    }

    public UsuarioBasico saveOrUpdateSemSalvarPessoa(UsuarioBasico entity) {
        return super.saveOrUpdateOnly(entity);
    }

    public String getSecretKey(String username) throws ExceptionInvalidData {
        UsuarioBasico ub = this.getUsuarioByLogin(username);
        if (ub == null) {
            throw new ExceptionInvalidData("", new Object[0]);
        }
        return ub.getLogin().getChaveGoogleAuthenticator();
    }

    public void saveSecretKey(String userName, String secretKey) throws ExceptionInvalidData {
        UsuarioBasico ub = this.getUsuarioByLogin(userName);
        if (ub == null) {
            throw new ExceptionInvalidData("E.ERP.1945.001", new Object[0]);
        }
        ub.getLogin().setChaveGoogleAuthenticator(secretKey);
        this.saveOrUpdate(ub);
    }

    public DTOUsuarioBasicoSimple atualizarPerfilUsuario(DTOUsuarioBasicoSimple data) throws ExceptionInvalidData {
        UsuarioBasico ub = (UsuarioBasico)this.get(data.getIdentificador());
        if (ub == null) {
            throw new ExceptionInvalidData("E.ERP.1945.001", new Object[0]);
        }
        ub.setLogin(this.serviceLoginImpl.saveOrUpdate(data.getLogin(), ub.getLogin()));
        ub.setPessoa(this.servicePessoa.saveOrUpdate(data.getPessoa(), ub.getPessoa()));
        return this.buildToDTO(ub, DTOUsuarioBasicoSimple.class);
    }

    public UsuarioBasico getByLogin(String userName) {
        return ((DaoUsuarioBasicoImpl)this.getDao()).getByLogin(userName);
    }

    public UsuarioBasico getByPessoa(Pessoa pessoa) {
        return ((DaoUsuarioBasicoImpl)this.getDao()).getByPessoa(pessoa);
    }

    public UsuarioBasico getEager(Long idUsuario) {
        return ((DaoUsuarioBasicoImpl)this.getDao()).getEager(idUsuario);
    }

    public void valid(ValidGenericEntitiesImpl<Login> validador, Login vo) {
        OpcoesSistLogin opcoes = this.getSharedData().getOpcoesSistema().getOpcoesSistemaLogin();
        CompUsuarioBasico.PasswordCheckResult res = this.compUsuarioBasico.checkUserPassword(opcoes, vo.getSenha());
        if (!res.isIsPassed()) {
            String str = TMethods.toString((List)res.getMessages(), (String)"\n");
            validador.addError(new ValidMessages.Code("V.ERP.1945.008", "login", new Object[]{str}), (Object)vo);
        }
    }
}

