/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.verbasrescisorias;

import com.touchcomp.basementor.model.vo.LancamentoVerbasRescisorias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.VerbasRescisorias;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoVerbasRescisoriasImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculoevento.ServiceTipoCalculoEventoImpl;
import com.touchcomp.touchvomodel.vo.verbasrescisorias.web.DTOVerbasRescisorias;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceVerbasRescisoriasImpl
extends ServiceGenericEntityImpl<VerbasRescisorias, Long, DaoVerbasRescisoriasImpl> {
    ServiceTipoCalculoEventoImpl tipoCalculoEventoImpl;

    @Autowired
    public ServiceVerbasRescisoriasImpl(DaoVerbasRescisoriasImpl dao, ServiceTipoCalculoEventoImpl tipoCalculoEventoImpl) {
        super(dao);
        this.tipoCalculoEventoImpl = tipoCalculoEventoImpl;
    }

    public DTOVerbasRescisorias.DTOLancamentoVerbasRescisorias getNovoItemLancamento(Long idTipoCalculo) {
        TipoCalculoEvento tp = (TipoCalculoEvento)this.tipoCalculoEventoImpl.get(idTipoCalculo);
        if (this.isNull(tp).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0911.001", new Object[]{idTipoCalculo}));
        }
        DTOVerbasRescisorias.DTOLancamentoVerbasRescisorias item = new DTOVerbasRescisorias.DTOLancamentoVerbasRescisorias();
        item.setEvento(tp.getEvento().getDescricao());
        item.setEventoCodigo(tp.getEvento().getCodigo());
        item.setTipoEvento(tp.getEvento().getTipoEvento());
        item.setIncidenciaRecisaoIndenizado(tp.getIncidenciaRecisaoIndenizado());
        item.setIncidenciaRecisaoTrabalhado(tp.getIncidenciaRecisaoTrabalhado());
        item.setTpCalculoEventoIdentificador(tp.getIdentificador());
        return item;
    }

    @Override
    public VerbasRescisorias beforeSave(VerbasRescisorias vo) {
        for (LancamentoVerbasRescisorias lancamento : vo.getLancamentos()) {
            lancamento.setVerbaRecisoria(vo);
        }
        return vo;
    }
}

