/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.versaorepositoriobi;

import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.model.vo.LogAtualizacaoVersaoCli;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.VersaoRepositorioBI;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.dao.impl.DaoVersaoRepositorioBIImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.logatualizacaoversaocli.ServiceLogAtualizacaoVersaoCliImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceVersaoRepositorioBI;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOSolicitacaoBI;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceVersaoRepositorioBIImpl
extends ServiceGenericEntityImpl<VersaoRepositorioBI, Long, DaoVersaoRepositorioBIImpl>
implements ServiceVersaoRepositorioBI {
    @Autowired
    private ServiceLogAtualizacaoVersaoCliImpl serviceLogAtualizacaoCliente;

    @Autowired
    public ServiceVersaoRepositorioBIImpl(DaoVersaoRepositorioBIImpl genericDao) {
        super(genericDao);
    }

    @Override
    public VersaoRepositorioBI get(String serialBI, Long numeroVersaoRep, Long numeroVersao) {
        return ((DaoVersaoRepositorioBIImpl)this.getGenericDao()).get(serialBI, numeroVersaoRep, numeroVersao);
    }

    @Override
    public List<Map<String, Object>> getVersoesMap(Long idRepositorio, Integer nrVersaoEstruturaBI) {
        return ((DaoVersaoRepositorioBIImpl)this.getGenericDao()).getVersoesMap(idRepositorio, nrVersaoEstruturaBI);
    }

    @Override
    public List<Map<String, Object>> getRepositoriosAtivos() {
        return ((DaoVersaoRepositorioBIImpl)this.getGenericDao()).getRepositoriosAtivos();
    }

    public DTOVersaoBICompleto getVersaoBI(String serialBI, Long numeroVersaoRep, Long numeroVersao, String cnpj, EnumConstTipoRepositorioBI tipo) throws ExceptionInvalidData {
        VersaoRepositorioBI versao;
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        if (tipo == null) {
            tipo = EnumConstTipoRepositorioBI.BI;
        }
        if (TMethods.isNull((Object)(versao = ((DaoVersaoRepositorioBIImpl)this.getDao()).get(serialBI, numeroVersaoRep, numeroVersao, cnpj, tipo))).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0747.019", new Object[]{numeroVersaoRep, numeroVersao, serialBI});
        }
        return this.convert(versao);
    }

    public DTOVersaoBICompleto getVersaoBI(String serialBI, Long numeroVersaoRep, Long numeroVersao, String cnpj, String versaoSistema, EnumConstTipoRepositorioBI tipo) throws ExceptionInvalidData {
        VersaoRepositorioBI versao;
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        if (tipo == null) {
            tipo = EnumConstTipoRepositorioBI.BI;
        }
        versaoSistema = TString.onlyNumbers((String)versaoSistema);
        Long versaoSistemaL = null;
        if (TMethods.isStrWithData((String)versaoSistema)) {
            versaoSistemaL = Long.valueOf(versaoSistema);
        }
        if (TMethods.isNull((Object)(versao = ((DaoVersaoRepositorioBIImpl)this.getDao()).get(serialBI, numeroVersaoRep, numeroVersao, cnpj, tipo))).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0747.019", new Object[]{numeroVersaoRep, numeroVersao, serialBI});
        }
        if (versao != null && versao.getVersaoMinimaSistema() != null && versao.getVersaoMinimaSistema().getCodigo() > versaoSistemaL) {
            throw new ExceptionInvalidData("E.ERP.0747.002", new Object[]{versaoSistema, versao.getVersaoMinimaSistema().getCodigo()});
        }
        return this.convert(versao);
    }

    public DTOVersaoBICompleto getVersaoBI(String serialBI, Long numeroVersaoRep, Long numeroVersao) {
        VersaoRepositorioBI versao = ((DaoVersaoRepositorioBIImpl)this.getDao()).get(serialBI, numeroVersaoRep, numeroVersao);
        return this.convert(versao);
    }

    private DTOVersaoBICompleto convert(VersaoRepositorioBI versao) {
        DTOVersaoBICompleto dto = new DTOVersaoBICompleto();
        dto.setArquivoBI(new String(versao.getConteudoBI()));
        dto.setDescricao(versao.getRepositorioBI().getImportacaoBi().getObservacoes());
        dto.setNome(versao.getRepositorioBI().getImportacaoBi().getDescricao());
        dto.setNumeroBI(versao.getRepositorioBI().getImportacaoBi().getNumeroBI());
        dto.setNumeroControle(versao.getRepositorioBI().getImportacaoBi().getNumeroControle());
        dto.setNumeroVersao(versao.getNumeroVersao());
        dto.setNumeroVersaoRep(versao.getRepositorioBI().getNumeroVersao());
        dto.setSerialBI(versao.getRepositorioBI().getImportacaoBi().getSerialLocalBI());
        if (versao.getRepositorioBI().getImportacaoBi().getTipoClassificacaoBI() != null) {
            dto.setTipoClassificacaoBI(String.valueOf(versao.getRepositorioBI().getImportacaoBi().getTipoClassificacaoBI()));
        }
        return dto;
    }

    public DTOSolicitacaoBI getDTOSolicitacaoBI(String serialBI, Long numeroVersaoRep, Long numeroVersao, Short tipo, UsuarioBasico user) throws ExceptionInvalidData {
        VersaoRepositorioBI versao;
        this.reload(user);
        Long versaoSistema = 0L;
        LogAtualizacaoVersaoCli logAtualizacao = this.serviceLogAtualizacaoCliente.getUltimaAtualizacao(user);
        if (this.isNotNull(logAtualizacao).booleanValue()) {
            versaoSistema = logAtualizacao.getVersaoMentor().getCodigo();
        }
        if (TMethods.isNull((Object)(versao = ((DaoVersaoRepositorioBIImpl)this.getDao()).get(serialBI, numeroVersaoRep, numeroVersao, user.getPessoa().getComplemento().getCnpj(), EnumConstTipoRepositorioBI.get((Object)tipo)))).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0747.002", new Object[]{versaoSistema, ""});
        }
        if (versao != null && versao.getVersaoMinimaSistema() != null && versao.getVersaoMinimaSistema().getCodigo() > versaoSistema) {
            throw new ExceptionInvalidData("E.ERP.0747.002", new Object[]{versaoSistema, versao.getVersaoMinimaSistema().getCodigo()});
        }
        DTOSolicitacaoBI dto = new DTOSolicitacaoBI();
        dto.setNumeroVersao(numeroVersao);
        dto.setNumeroVersaoRep(numeroVersaoRep);
        dto.setSerialBI(serialBI);
        dto.setTipo(tipo);
        dto.setCnpjEmpresa(user.getPessoa().getComplemento().getCnpj());
        return dto;
    }

    public File getVersaoBIFile(String serialBI, Long numeroVersaoRep, Long numeroVersao, Short tipo, UsuarioBasico user) throws ExceptionInvalidData, ExceptionIO {
        EnumConstTipoRepositorioBI tipoRep = EnumConstTipoRepositorioBI.get((Object)tipo);
        VersaoRepositorioBI versao = this.getVersaoBIFileByte(serialBI, numeroVersaoRep, numeroVersao, tipoRep, user);
        File temp = ToolFile.createTempFile((String)ToolFile.getFileName((String)versao.getRepositorioBI().getImportacaoBi().getDescricao(), (String)tipoRep.getFileExtension()));
        ToolFile.writeBytesOnFile((File)temp, (byte[])versao.getConteudoBI());
        return temp;
    }

    private VersaoRepositorioBI getVersaoBIFileByte(String serialBI, Long numeroVersaoRep, Long numeroVersao, EnumConstTipoRepositorioBI tipo, UsuarioBasico user) throws ExceptionInvalidData, ExceptionIO {
        VersaoRepositorioBI versao;
        this.reload(user);
        Long versaoSistema = 0L;
        LogAtualizacaoVersaoCli logAtualizacao = this.serviceLogAtualizacaoCliente.getUltimaAtualizacao(user);
        if (this.isNotNull(logAtualizacao).booleanValue()) {
            versaoSistema = logAtualizacao.getVersaoMentor().getCodigo();
        }
        if ((versao = ((DaoVersaoRepositorioBIImpl)this.getDao()).get(serialBI, numeroVersaoRep, numeroVersao, user.getPessoa().getComplemento().getCnpj(), tipo)) == null) {
            throw new ExceptionInvalidData("E.ERP.0747.002", new Object[]{versaoSistema, ""});
        }
        if (versao.getVersaoMinimaSistema() != null && versao.getVersaoMinimaSistema().getCodigo() > versaoSistema) {
            throw new ExceptionInvalidData("E.ERP.0747.002", new Object[]{versaoSistema, versao.getVersaoMinimaSistema().getCodigo()});
        }
        return versao;
    }

    public File getVersaoBIFileXML(String serialBI, Long numeroVersaoRep, Long numeroVersao, Short tipo, UsuarioBasico user) throws ExceptionBase {
        EnumConstTipoRepositorioBI tipoRep = EnumConstTipoRepositorioBI.get((Object)tipo);
        VersaoRepositorioBI versao = this.getVersaoBIFileByte(serialBI, numeroVersaoRep, numeroVersao, tipoRep, user);
        File temp = ToolFile.createTempFile((String)ToolFile.getFileName((String)versao.getRepositorioBI().getImportacaoBi().getDescricao(), (String)tipoRep.getFileExtension()));
        byte[] data = ToolHexString.decodeToByte((String)new String(versao.getConteudoBI()));
        ToolFile.writeBytesOnFile((File)temp, (byte[])data);
        return temp;
    }
}

