/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.websocketmessage;

import com.touchcomp.basementor.constants.enums.websocket.EnumConstStatusMessageWebSocket;
import com.touchcomp.basementor.model.vo.WebSocketMessage;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorservice.dao.impl.DaoWebSocketMessageImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWebSocketMessageImpl
extends ServiceGenericEntityImpl<WebSocketMessage, Long, DaoWebSocketMessageImpl> {
    @Autowired
    public ServiceWebSocketMessageImpl(DaoWebSocketMessageImpl genericDao) {
        super(genericDao);
    }

    public void setStatus(String uid, EnumConstStatusMessageWebSocket status, String observacoes) {
        try {
            WebSocketMessage message;
            if (TMethods.isStrWithData((String)uid) && TMethods.isNotNull((Object)status).booleanValue() && TMethods.isNotNull((Object)(message = ((DaoWebSocketMessageImpl)this.getDao()).getByUid(uid))).booleanValue()) {
                message.setStatus(status.getValue());
                message.setObservacoes(observacoes);
                this.saveOrUpdate(message);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getMessage());
        }
    }

    public void confirmarRecebimento(String uid) {
        try {
            this.setStatus(uid, EnumConstStatusMessageWebSocket.RECEBIDO, null);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getMessage());
        }
    }

    public void confirmarProcessamento(String uid) {
        try {
            this.setStatus(uid, EnumConstStatusMessageWebSocket.PROCESSADO, null);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getMessage());
        }
    }

    public void falhaProcessamento(String uid, String observacoes) {
        try {
            this.setStatus(uid, EnumConstStatusMessageWebSocket.FALHA_PROCESSAMENTO, observacoes);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getMessage());
        }
    }

    public List<WebSocketMessage> listMessagesToResend(Integer maxTentativasEnvio, Integer tempoReenvio, String canal) {
        return ((DaoWebSocketMessageImpl)this.getGenericDao()).listMessagesToResend(maxTentativasEnvio, tempoReenvio, canal);
    }

    public Integer deleteOldMessages(Integer days) {
        return ((DaoWebSocketMessageImpl)this.getGenericDao()).deleteOldMessages(days);
    }

    public Integer updateMessagesTentativasExc(Integer maxTentativas) {
        return ((DaoWebSocketMessageImpl)this.getGenericDao()).updateMessagesTentativasExc(maxTentativas);
    }
}

