/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmscadastroendereco;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.WmsCadastroEndereco;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsEnderecoGradeCor;
import com.touchcomp.basementorservice.dao.impl.DaoWmsCadastroEnderecoImpl;
import com.touchcomp.basementorservice.helpers.impl.wmscadastroendereco.HelperWmsCadastroEndereco;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.cadastroenderecowms.web.DTOWmsCadastroEndereco;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsCadastroEnderecoImpl
extends ServiceGenericEntityImpl<WmsCadastroEndereco, Long, DaoWmsCadastroEnderecoImpl> {
    ServiceEmpresaImpl serviceEmpresaImpl;
    HelperWmsCadastroEndereco helperWmsCadastroEndereco;
    ServiceCentroEstoqueImpl serviceCentroEst;
    ServiceGradeCorImpl serviceGradeCor;

    @Autowired
    public ServiceWmsCadastroEnderecoImpl(DaoWmsCadastroEnderecoImpl dao, ServiceEmpresaImpl serviceEmpresaImpl, HelperWmsCadastroEndereco helperWmsCadastroEndereco, ServiceCentroEstoqueImpl serviceCentroEst, ServiceGradeCorImpl serviceGradeCor) {
        super(dao);
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.helperWmsCadastroEndereco = helperWmsCadastroEndereco;
        this.serviceGradeCor = serviceGradeCor;
        this.serviceCentroEst = serviceCentroEst;
    }

    @Override
    public WmsCadastroEndereco get(Empresa emp) {
        return ((DaoWmsCadastroEnderecoImpl)this.getGenericDao()).get(emp);
    }

    @Override
    public WmsCadastroEndereco beforeSave(WmsCadastroEndereco aux) {
        long nrNiveis = this.helperWmsCadastroEndereco.getNrNiveis(this.getSharedData().getWmsOpcoes(aux.getEmpresa()).getMascara());
        aux.getEnderecoPrincipal().setEmpresa(aux.getEmpresa());
        aux.getEnderecoPrincipal().setCentroEstoque(aux.getCentroEstoque());
        this.setFather(aux.getEnderecoPrincipal(), nrNiveis, 1);
        return super.beforeSave(aux);
    }

    private void setFather(WmsEndereco enderecoPrincipal, long nrNiveis, int currentNivel) {
        enderecoPrincipal.setNivel(Short.valueOf((short)currentNivel));
        this.helperWmsCadastroEndereco.defineSinteticoAnalitico(enderecoPrincipal, nrNiveis);
        double pesoT = 0.0;
        double volumeT = 0.0;
        for (WmsEndereco wo : enderecoPrincipal.getChildren()) {
            wo.setEnderecoPai(enderecoPrincipal);
            wo.setEmpresa(enderecoPrincipal.getEmpresa());
            wo.setCentroEstoque(enderecoPrincipal.getCentroEstoque());
            if (wo.getCentroEstoqueSaida() == null) {
                wo.setCentroEstoqueSaida(enderecoPrincipal.getCentroEstoqueSaida());
            }
            this.setFather(wo, nrNiveis, currentNivel + 1);
            for (WmsEnderecoGradeCor gc : wo.getGradesCores()) {
                gc.setWmsEndereco(wo);
            }
            enderecoPrincipal.setPeso(Double.valueOf(enderecoPrincipal.getPeso() + wo.getPeso()));
            enderecoPrincipal.setVolume(Double.valueOf(enderecoPrincipal.getVolume() + wo.getVolume()));
            pesoT += wo.getPeso().doubleValue();
            volumeT += wo.getVolume().doubleValue();
        }
        if (this.isEquals(enderecoPrincipal.getSinteticoAnalitico(), EnumConstSinteticoAnalitico.SINTETICO.getValue())) {
            enderecoPrincipal.setPeso(Double.valueOf(pesoT));
            enderecoPrincipal.setVolume(Double.valueOf(volumeT));
        }
    }

    @Override
    public <S> WmsCadastroEndereco buildToEntity(S data) {
        DTOWmsCadastroEndereco cas = (DTOWmsCadastroEndereco)data;
        WmsCadastroEndereco w = new WmsCadastroEndereco();
        w.setDataAtualizacao(cas.getDataAtualizacao());
        w.setDataCadastro(cas.getDataCadastro());
        w.setEmpresa((Empresa)this.serviceEmpresaImpl.get(cas.getEmpresaIdentificador()));
        w.setCentroEstoque((CentroEstoque)this.serviceCentroEst.get(cas.getCentroEstoqueIdentificador()));
        w.setIdentificador(cas.getIdentificador());
        w.setEnderecoPrincipal(this.getEndereco(cas.getEnderecoPrincipal()));
        w.setModoExibicaoEndereco(cas.getModoExibicaoEndereco());
        return w;
    }

    private WmsEndereco getEndereco(DTOWmsCadastroEndereco.DTOWmsEndereco e) {
        WmsEndereco w = new WmsEndereco();
        w.setCentroEstoque((CentroEstoque)this.serviceCentroEst.get(e.getCentroEstoqueIdentificador()));
        w.setCentroEstoqueSaida((CentroEstoque)this.serviceCentroEst.get(e.getCentroEstoqueSaidaIdentificador()));
        w.setChildren(this.getChildren(e.getChildren()));
        w.setCodigo(e.getCodigo());
        w.setCodigoMascara(e.getCodigoMascara());
        w.setDescricao(e.getDescricao());
        w.setGradesCores(this.getGrades(e.getGradesCores()));
        w.setIdentificador(e.getIdentificador());
        w.setIndisponivel(e.getIndisponivel());
        w.setNivel(e.getNivel());
        w.setSinteticoAnalitico(e.getSinteticoAnalitico());
        w.setPeso(e.getPeso());
        w.setVolume(e.getVolume());
        return w;
    }

    private List<WmsEnderecoGradeCor> getGrades(List<DTOWmsCadastroEndereco.DTOGradeCor> gradesCores) {
        LinkedList<WmsEnderecoGradeCor> a = new LinkedList<WmsEnderecoGradeCor>();
        if (gradesCores == null) {
            return a;
        }
        for (DTOWmsCadastroEndereco.DTOGradeCor gc : gradesCores) {
            WmsEnderecoGradeCor we = new WmsEnderecoGradeCor();
            we.setGradeCor((GradeCor)this.serviceGradeCor.get(gc.getGradeCorIdentificador()));
            we.setIdentificador(gc.getIdentificador());
            a.add(we);
        }
        return a;
    }

    private List<WmsEndereco> getChildren(List<DTOWmsCadastroEndereco.DTOWmsEndereco> children) {
        LinkedList<WmsEndereco> a = new LinkedList<WmsEndereco>();
        for (DTOWmsCadastroEndereco.DTOWmsEndereco dto : children) {
            a.add(this.getEndereco(dto));
        }
        return a;
    }

    @Override
    public <S> S buildToDTO(WmsCadastroEndereco aux, Class<S> classTo) {
        DTOWmsCadastroEndereco w = new DTOWmsCadastroEndereco();
        w.setDataAtualizacao(aux.getDataAtualizacao());
        w.setDataCadastro(aux.getDataCadastro());
        w.setEmpresaIdentificador(aux.getEmpresa().getIdentificador());
        w.setIdentificador(aux.getIdentificador());
        if (aux.getCentroEstoque() != null) {
            w.setCentroEstoqueIdentificador(aux.getCentroEstoque().getIdentificador());
            w.setCentroEstoque(aux.getCentroEstoque().toString());
        }
        w.setEnderecoPrincipal(this.getEndereco(aux.getEnderecoPrincipal()));
        if (w.getEnderecoPrincipal() != null) {
            w.getEnderecoPrincipal().setWmsCadastroEnderecoIdentificador(w.getIdentificador());
        }
        w.setModoExibicaoEndereco(aux.getModoExibicaoEndereco());
        return (S)w;
    }

    private DTOWmsCadastroEndereco.DTOWmsEndereco getEndereco(WmsEndereco e) {
        if (e == null) {
            return null;
        }
        DTOWmsCadastroEndereco.DTOWmsEndereco w = new DTOWmsCadastroEndereco.DTOWmsEndereco();
        if (e.getCentroEstoque() != null) {
            w.setCentroEstoque(e.getCentroEstoque().toString());
            w.setCentroEstoqueIdentificador(e.getCentroEstoque().getIdentificador());
        }
        if (e.getCentroEstoqueSaida() != null) {
            w.setCentroEstoqueSaida(e.getCentroEstoqueSaida().toString());
            w.setCentroEstoqueSaidaIdentificador(e.getCentroEstoqueSaida().getIdentificador());
        }
        if (e.getEnderecoPai() != null) {
            w.setEnderecoPaiIdentificador(e.getEnderecoPai().getIdentificador());
        }
        w.setChildren(this.getChildrenDTO(e.getChildren()));
        w.setCodigo(e.getCodigo());
        w.setCodigoMascara(e.getCodigoMascara());
        w.setDescricao(e.getDescricao());
        w.setIdentificador(e.getIdentificador());
        w.setIndisponivel(e.getIndisponivel());
        w.setNivel(e.getNivel());
        w.setSinteticoAnalitico(e.getSinteticoAnalitico());
        w.setPeso(e.getPeso());
        w.setVolume(e.getVolume());
        w.setDistancia(e.getDistancia());
        w.setGradesCores(this.getGradesDTO(e.getGradesCores()));
        return w;
    }

    private List<DTOWmsCadastroEndereco.DTOWmsEndereco> getChildrenDTO(List<WmsEndereco> children) {
        LinkedList<DTOWmsCadastroEndereco.DTOWmsEndereco> a = new LinkedList<DTOWmsCadastroEndereco.DTOWmsEndereco>();
        for (WmsEndereco dto : children) {
            a.add(this.getEndereco(dto));
        }
        Collections.sort(a, (c1, c2) -> Long.valueOf(ToolString.onlyNumbers((String)c1.getCodigo())).compareTo(Long.valueOf(ToolString.onlyNumbers((String)c2.getCodigo()))));
        return a;
    }

    private List<DTOWmsCadastroEndereco.DTOGradeCor> getGradesDTO(List<WmsEnderecoGradeCor> gradesCores) {
        LinkedList<DTOWmsCadastroEndereco.DTOGradeCor> a = new LinkedList<DTOWmsCadastroEndereco.DTOGradeCor>();
        for (WmsEnderecoGradeCor gc : gradesCores) {
            DTOWmsCadastroEndereco.DTOGradeCor dto = new DTOWmsCadastroEndereco.DTOGradeCor();
            dto.setIdentificador(gc.getIdentificador());
            if (gc.getGradeCor() != null) {
                dto.setGradeCor(gc.getGradeCor().toString());
                dto.setGradeCorIdentificador(gc.getGradeCor().getIdentificador());
                dto.setProdutoCodigoAuxiliar(gc.getGradeCor().getProdutoGrade().getProduto().getCodigoAuxiliar());
                dto.setProdutoIdentificador(gc.getGradeCor().getProdutoGrade().getProduto().getIdentificador());
                dto.setProdutoNome(gc.getGradeCor().getProdutoGrade().getProduto().getNome());
                dto.setProdutoUnidadeMedida(gc.getGradeCor().getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
            }
            a.add(dto);
        }
        return a;
    }

    public <Z> Z getCadastroEmp(CapsEmpresa capsEmpresaLogado, Class<Z> aClass) {
        WmsCadastroEndereco cad = ((DaoWmsCadastroEnderecoImpl)this.getGenericDao()).get(this.getSharedData().getEmpresa(capsEmpresaLogado.get()));
        if (cad == null) {
            return null;
        }
        return this.buildToDTO(cad, aClass);
    }
}

