/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmsentradaestoque;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.WmsEnderecoGradeCor;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoqueGrade;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.impl.RulesWmsEntradaProdutos;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemDiferencas;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGradeLoteFabricacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoWmsEntradaEstoqueImpl;
import com.touchcomp.basementorservice.helpers.impl.wmsentradaprodutos.HelperWmsEntradaProdutos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoGradeCorImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.totalizadoresitemgrade.web.DTOTotalItemDiferencas;
import com.touchcomp.touchvomodel.vo.totalizadoresitemgrade.web.DTOTotalItemGradeLoteFabricacao;
import com.touchcomp.touchvomodel.vo.wmsentradaestoque.web.DTOWmsEntradaEstoque;
import com.touchcomp.touchvomodel.vo.wmsentradaestoque.web.DTOWmsEntradaRes;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsEntradaEstoqueImpl
extends ServiceGenericEntityImpl<WmsEntradaEstoque, Long, DaoWmsEntradaEstoqueImpl> {
    final ServiceGradeCorImpl serviceGradeCor;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    final ServiceWmsEnderecoGradeCorImpl serviceWmsEnderecoGradeCorImpl;
    final HelperWmsEntradaProdutos helperWmsEntProd;
    final RulesWmsEntradaProdutos rulesWmsEntrada;

    @Autowired
    public ServiceWmsEntradaEstoqueImpl(DaoWmsEntradaEstoqueImpl dao, ServiceGradeCorImpl serviceGradeCor, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceWmsEnderecoGradeCorImpl serviceWmsEnderecoGradeCorImpl, HelperWmsEntradaProdutos helperWmsEntProd, RulesWmsEntradaProdutos rulesWmsEntrada) {
        super(dao);
        this.serviceGradeCor = serviceGradeCor;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceWmsEnderecoGradeCorImpl = serviceWmsEnderecoGradeCorImpl;
        this.helperWmsEntProd = helperWmsEntProd;
        this.rulesWmsEntrada = rulesWmsEntrada;
    }

    public DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueItem getNovoItemGrade(Long idGrade, Empresa empresa) {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (gradeCor == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        LinkedList<DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade> ret = new LinkedList<DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade>();
        ret.add(this.convertGrade(gradeCor, empresa));
        DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueItem item = new DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueItem();
        item.setGrades(ret);
        item.setProduto(gradeCor.getProdutoGrade().getProduto().toString());
        item.setProdutoCodigoAuxiliar(gradeCor.getProdutoGrade().getProduto().getCodigoAuxiliar());
        item.setProdutoIdentificador(gradeCor.getProdutoGrade().getProduto().getIdentificador());
        item.setProdutoUnidadeMedida(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
        if (ret.size() == 1) {
            item.setWmsEndereco(((DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade)item.getGrades().get(0)).getWmsEndereco());
            item.setWmsEnderecoIdentificador(((DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade)item.getGrades().get(0)).getWmsEnderecoIdentificador());
        }
        return item;
    }

    public DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade getNovaGrade(Long idGrade, Empresa empresa) {
        GradeCor grade = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (grade == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        return this.convertGrade(grade, empresa);
    }

    DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade convertGrade(GradeCor grade, Empresa empresa) {
        LoteFabricacao lt;
        DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade gr = new DTOWmsEntradaEstoque.DTOWmsEntradaEstoqueGrade();
        gr.setDataEntrada(Long.valueOf(new Date().getTime()));
        gr.setGradeCor(grade.toString());
        gr.setGradeCorIdentificador(grade.getIdentificador());
        if (this.isAffimative(grade.getProdutoGrade().getProduto().getLoteUnico()) && (lt = this.serviceLoteFabricacaoImpl.findLoteUnico(grade)) != null) {
            gr.setLoteFabricacao(lt.toString());
            gr.setLoteFabricacaoIdentificador(lt.getIdentificador());
            gr.setLoteFabricacaoDataFabricacao(lt.getDataFabricacao() != null ? Long.valueOf(lt.getDataFabricacao().getTime()) : null);
            gr.setLoteFabricacaoDataValidade(lt.getDataValidade() != null ? Long.valueOf(lt.getDataValidade().getTime()) : null);
        }
        gr.setEmpresa(empresa.toString());
        gr.setEmpresaIdentificador(empresa.getIdentificador());
        WmsEnderecoGradeCor end = this.serviceWmsEnderecoGradeCorImpl.getFirstByGradeCor(grade);
        if (end != null && end.getWmsEndereco() != null) {
            gr.setWmsEndereco(end.getWmsEndereco().toString());
            gr.setWmsEnderecoIdentificador(end.getWmsEndereco().getIdentificador());
        }
        return gr;
    }

    @Override
    public WmsEntradaEstoque beforeSave(WmsEntradaEstoque aux) {
        aux.getItens().forEach(i -> {
            boolean gradeU = i.getGrades().size() == 1;
            for (WmsEntradaEstoqueGrade grade : i.getGrades()) {
                grade.setWmsEntradaEstoqueItem(i);
                grade.setDataEntrada(aux.getDataEntrada());
                grade.setEmpresa(aux.getEmpresa());
                if (gradeU || !ToolMethods.isWithData((Number)grade.getQuantidade())) {
                    grade.setQuantidade(i.getQuantidadeTotal());
                }
                if (gradeU && i.getWmsEndereco() == null && grade.getWmsEndereco() != null) {
                    i.setWmsEndereco(grade.getWmsEndereco());
                }
                grade.setEfetivarEntrada(aux.getEfetivarEntrada());
                if (ToolMethods.isNull((Object)grade.getWmsEndereco()).booleanValue()) {
                    grade.setWmsEndereco(i.getWmsEndereco());
                }
                if (!gradeU || ToolMethods.isEquals((Object)grade.getWmsEndereco(), (Object)i.getWmsEndereco())) continue;
                i.setWmsEndereco(grade.getWmsEndereco());
            }
            i.setWmsEntradaEstoque(aux);
        });
        this.helperWmsEntProd.build(aux).calcularTotais();
        return aux;
    }

    public List<DTOWmsEntradaRes> getEntradasEmAberto(Short filtrarData, Date dataIn, Date dataFim, Empresa empresa) {
        List<WmsEntradaEstoque> ents = ((DaoWmsEntradaEstoqueImpl)this.getDao()).getEntradasEmAberto(filtrarData, dataIn, dataFim, empresa);
        LinkedList<DTOWmsEntradaRes> aux = new LinkedList<DTOWmsEntradaRes>();
        for (WmsEntradaEstoque ent : ents) {
            DTOWmsEntradaRes d = new DTOWmsEntradaRes();
            d.setDataEntrada(Long.valueOf(ent.getDataEntrada().getTime()));
            d.setDescricao(ent.getDescricao());
            d.setObservacao(ent.getObservacao());
            d.setIdentificador(ent.getIdentificador());
            d.setPesoTotal(ent.getPesoTotal());
            d.setQuantidadeTotal(ent.getQuantidadeTotal());
            d.setVolumeTotal(ent.getVolumeTotal());
            if (ent.getComunicadoProducao() != null) {
                d.setIdOrigem(ent.getComunicadoProducao().getIdentificador());
                d.setOrigem(ent.getComunicadoProducao().toString());
            }
            if (ent.getImplantacaoSaldos() != null) {
                d.setIdOrigem(ent.getImplantacaoSaldos().getIdentificador());
                d.setOrigem(ent.getImplantacaoSaldos().toString());
            }
            if (ent.getNotaFiscalPropria() != null) {
                d.setIdOrigem(ent.getNotaFiscalPropria().getIdentificador());
                d.setOrigem(ent.getNotaFiscalPropria().toString());
            }
            if (ent.getNotaFiscalTerceiros() != null) {
                d.setIdOrigem(ent.getNotaFiscalTerceiros().getIdentificador());
                d.setOrigem(ent.getNotaFiscalTerceiros().toString());
            }
            aux.add(d);
        }
        return aux;
    }

    public List getResumoItensOrigem(DTOWmsEntradaEstoque d, Class aClass) throws ExceptionReflection {
        WmsEntradaEstoque w = (WmsEntradaEstoque)this.buildToEntity(d);
        this.beforeSave(w);
        List aux = this.rulesWmsEntrada.getResumoItens(w);
        LinkedList<DTOTotalItemGradeLoteFabricacao> ret = new LinkedList<DTOTotalItemGradeLoteFabricacao>();
        for (TotalItemGradeLoteFabricacao t : aux) {
            DTOTotalItemGradeLoteFabricacao dt = new DTOTotalItemGradeLoteFabricacao();
            dt.setQuantidadeTotal(t.getQuantidadeTotal());
            if (!ToolMethods.isNull((Object)t.getGradeCor()).booleanValue()) {
                dt.setGradeCor(t.getGradeCor().getCor().getNome());
                dt.setGradeCorIdentificador(t.getGradeCor().getIdentificador());
                dt.setProduto(t.getGradeCor().getProdutoGrade().getProduto().getNome());
                dt.setProdutoCodigoAuxiliar(t.getGradeCor().getProdutoGrade().getProduto().getCodigoAuxiliar());
                dt.setProdutoIdentificador(t.getGradeCor().getProdutoGrade().getProduto().getIdentificador());
                dt.setProdutoUnidadeMedida(t.getGradeCor().getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
            }
            if (!ToolMethods.isNull((Object)t.getLoteFabricacao()).booleanValue()) {
                dt.setLoteFabricacaoIdentificador(t.getLoteFabricacao().getIdentificador());
                dt.setLoteFabricacaoLoteFabricacao(t.getLoteFabricacao().getLoteFabricacao());
                dt.setLoteFabricacaoDataValidade(t.getLoteFabricacao().getDataValidade());
            }
            ret.add(dt);
        }
        return ret;
    }

    public List getResumoItensOrigemDiferenca(DTOWmsEntradaEstoque d, Class aClass) throws ExceptionReflection {
        WmsEntradaEstoque w = (WmsEntradaEstoque)this.buildToEntity(d);
        this.beforeSave(w);
        List<TotalItemDiferencas<TotalItemGradeLoteFabricacao>> aux = this.helperWmsEntProd.build(w).getResumoItensDiferenca();
        LinkedList<DTOTotalItemDiferencas> ret = new LinkedList<DTOTotalItemDiferencas>();
        for (TotalItemDiferencas<TotalItemGradeLoteFabricacao> t : aux) {
            DTOTotalItemDiferencas dt = new DTOTotalItemDiferencas();
            dt.setQuantidadeDestino(t.getQuantidadeDestino());
            dt.setQuantidadeDiferenca(t.getQuantidadeDiferenca());
            dt.setQuantidadeOrigem(t.getQuantidadeOrigem());
            DTOTotalItemGradeLoteFabricacao dti = new DTOTotalItemGradeLoteFabricacao();
            if (t.getSource() != null && ((TotalItemGradeLoteFabricacao)t.getSource()).getGradeCor() != null) {
                dti.setGradeCor(((TotalItemGradeLoteFabricacao)t.getSource()).getGradeCor().getCor().getNome());
                dti.setGradeCorIdentificador(((TotalItemGradeLoteFabricacao)t.getSource()).getGradeCor().getIdentificador());
                dti.setProduto(((TotalItemGradeLoteFabricacao)t.getSource()).getGradeCor().getProdutoGrade().getProduto().getNome());
                dti.setProdutoCodigoAuxiliar(((TotalItemGradeLoteFabricacao)t.getSource()).getGradeCor().getProdutoGrade().getProduto().getCodigoAuxiliar());
                dti.setProdutoIdentificador(((TotalItemGradeLoteFabricacao)t.getSource()).getGradeCor().getProdutoGrade().getProduto().getIdentificador());
                dti.setProdutoUnidadeMedida(((TotalItemGradeLoteFabricacao)t.getSource()).getGradeCor().getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
            }
            if (t.getSource() != null && ((TotalItemGradeLoteFabricacao)t.getSource()).getLoteFabricacao() != null) {
                dti.setLoteFabricacaoDataValidade(((TotalItemGradeLoteFabricacao)t.getSource()).getLoteFabricacao().getDataValidade());
                dti.setLoteFabricacaoLoteFabricacao(((TotalItemGradeLoteFabricacao)t.getSource()).getLoteFabricacao().getLoteFabricacao());
                dti.setLoteFabricacaoIdentificador(((TotalItemGradeLoteFabricacao)t.getSource()).getLoteFabricacao().getIdentificador());
            }
            if (t.getSource() != null) {
                dti.setPesoBruto(((TotalItemGradeLoteFabricacao)t.getSource()).getPesoBruto());
                dti.setPesoLiquido(((TotalItemGradeLoteFabricacao)t.getSource()).getPesoLiquido());
                dti.setQuantidadeTotal(((TotalItemGradeLoteFabricacao)t.getSource()).getQuantidadeTotal());
                dti.setVolumeTotal(((TotalItemGradeLoteFabricacao)t.getSource()).getVolumeTotal());
            }
            dt.setSource((Object)dti);
            ret.add(dt);
        }
        return ret;
    }

    @Override
    public boolean deleteOnly(WmsEntradaEstoque entity) {
        String errorCode = "E.ERP.1912.002";
        if (entity.getTransferenciaEstEntrada() != null) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail(errorCode, new Object[]{entity.getTransferenciaEstEntrada()}));
        }
        if (entity.getComunicadoProducao() != null) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail(errorCode, new Object[]{entity.getComunicadoProducao()}));
        }
        if (entity.getImplantacaoSaldos() != null) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail(errorCode, new Object[]{entity.getImplantacaoSaldos()}));
        }
        if (entity.getNotaFiscalPropria() != null) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail(errorCode, new Object[]{entity.getNotaFiscalPropria()}));
        }
        if (entity.getNotaFiscalTerceiros() != null) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail(errorCode, new Object[]{entity.getNotaFiscalTerceiros()}));
        }
        return super.deleteOnly(entity);
    }
}

