/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmsopcoes;

import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpSections;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpcoesOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsOpcoesOp;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoWmsOpcoesImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsOpcoesImpl
extends ServiceGenericEntityImpl<WmsOpcoes, Long, DaoWmsOpcoesImpl> {
    private HelperWmsOpcoes helperWmsOpcoes;

    @Autowired
    public ServiceWmsOpcoesImpl(DaoWmsOpcoesImpl dao, HelperWmsOpcoes helperWmsOpcoes) {
        super(dao);
        this.helperWmsOpcoes = helperWmsOpcoes;
    }

    @Override
    public WmsOpcoes get(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public WmsOpcoes getByIdEmpresa(Long idEmpresa) {
        return ((DaoWmsOpcoesImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public WmsOpcoes getByIdEmpresaOrThrow(Long idEmpresa) throws ExceptionObjNotFound {
        WmsOpcoes wmsop = this.getByIdEmpresa(idEmpresa);
        this.throwIfNull(wmsop, idEmpresa);
        return wmsop;
    }

    public <Z> Z getByIdEmpresaDTO(Long identificador, Class<Z> aClass) {
        WmsOpcoes wms = this.getByIdEmpresa(identificador);
        return this.buildToDTO(wms, aClass);
    }

    @Override
    public WmsOpcoes beforeSaveEntity(WmsOpcoes entity) {
        for (WmsOpcoesOp op : entity.getOpcoesWmsOp()) {
            op.setWmsOpcoes(entity);
        }
        return entity;
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        WmsOpcoes op = (WmsOpcoes)this.get(idOpcoes);
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helperWmsOpcoes.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstWmsOpSections.values(), (EnumOpDinamicasInterface[])EnumConstWmsOpcoesOp.values());
        return din;
    }
}

